/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.es;

import com.simsilica.es.EntityComponent;

public class Decay
implements EntityComponent {
    public static final long MILLIS_TO_NANOS = 1000000L;
    public static final long SECS_TO_NANOS = 1000000000L;
    private long startTime;
    private long endTime;

    public Decay() {
    }

    public Decay(long endTime) {
        this.startTime = System.nanoTime();
        this.endTime = endTime;
    }

    public static Decay futureSeconds(double delay) {
        return new Decay(System.nanoTime() + Math.round(delay * 1.0E9));
    }

    public static Decay futureMillis(long delay) {
        return new Decay(System.nanoTime() + (long)Math.round(delay * 1000000L));
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getPercent(long time) {
        if (time >= this.endTime) {
            return 1.0;
        }
        return (double)(time - this.startTime) / (double)(this.endTime - this.startTime);
    }

    public double getPercent() {
        return this.getPercent(System.nanoTime());
    }

    public String toString() {
        return "Deacy[" + this.endTime + "]";
    }
}

