/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network;

import com.jme3.network.Client;
import com.jme3.network.NetworkClient;
import com.jme3.network.Server;
import com.jme3.network.base.DefaultClient;
import com.jme3.network.base.DefaultServer;
import com.jme3.network.base.TcpConnectorFactory;
import com.jme3.network.kernel.tcp.SelectorKernel;
import com.jme3.network.kernel.tcp.SocketConnector;
import com.jme3.network.kernel.udp.UdpConnector;
import com.jme3.network.kernel.udp.UdpKernel;
import java.io.IOException;
import java.net.InetAddress;

public class Network {
    public static final String DEFAULT_GAME_NAME = "Unnamed jME3 Game";
    public static final int DEFAULT_VERSION = 42;

    public static Server createServer(int port) throws IOException {
        return Network.createServer(DEFAULT_GAME_NAME, 42, port, port);
    }

    public static Server createServer(int tcpPort, int udpPort) throws IOException {
        return Network.createServer(DEFAULT_GAME_NAME, 42, tcpPort, udpPort);
    }

    public static Server createServer(String gameName, int version, int tcpPort, int udpPort) throws IOException {
        UdpKernel fast = udpPort == -1 ? null : new UdpKernel(udpPort);
        SelectorKernel reliable = new SelectorKernel(tcpPort);
        return new DefaultServer(gameName, version, reliable, fast);
    }

    public static NetworkClient createClient() {
        return Network.createClient(DEFAULT_GAME_NAME, 42);
    }

    public static NetworkClient createClient(String gameName, int version) {
        return new NetworkClientImpl(gameName, version);
    }

    public static Client connectToServer(String host, int hostPort) throws IOException {
        return Network.connectToServer(DEFAULT_GAME_NAME, 42, host, hostPort, hostPort);
    }

    public static Client connectToServer(String host, int hostPort, int remoteUdpPort) throws IOException {
        return Network.connectToServer(DEFAULT_GAME_NAME, 42, host, hostPort, remoteUdpPort);
    }

    public static Client connectToServer(String gameName, int version, String host, int hostPort) throws IOException {
        return Network.connectToServer(gameName, version, host, hostPort, hostPort);
    }

    public static Client connectToServer(String gameName, int version, String host, int hostPort, int remoteUdpPort) throws IOException {
        InetAddress remoteAddress = InetAddress.getByName(host);
        UdpConnector fast = remoteUdpPort == -1 ? null : new UdpConnector(remoteAddress, remoteUdpPort);
        SocketConnector reliable = new SocketConnector(remoteAddress, hostPort);
        return new DefaultClient(gameName, version, reliable, fast, new TcpConnectorFactory(remoteAddress));
    }

    protected static class NetworkClientImpl
    extends DefaultClient
    implements NetworkClient {
        public NetworkClientImpl(String gameName, int version) {
            super(gameName, version);
        }

        @Override
        public void connectToServer(String host, int port, int remoteUdpPort) throws IOException {
            this.connectToServer(InetAddress.getByName(host), port, remoteUdpPort);
        }

        @Override
        public void connectToServer(InetAddress address, int port, int remoteUdpPort) throws IOException {
            UdpConnector fast = new UdpConnector(address, remoteUdpPort);
            SocketConnector reliable = new SocketConnector(address, port);
            this.setPrimaryConnectors(reliable, fast, new TcpConnectorFactory(address));
        }
    }
}

