/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.message;

import com.jme3.network.AbstractMessage;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.StringSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;

@Serializable
public class ClientRegistrationMessage
extends AbstractMessage {
    public static final short SERIALIZER_ID = -44;
    private long id;
    private String gameName;
    private int version;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setGameName(String name) {
        this.gameName = name;
    }

    public String getGameName() {
        return this.gameName;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.id + ", gameName=" + this.gameName + ", version=" + this.version + "]";
    }

    public static class ClientRegistrationSerializer
    extends Serializer {
        public ClientRegistrationMessage readObject(ByteBuffer data, Class c) throws IOException {
            if (data.get() == 0) {
                return null;
            }
            ClientRegistrationMessage msg = new ClientRegistrationMessage();
            msg.gameName = StringSerializer.readString(data);
            msg.id = data.getLong();
            msg.version = data.getInt();
            return msg;
        }

        @Override
        public void writeObject(ByteBuffer buffer, Object object) throws IOException {
            buffer.put((byte)(object != null ? 1 : 0));
            if (object == null) {
                return;
            }
            ClientRegistrationMessage msg = (ClientRegistrationMessage)object;
            StringSerializer.writeString(msg.gameName, buffer);
            buffer.putLong(msg.id);
            buffer.putInt(msg.version);
        }
    }
}

