/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.audio.AudioNode;
import com.jme3.math.Vector3f;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.Level;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.ScoreState;
import com.simsilica.mattacks.ScriptManager;
import com.simsilica.mattacks.SoundCommand;
import com.simsilica.mattacks.achievement.Achievement;
import com.simsilica.mattacks.achievement.AchievementContext;
import com.simsilica.mattacks.achievement.AchievementRule;
import com.simsilica.mattacks.achievement.AchievementType;
import com.simsilica.mattacks.achievement.Achievements;
import com.simsilica.mattacks.db.Player;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class AchievementsState
extends BaseAppState {
    private final AchievementContext achievements = new AchievementContext();
    private final ScriptManager scripts = new ScriptManager("/com/simsilica/mattacks/achievements-api.groovy");
    private LinkedList<Message> popups = new LinkedList();
    private Message current;
    private Container popup;
    private Label popupMessage;
    private SoundCommand unlocked;
    private Player currentPlayer;

    public void setCurrentPlayer(Player currentPlayer) {
        if (this.currentPlayer == currentPlayer) {
            return;
        }
        this.currentPlayer = currentPlayer;
        this.achievements.getAchievements().clear();
        System.out.println("Achievement player:" + currentPlayer);
        if (currentPlayer != null) {
            currentPlayer.loadCurrentStats();
            Collection<Achievement> c = currentPlayer.getAchievements();
            System.out.println("Loaded achievements:" + c);
            if (c != null) {
                this.achievements.getAchievements().addAll(c);
            }
        }
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public Collection<AchievementRule> getRules() {
        return this.achievements.getRules();
    }

    public Collection<AchievementRule> getRules(AchievementType type) {
        return this.achievements.getRules().getRules(type);
    }

    public VersionedReference<Achievements> createAchievementsRef() {
        return this.achievements.getAchievements().createReference();
    }

    public String getToday() {
        return this.achievements.getToday();
    }

    public String getThisWeek() {
        return this.achievements.getThisWeek();
    }

    public void setLevelStats(Level level, ScoreState.Stats stats) {
        System.out.println("setLevelStats(" + stats + ")");
        this.scripts.setBinding("currentLevel", level);
        this.scripts.setBinding("currentScore", stats);
        this.achievements.put("level", level);
        this.achievements.put("category", level.getCategory());
        this.achievements.put("levelName", level.getName());
        Calendar cal = Calendar.getInstance();
        int week = cal.get(3);
        int day = cal.get(7);
        System.out.println("Day:" + day + "  Week:" + week);
        this.achievements.put("day", week + ":" + day);
        this.achievements.put("week", String.valueOf(week));
        this.achievements.setup();
        ArrayList<Achievement> added = new ArrayList<Achievement>();
        if (this.achievements.evaluateRules(AchievementType.Level, added)) {
            while (this.achievements.evaluateOtherRules(AchievementType.Level, added)) {
                System.out.println("Need to re-evaluate.");
            }
        } else {
            while (this.achievements.evaluateOtherRules(AchievementType.Level, added)) {
                System.out.println("Need to re-evaluate.");
            }
        }
        LinkedHashMap<String, Achievement> best = new LinkedHashMap<String, Achievement>();
        ArrayList<Achievement> toRemove = new ArrayList<Achievement>();
        for (Achievement a : added) {
            String id = a.getId();
            if (id == null) continue;
            Achievement b = (Achievement)best.get(id);
            if (b == null) {
                best.put(id, a);
                continue;
            }
            if (a.score > b.score) {
                best.put(id, a);
                toRemove.add(b);
                continue;
            }
            toRemove.add(a);
        }
        added.removeAll(toRemove);
        for (Achievement a : added) {
            this.popups.add(new Message(a.getMessage()));
        }
        this.currentPlayer.setAchievements(this.achievements.getAchievements());
        this.currentPlayer.save();
    }

    @Override
    protected void initialize(Application app) {
        EntityData ed = this.getState(EntityDataState.class).getEntityData();
        this.scripts.setBinding("ed", ed);
        this.scripts.setBinding("achievementsContext", this.achievements);
        this.scripts.setBinding("achievements", this.achievements.getAchievements());
        this.scripts.runScriptResource("/com/simsilica/mattacks/standard-achievements.groovy");
        this.popup = new Container(new ElementId("achievement.container"));
        this.popup.addChild(new Label("Achievement Unlocked", new ElementId("achievement.title.label")), new Object[0]);
        this.popupMessage = this.popup.addChild(new Label("No message", new ElementId("achievement.message.label")), new Object[0]);
        Vector3f pref = this.popup.getPreferredSize();
        this.popup.setAlpha(0.0f);
        this.unlocked = new SoundCommand(new AudioNode(app.getAssetManager(), "Sounds/powerUp11.ogg"));
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        ((Main)this.getApplication()).getGuiNode().attachChild(this.popup);
    }

    @Override
    public void update(float tpf) {
        if (this.current != null) {
            if (!this.current.update(tpf)) {
                this.current = null;
            }
        } else if (!this.popups.isEmpty()) {
            this.current = this.popups.removeFirst();
            this.current.start();
        }
    }

    @Override
    protected void onDisable() {
        this.popup.removeFromParent();
    }

    private class Message {
        float time = 0.0f;
        float timeScale = 1.0f;
        String text;
        float y = 0.0f;
        float x = 0.0f;
        float yTarget = 0.0f;
        float xTarget = 0.0f;
        boolean playSound = true;

        public Message(String text) {
            this.text = text;
        }

        public void start() {
            AchievementsState.this.popupMessage.setText(this.text);
            Vector3f pref = AchievementsState.this.popup.getPreferredSize();
            this.yTarget = pref.y + 40.0f;
            this.x = 0.0f;
            this.xTarget = 30.0f;
        }

        public boolean update(float tpf) {
            this.time += tpf * this.timeScale;
            if ((double)this.time >= 1.5) {
                this.timeScale = -1.0f;
            }
            if (this.time > 1.0f && this.playSound) {
                AchievementsState.this.unlocked.execute((Button)null);
                this.playSound = false;
            }
            float t = (float)Math.sin((double)Math.min(1.0f, this.time) * Math.PI * 0.5);
            this.y = this.yTarget * Math.min(1.0f, t);
            this.x = this.xTarget * Math.min(1.0f, t);
            AchievementsState.this.popup.setLocalTranslation(this.x, this.y, 50.0f);
            AchievementsState.this.popup.setAlpha(Math.min(1.0f, t));
            return this.time >= 0.0f;
        }
    }
}

