/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mattacks.AchievementsState;
import com.simsilica.mattacks.AnswerDisplayState;
import com.simsilica.mattacks.AnswerState;
import com.simsilica.mattacks.CompositeAppState;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.ExplosionState;
import com.simsilica.mattacks.FlashCardState;
import com.simsilica.mattacks.InGameMenuState;
import com.simsilica.mattacks.Level;
import com.simsilica.mattacks.LevelFactory;
import com.simsilica.mattacks.LevelSelectionState;
import com.simsilica.mattacks.LevelState;
import com.simsilica.mattacks.MainFunctions;
import com.simsilica.mattacks.NumberPadState;
import com.simsilica.mattacks.PauseState;
import com.simsilica.mattacks.ScoreState;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.StarFieldState;
import com.simsilica.mattacks.TitleState;

public class GameState
extends CompositeAppState {
    private EntityData ed;
    private LevelFactory current;

    public GameState(LevelFactory start) {
        super(new PauseState(), new InGameMenuState(), new FlashCardState(), new AnswerState(), new ScoreState(), new NumberPadState(), new ExplosionState(), new AnswerDisplayState());
        this.setOverrideEnabled(this.getChild(PauseState.class), false, true);
        this.setOverrideEnabled(this.getChild(InGameMenuState.class), false, true);
        this.setOverrideEnabled(this.getChild(NumberPadState.class), false, true);
        this.current = start;
    }

    public void nextLevel() {
        this.current = this.getState(LevelSelectionState.class).getNextLevel(this.current);
        if (this.current != null) {
            this.startLevel();
        } else {
            this.returnToLevelSelect();
        }
    }

    public void levelComplete(LevelState levelState) {
        this.getState(SoundState.class).fadeMusic("Sounds/SpaceRace.ogg", 2.0f);
        String title = null;
        StringBuilder message = new StringBuilder();
        CallMethodAction next = null;
        ScoreState.Stats stats = this.getState(ScoreState.class).getCurrentStats();
        message.append((int)(stats.getPercent() * 100.0) + "% correct.");
        this.getState(AchievementsState.class).setLevelStats(levelState.getLevel(), stats);
        if (stats.getPercent() > 0.7) {
            LevelFactory nextLevel = this.getState(LevelSelectionState.class).getNextLevel(this.current);
            title = stats.getPercent() == 1.0 ? "Perfect Level!" : "Level Complete!";
            if (nextLevel != null) {
                boolean newCategory;
                boolean bl = newCategory = !nextLevel.getCategory().equals(this.current.getCategory());
                next = newCategory ? new CallMethodAction("Next Category:" + nextLevel.getCategory(), this.getState(GameState.class), "nextLevel") : new CallMethodAction(this.getState(GameState.class), "nextLevel");
            }
        } else {
            title = "Level Failed";
            next = new CallMethodAction("Replay Level.", this.getState(GameState.class), "startLevel");
        }
        CallMethodAction back = new CallMethodAction(this.getState(GameState.class), "returnToLevelSelect");
        message.append("\n");
        message.append("Correct:" + stats.correct + "\n");
        message.append("Incorrect:" + stats.incorrect + "\n");
        message.append("Unanswered:" + stats.miss);
        TitleState titleState = new TitleState(title, message.toString(), null, -1.0f, next, back);
        titleState.addJoined(levelState);
        this.addChild(titleState);
    }

    public void returnToLevelSelect() {
        if (this.getState(LevelState.class) != null) {
            this.getStateManager().detach(this.getState(LevelState.class));
        }
        this.getStateManager().detach(this);
        this.getState(LevelSelectionState.class).setEnabled(true);
        this.getState(SoundState.class).fadeMusic("Sounds/SpaceRace.ogg", 1.0f);
    }

    @Override
    protected void initialize(Application app) {
        super.initialize(app);
        this.ed = this.getState(EntityDataState.class).getEntityData();
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
    }

    @Override
    protected void cleanup(Application app) {
        super.cleanup(app);
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        GuiGlobals.getInstance().getInputMapper().activateGroup(MainFunctions.IN_GAME);
        this.startLevel();
    }

    protected void startLevel() {
        if (this.getState(LevelState.class) != null) {
            System.out.println("Removing old level state.");
            this.getStateManager().detach(this.getState(LevelState.class));
        }
        Level level = this.current.createLevel();
        LevelState levelState = new LevelState(level);
        TitleState title = new TitleState(level.getTitle(), level.getMessage(), levelState, 3.0f, new Action[0]);
        this.getState(StarFieldState.class).setVelocity(0.0f, level.getSpeed(), 0.0f);
        this.addChild(title);
    }

    @Override
    protected void onDisable() {
        GuiGlobals.getInstance().getInputMapper().deactivateGroup(MainFunctions.IN_GAME);
        super.onDisable();
    }
}

