/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.AchievementsState;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.GameState;
import com.simsilica.mattacks.LevelFactory;
import com.simsilica.mattacks.MainMenuState;
import com.simsilica.mattacks.ScriptManager;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.StarFieldState;
import com.simsilica.mattacks.achievement.Achievement;
import com.simsilica.mattacks.achievement.AchievementRule;
import com.simsilica.mattacks.achievement.AchievementType;
import com.simsilica.mattacks.achievement.Achievements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LevelSelectionState
extends BaseAppState {
    private final ScriptManager levelScripts = new ScriptManager("/com/simsilica/mattacks/level-api.groovy");
    private final Multimap<String, LevelFactory> factories = LinkedHashMultimap.create();
    private final List<LevelFactory> inOrder = new ArrayList<LevelFactory>();
    private Container window;
    private IconComponent on;
    private IconComponent off;
    private final Map<LevelFactory, Label> levelStatusIndex = new HashMap<LevelFactory, Label>();
    private final Map<String, Label> categoryTitles = new HashMap<String, Label>();
    private VersionedReference<Achievements> achievementsRef;
    private Map<Integer, IconComponent> statusIcons = new HashMap<Integer, IconComponent>();
    private List<Goal> goalTracker = new ArrayList<Goal>();

    public LevelSelectionState() {
        this.setEnabled(false);
    }

    public void backToMainMenu() {
        this.setEnabled(false);
        this.getState(MainMenuState.class).setEnabled(true);
    }

    protected void startLevel(LevelFactory factory) {
        this.getState(SoundState.class).fadeMusic("Sounds/Space-Prelude.ogg", 2.0f);
        this.setEnabled(false);
        this.getStateManager().attach(new GameState(factory));
    }

    protected void addIcon(int score, String name, ColorRGBA color) {
        IconComponent icon = new IconComponent(name);
        icon.setColor(color);
        icon.setMargin(5.0f, 0.0f);
        this.statusIcons.put(score, icon);
    }

    protected void setupIcons() {
        this.on = new IconComponent("/com/simsilica/lemur/icons/Glass-check-on.png", 1.0f, 0.0f, 0.0f, 1.0f, false);
        this.on.setColor(new ColorRGBA(0.5f, 0.9f, 0.9f, 0.9f));
        this.on.setMargin(5.0f, 0.0f);
        this.off = new IconComponent("Interface/blank.png", 1.0f, 0.0f, 0.0f, 1.0f, false);
        this.off.setColor(new ColorRGBA(0.6f, 0.8f, 0.8f, 0.8f));
        this.off.setMargin(5.0f, 0.0f);
        this.addIcon(1, "Interface/Check.png", new ColorRGBA(0.4f, 0.4f, 0.1f, 1.0f));
        this.addIcon(2, "Interface/Check.png", new ColorRGBA(0.1f, 0.9f, 0.2f, 1.0f));
        this.addIcon(3, "Interface/Star.png", new ColorRGBA(0.4f, 0.4f, 0.1f, 1.0f));
        this.addIcon(4, "Interface/Star.png", new ColorRGBA(0.7f, 0.7f, 0.8f, 1.0f));
        this.addIcon(5, "Interface/Star.png", new ColorRGBA(0.9f, 0.9f, 0.1f, 1.0f));
    }

    protected String getThisWeek() {
        return this.getState(AchievementsState.class).getThisWeek();
    }

    protected String getToday() {
        return this.getState(AchievementsState.class).getToday();
    }

    protected void updateLevelStatus() {
        System.out.println("updateLevelStatus()");
        String today = this.getToday();
        for (LevelFactory f : this.inOrder) {
            IconComponent icon;
            Achievement a = this.achievementsRef.get().getLevelAchievement(f.getCategory(), f.getName(), today);
            if (a != null) {
                int score = a.score;
                System.out.println("  score:" + score);
                icon = this.statusIcons.get(a.score).clone();
            } else {
                icon = this.off.clone();
            }
            Label label = this.levelStatusIndex.get(f);
            label.setIcon(icon);
        }
        for (Goal g : this.goalTracker) {
            g.update();
        }
    }

    protected void updateCategoryStatus() {
        String today = this.getToday();
        for (Map.Entry<String, Label> e : this.categoryTitles.entrySet()) {
            IconComponent icon;
            Achievement a = this.achievementsRef.get().getCategoryAchievement(e.getKey(), today);
            if (a != null) {
                int score = a.score;
                icon = this.statusIcons.get(score).clone();
            } else {
                icon = this.off.clone();
            }
            Label label = e.getValue();
            icon.setHAlignment(HAlignment.Right);
            label.setIcon(icon);
        }
    }

    protected Container createCategoryPanel(String cat, Collection<LevelFactory> list) {
        Container outer = new Container(new ElementId("category.container"));
        Label title = outer.addChild(new Label(cat, new ElementId("category.label")), new Object[0]);
        this.categoryTitles.put(cat, title);
        IconComponent icon = this.off.clone();
        icon.setHAlignment(HAlignment.Right);
        title.setIcon(icon);
        Container sub = outer.addChild(new Container(), new Object[0]);
        ElementId bId = new ElementId("level.button");
        for (LevelFactory f : this.factories.get(cat)) {
            sub.addChild(new ActionButton((Action)new LevelSelectAction(f), bId), new Object[0]);
            Label done = sub.addChild(new Label("", new ElementId("done.label")), 1);
            done.setIcon(this.off.clone());
            this.levelStatusIndex.put(f, done);
        }
        return outer;
    }

    @Override
    protected void initialize(Application app) {
        this.setupIcons();
        EntityData ed = this.getState(EntityDataState.class).getEntityData();
        this.achievementsRef = this.getState(AchievementsState.class).createAchievementsRef();
        this.levelScripts.setBinding("ed", ed);
        this.levelScripts.runScriptResource("/com/simsilica/mattacks/standard-levels.groovy");
        List levels = (List)this.levelScripts.getBinding("levels");
        for (LevelFactory f : levels) {
            System.out.println("Adding level:" + f);
            this.factories.put(f.getCategory(), f);
        }
        this.inOrder.addAll(this.factories.values());
        this.window = new Container(new ElementId("window.container"));
        this.window.setBackground(null);
        Container left = this.window.addChild(new Container(new ElementId("column.container")), 0, 0);
        left.setBackground(null);
        Container right = this.window.addChild(new Container(new ElementId("column.container")), 0, 1);
        right.setBackground(null);
        Container selector = left.addChild(new Container(), new Object[0]);
        selector.addChild(new Label("Level Select", new ElementId("window.title")), new Object[0]);
        Container categories = selector.addChild(new Container((GuiLayout)new SpringGridLayout(), new ElementId("categories")), new Object[0]);
        ElementId headId = new ElementId("category.label");
        ElementId rowId = new ElementId("row");
        ElementId catId = new ElementId("category.container");
        int split = this.factories.keySet().size() / 2;
        int row = 0;
        int col = 0;
        for (String cat : this.factories.keySet()) {
            categories.addChild(this.createCategoryPanel(cat, this.factories.get(cat)), row, col);
            if (++col < split) continue;
            ++row;
            col = 0;
        }
        Container buttons = left.addChild(new Container(new ElementId("button.container")), new Object[0]);
        buttons.setBackground(null);
        buttons.setInsets(new Insets3f(30.0f, 0.0f, 0.0f, 0.0f));
        buttons.addChild(new ActionButton((Action)new CallMethodAction(this, "backToMainMenu"), new ElementId("main.button")), new Object[0]);
        Container goals = right.addChild(new Container(), 0, 1);
        goals.setBackground(null);
        goals.setInsets(new Insets3f(0.0f, 30.0f, 0.0f, 0.0f));
        Container weekly = goals.addChild(new Container(new ElementId("weekly.container")), new Object[0]);
        weekly.addChild(new Label("Weekly Goals:", new ElementId("goals.title.label")), new Object[0]);
        for (AchievementRule rule : this.getState(AchievementsState.class).getRules(AchievementType.Weekly)) {
            Goal g = new Goal(rule);
            weekly.addChild(g.container, new Object[0]);
            this.goalTracker.add(g);
        }
        Container daily = goals.addChild(new Container(new ElementId("daily.container")), new Object[0]);
        daily.addChild(new Label("Daily Goals:", new ElementId("goals.title.label")), new Object[0]);
        System.out.println("Daily layout:" + daily.getLayout());
        for (AchievementRule rule : this.getState(AchievementsState.class).getRules(AchievementType.Daily)) {
            Goal g = new Goal(rule);
            daily.addChild(g.container, new Object[0]);
            this.goalTracker.add(g);
        }
    }

    public LevelFactory getNextLevel(LevelFactory after) {
        int index = this.inOrder.indexOf(after);
        if (index < 0) {
            index = 0;
        }
        if (++index >= this.inOrder.size()) {
            return null;
        }
        return this.inOrder.get(index);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.getState(StarFieldState.class).setVelocity(0.0f, 10.0f, 0.0f);
        this.getState(SoundState.class).playMusic("Sounds/Space-Prelude.ogg");
        this.window.runEffect("open");
    }

    @Override
    public void update(float tpf) {
        if (this.achievementsRef.update()) {
            this.updateLevelStatus();
            this.updateCategoryStatus();
        }
    }

    @Override
    protected void onDisable() {
        this.window.runEffect("close");
    }

    private class Goal {
        AchievementRule rule;
        Container container;
        Label name;
        Label description;
        boolean done = false;

        public Goal(AchievementRule rule) {
            this.rule = rule;
            this.container = new Container(new ElementId("goal.container"));
            this.name = this.container.addChild(new Label(rule.getName(), new ElementId("goal.name.label")), new Object[0]);
            this.description = this.container.addChild(new Label(rule.getDescription(), new ElementId("goal.description.label")), new Object[0]);
            this.refreshState();
        }

        public void setDone(boolean b) {
            if (this.done == b) {
                return;
            }
            this.done = b;
            this.refreshState();
        }

        protected void refreshState() {
            if (this.done) {
                this.name.setText(this.rule.getName() + " : Done");
                this.container.setAlpha(0.2f);
            } else {
                this.name.setText(this.rule.getName());
                this.container.setAlpha(0.95f);
            }
        }

        public void update() {
            this.setDone(((Achievements)LevelSelectionState.this.achievementsRef.get()).hasProductFor(this.rule, LevelSelectionState.this.getThisWeek(), LevelSelectionState.this.getToday()));
        }
    }

    private class LevelSelectAction
    extends Action {
        private final LevelFactory factory;

        public LevelSelectAction(LevelFactory factory) {
            super(factory.getName());
            this.factory = factory;
        }

        @Override
        public void execute(Button source) {
            LevelSelectionState.this.startLevel(this.factory);
        }
    }
}

