/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.google.common.base.Function;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanel;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.component.TbtQuadBackgroundComponent;
import com.simsilica.lemur.component.TextEntryComponent;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.KeyAction;
import com.simsilica.lemur.event.KeyActionListener;
import com.simsilica.lemur.list.DefaultCellRenderer;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.AchievementsState;
import com.simsilica.mattacks.LevelSelectionState;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.MainFunctions;
import com.simsilica.mattacks.OptionConfigurationState;
import com.simsilica.mattacks.PlayerDbState;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.StarFieldState;
import com.simsilica.mattacks.db.NullPlayer;
import com.simsilica.mattacks.db.Player;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MainMenuState.class);
    private Container mainWindow;
    private Label mainTitle;
    private ListBox<Player> playerList;
    private ActionButton startGame;
    private VersionedReference<Set<Integer>> selection;
    private OptionPanel nameEntry;
    private TextField playerName;

    public void setAlpha(float alpha) {
        this.mainWindow.setAlpha(alpha);
    }

    public float getAlpha() {
        return this.mainWindow.getAlpha();
    }

    public void setTitleAlpha(float alpha) {
        this.mainTitle.setAlpha(alpha);
    }

    public float getTitleAlpha() {
        return this.mainTitle.getAlpha();
    }

    protected void startGame() {
        System.out.println("Start the game.");
        this.setEnabled(false);
        this.getState(AchievementsState.class).setCurrentPlayer(this.getSelectedPlayer());
        this.getState(LevelSelectionState.class).setEnabled(true);
    }

    protected void showCreatePlayer() {
        this.playerName.setText("");
        this.getState(OptionPanelState.class).show(this.nameEntry);
        GuiGlobals.getInstance().requestFocus(this.playerName);
    }

    protected Player getSelectedPlayer() {
        Integer index = this.playerList.getSelectionModel().getSelection();
        if (index == null) {
            return null;
        }
        return this.playerList.getModel().get(index);
    }

    protected void createPlayer() {
        String newName = this.playerName.getText().trim();
        if (newName.length() == 0) {
            return;
        }
        Player newPlayer = this.getState(PlayerDbState.class).createPlayer(newName);
        if (newPlayer != null) {
            this.playerList.getModel().add(newPlayer);
            int index = this.playerList.getModel().indexOf(newPlayer);
            this.playerList.getSelectionModel().setSelection(index);
        }
    }

    protected void cancel() {
    }

    protected void options() {
        Vector3f loc = this.mainWindow.getLocalTranslation();
        Vector3f size = this.mainWindow.getSize();
        this.getState(OptionConfigurationState.class).open(loc.x + size.x, loc.y, loc.z + 10.0f);
    }

    protected void about() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("Math Attack!");
        out.println("Simsilica, LLC http://simsilica.com/");
        out.println();
        out.println("Written by: Paul Speed");
        out.println("Music by: Paul Speed");
        out.println("Sprites by: http://kenney.nl/");
        out.println();
        out.println("Powered by:");
        out.println("  jMonkeyEngine");
        out.println("  Lemur UX");
        out.println("  Zay-ES");
        out.flush();
        this.getState(OptionPanelState.class).show("About", sw.toString(), new Action[0]);
    }

    protected void exit() {
        ((Main)this.getApplication()).exit();
    }

    @Override
    protected void initialize(Application app) {
        GuiGlobals.getInstance().getInputMapper().addDelegate(MainFunctions.F_EXIT, app, "exit");
        this.nameEntry = new OptionPanel("Create Player", "Enter a player name:", null, new CallMethodAction(this, "createPlayer"), new CallMethodAction(this, "cancel"));
        this.playerName = this.nameEntry.getContainer().addChild(new TextField(""), new Object[0]);
        KeyActionListener enter = new KeyActionListener(){

            @Override
            public void keyAction(TextEntryComponent source, KeyAction key) {
                if (source.getText().trim().length() > 0) {
                    MainMenuState.this.nameEntry.close();
                    MainMenuState.this.createPlayer();
                }
            }
        };
        this.playerName.getActionMap().put(new KeyAction(28, new int[0]), enter);
        this.playerName.getActionMap().put(new KeyAction(156, new int[0]), enter);
        this.mainWindow = new Container(new SpringGridLayout(), new ElementId("window.container"), null);
        this.mainWindow.setLocalTranslation(300.0f, 600.0f, 0.0f);
        this.mainTitle = new Label("");
        this.mainTitle.setIcon(new IconComponent("Interface/MathAttack-cropped.png", 1.0f, 0.0f, 0.0f, 0.01f, false));
        GuiGlobals globals = GuiGlobals.getInstance();
        Texture texture = globals.loadTexture("/com/simsilica/lemur/icons/bevel-quad.png", false, false);
        TbtQuadBackgroundComponent bg = TbtQuadBackgroundComponent.create(texture, 1.0f, 8, 8, 119, 119, 1.0f, false);
        bg.setColor(new ColorRGBA(0.2f, 0.8f, 0.8f, 0.8f));
        this.mainTitle.setBackground(bg);
        this.mainWindow.addChild(this.mainTitle, new Object[0]);
        Container columns = this.mainWindow.addChild(new Container(new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        columns.setBackground(null);
        Container column = columns.addChild(new Container(new ElementId("column.container")), new Object[0]);
        column.addChild(new Label("Select a player:"), new Object[0]).setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.playerList = column.addChild(new ListBox(), new Object[0]);
        DefaultCellRenderer<Player> cr = new DefaultCellRenderer<Player>(new ElementId("list.item"), "glass", new Function<Player, String>(){

            @Override
            public String apply(Player p) {
                return p.getName();
            }
        });
        this.playerList.setCellRenderer(cr);
        this.playerList.getModel().add(new NullPlayer("Guest Player"));
        for (Player p : this.getState(PlayerDbState.class).getPlayers()) {
            this.playerList.getModel().add(p);
        }
        this.playerList.setInsets(new Insets3f(0.0f, 10.0f, 0.0f, 10.0f));
        this.playerList.getSelectionModel().setSelection(0);
        this.selection = this.playerList.getSelectionModel().createReference();
        Container listButtons = column.addChild(new Container(), new Object[0]);
        listButtons.setInsets(new Insets3f(0.0f, 10.0f, 10.0f, 10.0f));
        listButtons.addChild(new ActionButton((Action)new CallMethodAction("Create Player", this, "showCreatePlayer"), new ElementId("main.button")), new Object[0]);
        column = columns.addChild(new Container(new ElementId("column.container")), new Object[0]);
        System.out.println("second column layout:" + column.getLayout());
        Container buttons = column.addChild(new Container(new ElementId("game.buttons.container")), new Object[0]);
        buttons.setInsets(new Insets3f(10.0f, 10.0f, 10.0f, 10.0f));
        this.startGame = buttons.addChild(new ActionButton((Action)new CallMethodAction(this, "startGame"), new ElementId("main.button")), new Object[0]);
        this.startGame.setEnabled(!this.selection.get().isEmpty());
        buttons.addChild(new ActionButton((Action)new CallMethodAction(this, "options"), new ElementId("main.button")), new Object[0]);
        buttons.addChild(new ActionButton((Action)new CallMethodAction(this, "about"), new ElementId("main.button")), new Object[0]);
        buttons.addChild(new ActionButton((Action)new CallMethodAction(this, "exit"), new ElementId("main.button")), new Object[0]);
    }

    @Override
    protected void cleanup(Application app) {
        GuiGlobals.getInstance().getInputMapper().removeDelegate(MainFunctions.F_EXIT, app, "exit");
    }

    @Override
    protected void onEnable() {
        this.getState(StarFieldState.class).setVelocity(0.0f, 10.0f, 0.0f);
        this.getState(SoundState.class).playMusic("Sounds/Space-Prelude.ogg");
        this.mainWindow.runEffect("open");
    }

    @Override
    public void update(float tpf) {
        if (this.selection.update()) {
            this.startGame.setEnabled(!this.selection.get().isEmpty());
        }
    }

    @Override
    protected void onDisable() {
        this.mainWindow.runEffect("close");
    }
}

