/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.simsilica.mattacks.ProblemSetFactory;
import com.simsilica.mattacks.es.FlashCard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProblemSets {
    public static ProblemSetFactory additionFactory(int aMin, int aMax, int bMin, int bMax) {
        return new Addition(aMin, aMax, bMin, bMax);
    }

    public static ProblemSetFactory subtractionFactory(int aMin, int aMax, int bMin, int bMax) {
        return new Subtraction(aMin, aMax, bMin, bMax);
    }

    public static ProblemSetFactory multiplicationFactory(int aMin, int aMax, int bMin, int bMax) {
        return new Multiplication(aMin, aMax, bMin, bMax);
    }

    public static ProblemSetFactory divisionFactory(int aMin, int aMax, int bMin, int bMax) {
        return new Division(aMin, aMax, bMin, bMax);
    }

    public static List<FlashCard> addSet(int total, int aMin, int aMax, int bMin, int bMax) {
        ArrayList<FlashCard> results = new ArrayList<FlashCard>();
        for (int a = aMin; a <= aMax; ++a) {
            for (int b = bMin; b <= bMax; ++b) {
                results.add(FlashCard.add(a, b));
            }
        }
        while (results.size() < total) {
            results.addAll(results);
        }
        Collections.shuffle(results);
        return results.subList(0, total);
    }

    public static List<FlashCard> subtractSet(int total, int aMin, int aMax, int bMin, int bMax) {
        ArrayList<FlashCard> results = new ArrayList<FlashCard>();
        for (int a = aMin; a <= aMax; ++a) {
            int max = Math.min(a, bMax);
            for (int b = bMin; b <= max; ++b) {
                results.add(FlashCard.subtract(a, b));
            }
        }
        while (results.size() < total) {
            results.addAll(results);
        }
        Collections.shuffle(results);
        return results.subList(0, total);
    }

    private static class Division
    implements ProblemSetFactory {
        private final int aMin;
        private final int aMax;
        private final int bMin;
        private final int bMax;

        public Division(int aMin, int aMax, int bMin, int bMax) {
            this.aMin = aMin;
            this.aMax = aMax;
            this.bMin = bMin;
            this.bMax = bMax;
        }

        @Override
        public List<FlashCard> createProblems(int total) {
            ArrayList<FlashCard> results = new ArrayList<FlashCard>();
            for (int a = this.aMin; a <= this.aMax; ++a) {
                for (int b = this.bMin; b <= this.bMax; ++b) {
                    int numerator = a * b;
                    results.add(FlashCard.divide(numerator, b));
                }
            }
            while (results.size() < total) {
                results.addAll(results);
            }
            Collections.shuffle(results);
            return results.subList(0, total);
        }
    }

    private static class Multiplication
    implements ProblemSetFactory {
        private final int aMin;
        private final int aMax;
        private final int bMin;
        private final int bMax;

        public Multiplication(int aMin, int aMax, int bMin, int bMax) {
            this.aMin = aMin;
            this.aMax = aMax;
            this.bMin = bMin;
            this.bMax = bMax;
        }

        @Override
        public List<FlashCard> createProblems(int total) {
            ArrayList<FlashCard> results = new ArrayList<FlashCard>();
            for (int a = this.aMin; a <= this.aMax; ++a) {
                for (int b = this.bMin; b <= this.bMax; ++b) {
                    results.add(FlashCard.multiply(a, b));
                }
            }
            while (results.size() < total) {
                results.addAll(results);
            }
            Collections.shuffle(results);
            return results.subList(0, total);
        }
    }

    private static class Subtraction
    implements ProblemSetFactory {
        private final int aMin;
        private final int aMax;
        private final int bMin;
        private final int bMax;

        public Subtraction(int aMin, int aMax, int bMin, int bMax) {
            this.aMin = aMin;
            this.aMax = aMax;
            this.bMin = bMin;
            this.bMax = bMax;
        }

        @Override
        public List<FlashCard> createProblems(int total) {
            ArrayList<FlashCard> results = new ArrayList<FlashCard>();
            for (int a = this.aMin; a <= this.aMax; ++a) {
                int max = Math.min(a, this.bMax);
                for (int b = this.bMin; b <= max; ++b) {
                    results.add(FlashCard.subtract(a, b));
                }
            }
            while (results.size() < total) {
                results.addAll(results);
            }
            Collections.shuffle(results);
            return results.subList(0, total);
        }
    }

    private static class Addition
    implements ProblemSetFactory {
        private final int aMin;
        private final int aMax;
        private final int bMin;
        private final int bMax;

        public Addition(int aMin, int aMax, int bMin, int bMax) {
            this.aMin = aMin;
            this.aMax = aMax;
            this.bMin = bMin;
            this.bMax = bMax;
        }

        @Override
        public List<FlashCard> createProblems(int total) {
            ArrayList<FlashCard> results = new ArrayList<FlashCard>();
            for (int a = this.aMin; a <= this.aMax; ++a) {
                for (int b = this.bMin; b <= this.bMax; ++b) {
                    results.add(FlashCard.add(a, b));
                }
            }
            while (results.size() < total) {
                results.addAll(results);
            }
            Collections.shuffle(results);
            return results.subList(0, total);
        }
    }
}

