/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioNode;
import com.jme3.math.Vector3f;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Panel;
import com.simsilica.mattacks.SoundSettings;

public class SoundCommand
implements Command<Button> {
    private final AudioNode clip;

    public SoundCommand(AudioNode clip) {
        this.clip = clip;
    }

    public static SoundCommand create(AssetManager assets, String name, boolean positional) {
        AudioNode node = new AudioNode(assets, name);
        node.setPositional(positional);
        return new SoundCommand(node);
    }

    public AudioNode getSound() {
        return this.clip;
    }

    @Override
    public void execute(Button source) {
        this.execute((Panel)source);
    }

    @Override
    public void execute(Panel source) {
        if (this.clip.isPositional() && source != null) {
            Vector3f loc = source.getWorldTranslation().clone();
            Vector3f pref = source.getSize();
            loc.x += pref.x * 0.5f;
            loc.y -= pref.y * 0.5f;
            this.clip.setLocalTranslation(loc);
            this.clip.updateGeometricState();
        }
        if (((Boolean)SoundSettings.getInterfaceOnVo().getObject()).booleanValue()) {
            this.clip.setVolume(SoundSettings.getInterfaceVolume());
            this.clip.playInstance();
        }
    }
}

