/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioSource;
import com.jme3.audio.Listener;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.util.SafeArrayList;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.SoundSettings;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.es.SoundType;
import com.simsilica.mattacks.util.EntityContainer;
import java.util.HashMap;
import java.util.Map;

public class SoundState
extends BaseAppState {
    private EntityData ed;
    private SoundContainer sounds;
    private final Map<String, AmbientSound> ambientIndex = new HashMap<String, AmbientSound>();
    private final SafeArrayList<AmbientSound> ambient = new SafeArrayList<AmbientSound>(AmbientSound.class);
    private float ungain = 1.0f;

    public void setUngain(float f) {
        this.ungain = f;
    }

    public void playMusic(String file) {
        AmbientSound sound = this.ambientIndex.get(file);
        if (sound == null) {
            sound = new AmbientSound(file);
            this.ambientIndex.put(file, sound);
            this.ambient.add(sound);
        }
        sound.play();
    }

    public void fadeMusic(String file, float seconds) {
        AmbientSound sound = this.ambientIndex.get(file);
        if (sound == null) {
            return;
        }
        sound.fade(seconds);
    }

    public void fadeMusic(float seconds) {
        for (AmbientSound sound : this.ambient.getArray()) {
            sound.fade(seconds);
        }
    }

    public void pauseMusic() {
        for (AmbientSound a : this.ambient.getArray()) {
            a.pause();
        }
    }

    public void resumeMusic() {
        for (AmbientSound a : this.ambient.getArray()) {
            a.resume();
        }
    }

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.sounds = new SoundContainer(this.ed);
        Listener listener = new Listener();
        app.getAudioRenderer().setListener(listener);
        Camera cam = app.getCamera();
        listener.setLocation(new Vector3f((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.1f, 100.0f));
        Quaternion quat = new Quaternion();
        quat.lookAt(Vector3f.UNIT_Z.negate(), Vector3f.UNIT_Y);
        listener.setRotation(quat);
        listener.setVolume(100.0f);
        this.ungain = 0.01f;
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.sounds.start();
    }

    @Override
    public void update(float tpf) {
        this.sounds.update();
        for (AmbientSound a : this.ambient.getArray()) {
            if (a.update(tpf)) continue;
            System.out.println("Removing tracked sound:" + a);
            this.ambient.remove(a);
            this.ambientIndex.values().remove(a);
        }
    }

    @Override
    protected void onDisable() {
        this.sounds.stop();
    }

    private class SoundContainer
    extends EntityContainer<Sound> {
        public SoundContainer(EntityData ed) {
            super(ed, Position.class, SoundType.class);
        }

        protected Sound[] getArray() {
            return (Sound[])super.getArray();
        }

        @Override
        protected Sound addObject(Entity e) {
            return new Sound(e);
        }

        @Override
        protected void updateObject(Sound object, Entity e) {
            object.update(e);
        }

        @Override
        protected void removeObject(Sound object, Entity e) {
            object.stop();
        }
    }

    private class Sound {
        Entity entity;
        AudioNode audio;
        SoundType type;

        public Sound(Entity e) {
            this.update(e);
        }

        protected void setType(SoundType type) {
            if (this.type == type) {
                return;
            }
            this.type = type;
            String s = type.getType(SoundState.this.ed);
            if (this.audio != null) {
                this.audio.stop();
            }
            s = "Sounds/" + s + ".ogg";
            this.audio = new AudioNode(SoundState.this.getApplication().getAssetManager(), s);
            this.audio.setPositional(true);
            if (((Boolean)SoundSettings.getEffectsOnVo().getObject()).booleanValue()) {
                this.audio.setVolume(SoundSettings.getEffectsVolume());
                this.audio.play();
            }
        }

        protected void setPosition(Position pos) {
            this.audio.setLocalTranslation(pos.getLocation());
            this.audio.updateGeometricState();
        }

        public void update(Entity e) {
            this.entity = e;
            this.setType(e.get(SoundType.class));
            this.setPosition(e.get(Position.class));
        }

        public void stop() {
            if (this.audio != null) {
                this.audio.stop();
            }
        }
    }

    private class AmbientSound {
        String file;
        AudioNode audio;
        float volume = 1.0f;
        Mode mode;
        float delta = 0.0f;
        boolean paused;
        VersionedReference<Float> volumeRef;
        VersionedReference<Boolean> onRef;

        public AmbientSound(String file) {
            this.file = file;
            this.volumeRef = SoundSettings.getMusicRef();
            this.onRef = SoundSettings.getMusicOnVo().createReference();
        }

        public void play() {
            this.mode = Mode.Playing;
            this.volume = 1.0f;
        }

        public void stop() {
            this.mode = Mode.Stopped;
        }

        public void pause() {
            if (!this.paused) {
                if (this.audio != null) {
                    this.audio.pause();
                }
                this.paused = true;
            }
        }

        public void resume() {
            if (this.paused) {
                this.paused = false;
                if (this.audio != null) {
                    this.audio.play();
                }
            }
        }

        public void fade(float seconds) {
            System.out.println("fade(" + seconds + ")  file:" + this.file);
            this.delta = 1.0f / seconds;
            this.mode = this.paused ? Mode.Stopped : Mode.Fading;
        }

        protected void updateVolume() {
            float v = this.onRef.get() != false ? this.volumeRef.get().floatValue() * this.volume * SoundState.this.ungain : 0.0f;
            this.audio.setVolume(Math.max(0.0f, v));
        }

        public boolean update(float tpf) {
            if (!(this.mode != Mode.Playing || this.paused || this.audio != null && this.audio.getStatus() == AudioSource.Status.Playing)) {
                this.audio = new AudioNode(SoundState.this.getApplication().getAssetManager(), this.file, true);
                this.audio.setPositional(false);
                this.audio.setVolume(SoundSettings.getMusicVolume() * this.volume * SoundState.this.ungain);
                this.audio.play();
                System.out.println("Playing new audio for:" + this.file);
            } else if (this.mode == Mode.Stopped) {
                System.out.println("Stopping audio for:" + this.file);
                this.audio.stop();
                return false;
            }
            if (this.mode == Mode.Fading && !this.paused) {
                this.volume -= tpf * this.delta;
                this.updateVolume();
                if (this.volume <= 0.0f) {
                    this.audio.stop();
                }
                return this.volume > 0.0f;
            }
            if (this.volumeRef.update() || this.onRef.update()) {
                this.updateVolume();
            }
            return true;
        }

        public String toString() {
            return "AmbientSound[file:" + this.file + ", mode:" + (Object)((Object)this.mode) + ", volume:" + this.volume + "]";
        }
    }

    private static enum Mode {
        Playing,
        Fading,
        Stopped;

    }
}

