/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.achievement;

import com.google.common.base.Function;
import com.simsilica.mattacks.Level;
import com.simsilica.mattacks.achievement.Achievement;
import com.simsilica.mattacks.achievement.AchievementContext;
import com.simsilica.mattacks.achievement.AchievementRule;

public class DefaultAchievementFactory
implements Function<AchievementContext, Achievement> {
    private AchievementRule rule;

    public DefaultAchievementFactory(AchievementRule rule) {
        this.rule = rule;
    }

    @Override
    public Achievement apply(AchievementContext context) {
        Achievement result = new Achievement(this.rule.getType(), this.rule.getName());
        result.score = this.rule.getScore();
        result.description = this.rule.getDescription();
        Level level = (Level)context.get("level");
        result.scoreMultiplier = level.getScoreMultiplier();
        switch (this.rule.getType()) {
            case Level: {
                result.level = (String)context.get("levelName");
            }
            case Category: {
                result.category = (String)context.get("category");
            }
            case Daily: {
                result.day = (String)context.get("day");
            }
            case Weekly: {
                result.week = (String)context.get("week");
            }
            case Monthly: {
                result.month = (String)context.get("month");
            }
        }
        return result;
    }
}

