/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.db;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mattacks.achievement.Achievement;
import com.simsilica.mattacks.db.DbUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.progeeks.json.JsonParser;
import org.progeeks.json.JsonPrinter;

public class Player
implements VersionedObject<Player> {
    private final File playerFile;
    private long version;
    private long savedVersion;
    private Map<String, Object> data = new HashMap<String, Object>();
    private final Set<Achievement> achievements = new HashSet<Achievement>();
    private boolean statsLoaded = false;

    public Player(File f) {
        this.playerFile = f;
        if (f != null) {
            this.load();
        }
    }

    public Player(File f, String name) {
        this(f);
        if (this.data.get("name") == null) {
            this.data.put("name", name);
        }
    }

    public void setAchievements(Collection<Achievement> achievements) {
        if (this.achievements != achievements) {
            this.achievements.clear();
            this.achievements.addAll(achievements);
        }
    }

    public Collection<Achievement> getAchievements() {
        return this.achievements;
    }

    public String getName() {
        String s = (String)this.data.get("name");
        return s == null ? this.playerFile.getName() : s;
    }

    public void load() {
        if (!this.playerFile.exists()) {
            return;
        }
        JsonParser json = new JsonParser();
        try (FileReader in = new FileReader(this.playerFile);){
            this.data = (Map)json.parse(in);
            System.out.println("Read:" + this.data);
            ++this.version;
            this.savedVersion = this.version;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file:" + this.playerFile, e);
        }
    }

    public void loadCurrentStats() {
        this.loadAchievements();
        this.statsLoaded = true;
    }

    public void save() {
        JsonPrinter json = new JsonPrinter();
        try (FileWriter out = new FileWriter(this.playerFile);){
            json.write(this.data, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing file:" + this.playerFile, e);
        }
        if (this.statsLoaded) {
            this.saveAchievements();
        }
    }

    protected File getDataDir() {
        File dir = new File(this.playerFile.getParent(), this.playerFile.getName() + ".data");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to create directory:" + dir);
        }
        return dir;
    }

    protected File getAchievementsFile() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int week = cal.get(3);
        String w = year + "-" + week;
        System.out.println("w:" + w);
        File dir = this.getDataDir();
        File f = new File(dir, w + ".achievements");
        return f;
    }

    protected void saveAchievements() {
        File f = this.getAchievementsFile();
        JsonPrinter json = new JsonPrinter();
        try (FileWriter out = new FileWriter(f);){
            json.write(DbUtils.toMap(this.achievements), out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing file:" + this.playerFile, e);
        }
    }

    protected void loadAchievements() {
        File f = this.getAchievementsFile();
        if (!f.exists()) {
            this.achievements.clear();
            return;
        }
        JsonParser json = new JsonParser();
        try (FileReader in = new FileReader(f);){
            Collection objects = (Collection)json.parse(in);
            System.out.println("Read:" + objects);
            this.achievements.clear();
            this.achievements.addAll(DbUtils.achievementsFromMap(objects));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file:" + this.playerFile, e);
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public Player getObject() {
        return this;
    }

    @Override
    public VersionedReference<Player> createReference() {
        return new VersionedReference<Player>(this);
    }
}

