/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AssetConfig {
    private static final Logger logger = Logger.getLogger(AssetConfig.class.getName());

    private AssetConfig() {
    }

    private static Class acquireClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadText(AssetManager assetManager, URL configUrl) throws IOException {
        InputStream in = configUrl.openStream();
        try {
            Scanner scan = new Scanner(in, "UTF-8");
            scan.useLocale(Locale.US);
            while (scan.hasNext()) {
                String cmd = scan.next();
                if (cmd.equals("LOADER")) {
                    String loaderClass = scan.next();
                    String colon = scan.next();
                    if (!colon.equals(":")) {
                        throw new IOException("Expected ':', got '" + colon + "'");
                    }
                    String extensionsList = scan.nextLine();
                    String[] extensions = extensionsList.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                    Class clazz = AssetConfig.acquireClass(loaderClass);
                    if (clazz != null) {
                        assetManager.registerLoader(clazz, extensions);
                        continue;
                    }
                    logger.log(Level.WARNING, "Cannot find loader {0}", loaderClass);
                    continue;
                }
                if (cmd.equals("LOCATOR")) {
                    String rootPath = scan.next();
                    String locatorClass = scan.nextLine().trim();
                    Class clazz = AssetConfig.acquireClass(locatorClass);
                    if (clazz != null) {
                        assetManager.registerLocator(rootPath, clazz);
                        continue;
                    }
                    logger.log(Level.WARNING, "Cannot find locator {0}", locatorClass);
                    continue;
                }
                if (cmd.equals("INCLUDE")) {
                    String includedCfg = scan.nextLine().trim();
                    URL includedCfgUrl = Thread.currentThread().getContextClassLoader().getResource(includedCfg);
                    if (includedCfgUrl != null) {
                        AssetConfig.loadText(assetManager, includedCfgUrl);
                        continue;
                    }
                    logger.log(Level.WARNING, "Cannot find config include {0}", includedCfg);
                    continue;
                }
                if (cmd.trim().startsWith("#")) {
                    scan.nextLine();
                    continue;
                }
                throw new IOException("Expected command, got '" + cmd + "'");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

