/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.font.BitmapCharacter;
import com.jme3.font.BitmapCharacterSet;
import com.jme3.font.BitmapText;
import com.jme3.font.StringBlock;
import com.jme3.material.Material;
import java.io.IOException;

public class BitmapFont
implements Savable {
    private BitmapCharacterSet charSet;
    private Material[] pages;

    public BitmapText createLabel(String content) {
        BitmapText label = new BitmapText(this);
        label.setSize(this.getCharSet().getRenderedSize());
        label.setText(content);
        return label;
    }

    public float getPreferredSize() {
        return this.getCharSet().getRenderedSize();
    }

    public void setCharSet(BitmapCharacterSet charSet) {
        this.charSet = charSet;
    }

    public void setPages(Material[] pages) {
        this.pages = pages;
        this.charSet.setPageSize(pages.length);
    }

    public Material getPage(int index) {
        return this.pages[index];
    }

    public int getPageSize() {
        return this.pages.length;
    }

    public BitmapCharacterSet getCharSet() {
        return this.charSet;
    }

    public float getLineHeight(StringBlock sb) {
        return (float)this.charSet.getLineHeight() * (sb.getSize() / (float)this.charSet.getRenderedSize());
    }

    public float getCharacterAdvance(char curChar, char nextChar, float size) {
        BitmapCharacter c = this.charSet.getCharacter(curChar);
        if (c == null) {
            return 0.0f;
        }
        float advance = size * (float)c.getXAdvance();
        return advance += (float)c.getKerning(nextChar) * size;
    }

    private int findKerningAmount(int newLineLastChar, int nextChar) {
        BitmapCharacter c = this.charSet.getCharacter(newLineLastChar);
        if (c == null) {
            return 0;
        }
        return c.getKerning(nextChar);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.charSet, "charSet", null);
        oc.write(this.pages, "pages", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.charSet = (BitmapCharacterSet)ic.readSavable("charSet", null);
        Savable[] pagesSavable = ic.readSavableArray("pages", null);
        this.pages = new Material[pagesSavable.length];
        System.arraycopy(pagesSavable, 0, this.pages, 0, this.pages.length);
    }

    public float getLineWidth(CharSequence text) {
        float lineWidth = 0.0f;
        float maxLineWidth = 0.0f;
        int lastChar = 0;
        boolean firstCharOfLine = true;
        float sizeScale = 1.0f;
        for (int i = 0; i < text.length(); ++i) {
            char theChar = text.charAt(i);
            if (theChar == '\n') {
                maxLineWidth = Math.max(maxLineWidth, lineWidth);
                lineWidth = 0.0f;
                firstCharOfLine = true;
                continue;
            }
            BitmapCharacter c = this.charSet.getCharacter(theChar);
            if (c == null) continue;
            if (theChar == '\\' && i < text.length() - 1 && text.charAt(i + 1) == '#') {
                if (i + 5 < text.length() && text.charAt(i + 5) == '#') {
                    i += 5;
                    continue;
                }
                if (i + 8 < text.length() && text.charAt(i + 8) == '#') {
                    i += 8;
                    continue;
                }
            }
            if (!firstCharOfLine) {
                lineWidth += (float)this.findKerningAmount(lastChar, theChar) * sizeScale;
            } else {
                lineWidth -= (float)c.getXOffset() * sizeScale;
                firstCharOfLine = false;
            }
            float xAdvance = (float)c.getXAdvance() * sizeScale;
            if (i == text.length() - 1) {
                lineWidth += (float)c.getWidth() * sizeScale;
                lineWidth += (float)c.getXOffset() * sizeScale;
                continue;
            }
            lineWidth += xAdvance;
        }
        return Math.max(maxLineWidth, lineWidth);
    }

    public void merge(BitmapFont newFont) {
        this.charSet.merge(newFont.charSet);
        int size1 = this.pages.length;
        int size2 = newFont.pages.length;
        Material[] tmp = new Material[size1 + size2];
        System.arraycopy(this.pages, 0, tmp, 0, size1);
        System.arraycopy(newFont.pages, 0, tmp, size1, size2);
        this.pages = tmp;
    }

    public void setStyle(int style) {
        this.charSet.setStyle(style);
    }

    public static enum Align {
        Left,
        Center,
        Right;

    }

    public static enum VAlign {
        Top,
        Center,
        Bottom;

    }
}

