/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.controls;

import com.jme3.input.controls.Trigger;

public class JoyButtonTrigger
implements Trigger {
    private final int joyId;
    private final int buttonId;

    public JoyButtonTrigger(int joyId, int axisId) {
        this.joyId = joyId;
        this.buttonId = axisId;
    }

    public static int joyButtonHash(int joyId, int joyButton) {
        assert (joyButton >= 0 && joyButton <= 255);
        return 2048 * joyId | 0x600 | joyButton & 0xFF;
    }

    public int getAxisId() {
        return this.buttonId;
    }

    public int getJoyId() {
        return this.joyId;
    }

    @Override
    public String getName() {
        return "JoyButton[joyId=" + this.joyId + ", axisId=" + this.buttonId + "]";
    }

    @Override
    public int triggerHashCode() {
        return JoyButtonTrigger.joyButtonHash(this.joyId, this.buttonId);
    }
}

