/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.io.IOException;

public abstract class Light
implements Savable,
Cloneable {
    protected ColorRGBA color = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected transient float lastDistance = -1.0f;
    protected boolean enabled = true;
    protected String name;
    boolean frustumCheckNeeded = true;
    boolean intersectsFrustum = false;

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setColor(ColorRGBA color) {
        this.color.set(color);
    }

    public abstract boolean intersectsBox(BoundingBox var1, TempVars var2);

    public abstract boolean intersectsFrustum(Camera var1, TempVars var2);

    public Light clone() {
        try {
            return (Light)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.color, "color", null);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.name, "name", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.color = (ColorRGBA)ic.readSavable("color", null);
        this.enabled = ic.readBoolean("enabled", true);
        this.name = ic.readString("name", null);
    }

    protected abstract void computeLastDistance(Spatial var1);

    public abstract Type getType();

    public static enum Type {
        Directional(0),
        Point(1),
        Spot(2),
        Ambient(3);

        private int typeId;

        private Type(int type) {
            this.typeId = type;
        }

        public int getId() {
            return this.typeId;
        }
    }
}

