/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.VarType;
import com.jme3.texture.image.ColorSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialDef {
    private static final Logger logger = Logger.getLogger(MaterialDef.class.getName());
    private String name;
    private String assetName;
    private AssetManager assetManager;
    private List<TechniqueDef> defaultTechs;
    private Map<String, TechniqueDef> techniques;
    private Map<String, MatParam> matParams;

    public MaterialDef() {
    }

    public MaterialDef(AssetManager assetManager, String name) {
        this.assetManager = assetManager;
        this.name = name;
        this.techniques = new HashMap<String, TechniqueDef>();
        this.matParams = new HashMap<String, MatParam>();
        this.defaultTechs = new ArrayList<TechniqueDef>();
        logger.log(Level.FINE, "Loaded material definition: {0}", name);
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public String getName() {
        return this.name;
    }

    public void addMaterialParam(VarType type, String name, Object value) {
        this.matParams.put(name, new MatParam(type, name, value));
    }

    public void addMaterialParamTexture(VarType type, String name, ColorSpace colorSpace) {
        this.matParams.put(name, new MatParamTexture(type, name, null, 0, colorSpace));
    }

    public MatParam getMaterialParam(String name) {
        return this.matParams.get(name);
    }

    public Collection<MatParam> getMaterialParams() {
        return this.matParams.values();
    }

    public void addTechniqueDef(TechniqueDef technique) {
        if (technique.getName().equals("Default")) {
            this.defaultTechs.add(technique);
        } else {
            this.techniques.put(technique.getName(), technique);
        }
    }

    public List<TechniqueDef> getDefaultTechniques() {
        return this.defaultTechs;
    }

    public TechniqueDef getTechniqueDef(String name) {
        return this.techniques.get(name);
    }
}

