/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.RendererException;
import com.jme3.renderer.opengl.GL;

public abstract class GLDebug {
    protected GL gl;

    protected String decodeError(int err) {
        String errMsg;
        switch (err) {
            case 0: {
                errMsg = "No Error";
                break;
            }
            case 1280: {
                errMsg = "Invalid enum argument";
                break;
            }
            case 1282: {
                errMsg = "Invalid operation";
                break;
            }
            case 1281: {
                errMsg = "Invalid numeric argument";
                break;
            }
            case 1285: {
                errMsg = "Out of memory";
                break;
            }
            case 1286: {
                errMsg = "Framebuffer is not complete";
                break;
            }
            case 1283: {
                errMsg = "Internal stack overflow";
                break;
            }
            case 1284: {
                errMsg = "Internal stack underflow";
                break;
            }
            default: {
                errMsg = "Unknown";
            }
        }
        return errMsg + " (Error Code: " + err + ")";
    }

    protected void checkError() {
        int err = this.gl.glGetError();
        if (err != 0) {
            throw new RendererException("An OpenGL error occurred - " + this.decodeError(err));
        }
    }
}

