/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.IDList;
import com.jme3.renderer.Limits;
import com.jme3.renderer.RenderContext;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.Statistics;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GL3;
import com.jme3.renderer.opengl.GL4;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.renderer.opengl.GLImageFormat;
import com.jme3.renderer.opengl.TextureUtil;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.ListMap;
import com.jme3.util.MipMapGenerator;
import com.jme3.util.NativeObjectManager;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3tools.shader.ShaderDebug;

public class GLRenderer
implements Renderer {
    private static final Logger logger = Logger.getLogger(GLRenderer.class.getName());
    private static final boolean VALIDATE_SHADER = false;
    private static final Pattern GLVERSION_PATTERN = Pattern.compile(".*?(\\d+)\\.(\\d+).*");
    private final ByteBuffer nameBuf = BufferUtils.createByteBuffer(250);
    private final StringBuilder stringBuf = new StringBuilder(250);
    private final IntBuffer intBuf1 = BufferUtils.createIntBuffer(1);
    private final IntBuffer intBuf16 = BufferUtils.createIntBuffer(16);
    private final FloatBuffer floatBuf16 = BufferUtils.createFloatBuffer(16);
    private final RenderContext context = new RenderContext();
    private final NativeObjectManager objManager = new NativeObjectManager();
    private final EnumSet<Caps> caps = EnumSet.noneOf(Caps.class);
    private final EnumMap<Limits, Integer> limits = new EnumMap(Limits.class);
    private FrameBuffer mainFbOverride = null;
    private final Statistics statistics = new Statistics();
    private int vpX;
    private int vpY;
    private int vpW;
    private int vpH;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private boolean linearizeSrgbImages;
    private HashSet<String> extensions;
    private final GL gl;
    private final GL2 gl2;
    private final GL3 gl3;
    private final GL4 gl4;
    private final GLExt glext;
    private final GLFbo glfbo;
    private final TextureUtil texUtil;

    public GLRenderer(GL gl, GLExt glext, GLFbo glfbo) {
        this.gl = gl;
        this.gl2 = gl instanceof GL2 ? (GL2)gl : null;
        this.gl3 = gl instanceof GL3 ? (GL3)gl : null;
        this.gl4 = gl instanceof GL4 ? (GL4)gl : null;
        this.glfbo = glfbo;
        this.glext = glext;
        this.texUtil = new TextureUtil(gl, this.gl2, glext);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public EnumSet<Caps> getCaps() {
        return this.caps;
    }

    public EnumMap<Limits, Integer> getLimits() {
        return this.limits;
    }

    private HashSet<String> loadExtensions() {
        HashSet<String> extensionSet = new HashSet<String>(64);
        if (this.caps.contains((Object)Caps.OpenGL30)) {
            this.gl3.glGetInteger(33309, this.intBuf16);
            int extensionCount = this.intBuf16.get(0);
            for (int i = 0; i < extensionCount; ++i) {
                String extension = this.gl3.glGetString(7939, i);
                extensionSet.add(extension);
            }
        } else {
            extensionSet.addAll(Arrays.asList(this.gl.glGetString(7939).split(" ")));
        }
        return extensionSet;
    }

    public static int extractVersion(String version) {
        Matcher m = GLVERSION_PATTERN.matcher(version);
        if (m.matches()) {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            if (minor >= 10 && minor % 10 == 0) {
                minor /= 10;
            }
            return major * 100 + minor * 10;
        }
        return -1;
    }

    private boolean hasExtension(String extensionName) {
        return this.extensions.contains(extensionName);
    }

    private void loadCapabilitiesES() {
        this.caps.add(Caps.GLSL100);
        this.caps.add(Caps.OpenGLES20);
    }

    private void loadCapabilitiesGL2() {
        int oglVer = GLRenderer.extractVersion(this.gl.glGetString(7938));
        if (oglVer >= 200) {
            this.caps.add(Caps.OpenGL20);
            if (oglVer >= 210) {
                this.caps.add(Caps.OpenGL21);
                if (oglVer >= 300) {
                    this.caps.add(Caps.OpenGL30);
                    if (oglVer >= 310) {
                        this.caps.add(Caps.OpenGL31);
                        if (oglVer >= 320) {
                            this.caps.add(Caps.OpenGL32);
                        }
                        if (oglVer >= 330) {
                            this.caps.add(Caps.OpenGL33);
                            this.caps.add(Caps.GeometryShader);
                        }
                        if (oglVer >= 400) {
                            this.caps.add(Caps.OpenGL40);
                            this.caps.add(Caps.TesselationShader);
                        }
                    }
                }
            }
        }
        int glslVer = GLRenderer.extractVersion(this.gl.glGetString(35724));
        switch (glslVer) {
            default: {
                if (glslVer < 400) break;
            }
            case 400: {
                this.caps.add(Caps.GLSL400);
            }
            case 330: {
                this.caps.add(Caps.GLSL330);
            }
            case 150: {
                this.caps.add(Caps.GLSL150);
            }
            case 140: {
                this.caps.add(Caps.GLSL140);
            }
            case 130: {
                this.caps.add(Caps.GLSL130);
            }
            case 120: {
                this.caps.add(Caps.GLSL120);
            }
            case 110: {
                this.caps.add(Caps.GLSL110);
            }
            case 100: {
                this.caps.add(Caps.GLSL100);
            }
        }
        this.caps.add(Caps.GLSL110);
        this.caps.add(Caps.GLSL100);
        this.context.initialDrawBuf = this.getInteger(3073);
        this.context.initialReadBuf = this.getInteger(3074);
    }

    private void loadCapabilitiesCommon() {
        int binaryFormats;
        boolean hasFloatTexture;
        this.extensions = this.loadExtensions();
        this.limits.put(Limits.VertexTextureUnits, this.getInteger(35660));
        if (this.limits.get((Object)Limits.VertexTextureUnits) > 0) {
            this.caps.add(Caps.VertexTextureFetch);
        }
        this.limits.put(Limits.FragmentTextureUnits, this.getInteger(34930));
        if (this.caps.contains((Object)Caps.OpenGLES20)) {
            this.limits.put(Limits.VertexUniformVectors, this.getInteger(36347));
        } else {
            this.limits.put(Limits.VertexUniformVectors, this.getInteger(35658) / 4);
        }
        this.limits.put(Limits.VertexAttributes, this.getInteger(34921));
        this.limits.put(Limits.TextureSize, this.getInteger(3379));
        this.limits.put(Limits.CubemapSize, this.getInteger(34076));
        if (this.hasExtension("GL_ARB_draw_instanced") && this.hasExtension("GL_ARB_instanced_arrays")) {
            this.caps.add(Caps.MeshInstancing);
        }
        if (this.hasExtension("GL_OES_element_index_uint") || this.gl2 != null) {
            this.caps.add(Caps.IntegerIndexBuffer);
        }
        if (this.hasExtension("GL_ARB_texture_buffer_object")) {
            this.caps.add(Caps.TextureBuffer);
        }
        boolean bl = hasFloatTexture = this.hasExtension("GL_OES_texture_half_float") && this.hasExtension("GL_OES_texture_float");
        if (!hasFloatTexture) {
            boolean bl2 = hasFloatTexture = this.hasExtension("GL_ARB_texture_float") && this.hasExtension("GL_ARB_half_float_pixel");
            if (!hasFloatTexture) {
                hasFloatTexture = this.caps.contains((Object)Caps.OpenGL30);
            }
        }
        if (hasFloatTexture) {
            this.caps.add(Caps.FloatTexture);
        }
        if (this.hasExtension("GL_OES_depth_texture") || this.gl2 != null) {
            this.caps.add(Caps.DepthTexture);
        }
        if (this.hasExtension("GL_OES_rgb8_rgba8") || this.hasExtension("GL_ARM_rgba8") || this.hasExtension("GL_EXT_texture_format_BGRA8888")) {
            this.caps.add(Caps.Rgba8);
        }
        if (this.caps.contains((Object)Caps.OpenGL30) || this.hasExtension("GL_OES_packed_depth_stencil")) {
            this.caps.add(Caps.PackedDepthStencilBuffer);
        }
        if (this.hasExtension("GL_ARB_color_buffer_float") && this.hasExtension("GL_ARB_half_float_pixel")) {
            this.caps.add(Caps.FloatColorBuffer);
        }
        if (this.hasExtension("GL_ARB_depth_buffer_float")) {
            this.caps.add(Caps.FloatDepthBuffer);
        }
        if (this.hasExtension("GL_EXT_packed_float") && hasFloatTexture || this.caps.contains((Object)Caps.OpenGL30)) {
            this.caps.add(Caps.PackedFloatColorBuffer);
            this.caps.add(Caps.PackedFloatTexture);
        }
        if (this.hasExtension("GL_EXT_texture_shared_exponent") || this.caps.contains((Object)Caps.OpenGL30)) {
            this.caps.add(Caps.SharedExponentTexture);
        }
        if (this.hasExtension("GL_EXT_texture_compression_s3tc")) {
            this.caps.add(Caps.TextureCompressionS3TC);
        }
        if (this.hasExtension("GL_ARB_ES3_compatibility")) {
            this.caps.add(Caps.TextureCompressionETC2);
            this.caps.add(Caps.TextureCompressionETC1);
        } else if (this.hasExtension("GL_OES_compressed_ETC1_RGB8_texture")) {
            this.caps.add(Caps.TextureCompressionETC1);
        }
        if (this.hasExtension("GL_ARB_vertex_array_object") || this.caps.contains((Object)Caps.OpenGL30)) {
            this.caps.add(Caps.VertexBufferArray);
        }
        if (this.hasExtension("GL_ARB_texture_non_power_of_two") || this.hasExtension("GL_OES_texture_npot") || this.caps.contains((Object)Caps.OpenGL30)) {
            this.caps.add(Caps.NonPowerOfTwoTextures);
        } else {
            logger.log(Level.WARNING, "Your graphics card does not support non-power-of-2 textures. Some features might not work.");
        }
        if (this.caps.contains((Object)Caps.OpenGLES20)) {
            this.caps.add(Caps.PartialNonPowerOfTwoTextures);
        }
        if (this.hasExtension("GL_EXT_texture_array") || this.caps.contains((Object)Caps.OpenGL30)) {
            this.caps.add(Caps.TextureArray);
        }
        if (this.hasExtension("GL_EXT_texture_filter_anisotropic")) {
            this.caps.add(Caps.TextureFilterAnisotropic);
        }
        if (this.hasExtension("GL_EXT_framebuffer_object") || this.gl3 != null || this.caps.contains((Object)Caps.OpenGLES20)) {
            this.caps.add(Caps.FrameBuffer);
            this.limits.put(Limits.RenderBufferSize, this.getInteger(34024));
            this.limits.put(Limits.FrameBufferAttachments, this.getInteger(36063));
            if (this.hasExtension("GL_EXT_framebuffer_blit")) {
                this.caps.add(Caps.FrameBufferBlit);
            }
            if (this.hasExtension("GL_EXT_framebuffer_multisample")) {
                this.caps.add(Caps.FrameBufferMultisample);
                this.limits.put(Limits.FrameBufferSamples, this.getInteger(36183));
            }
            if (this.hasExtension("GL_ARB_texture_multisample")) {
                this.caps.add(Caps.TextureMultisample);
                this.limits.put(Limits.ColorTextureSamples, this.getInteger(37134));
                this.limits.put(Limits.DepthTextureSamples, this.getInteger(37135));
                if (!this.limits.containsKey((Object)Limits.FrameBufferSamples)) {
                    this.limits.put(Limits.FrameBufferSamples, this.limits.get((Object)Limits.ColorTextureSamples));
                }
            }
            if (this.hasExtension("GL_ARB_draw_buffers") || this.gl3 != null) {
                this.limits.put(Limits.FrameBufferMrtAttachments, this.getInteger(34852));
                if (this.limits.get((Object)Limits.FrameBufferMrtAttachments) > 1) {
                    this.caps.add(Caps.FrameBufferMRT);
                }
            } else {
                this.limits.put(Limits.FrameBufferMrtAttachments, 1);
            }
        }
        if (this.hasExtension("GL_ARB_multisample")) {
            boolean available = this.getInteger(32936) != 0;
            int samples = this.getInteger(32937);
            logger.log(Level.FINER, "Samples: {0}", samples);
            boolean enabled = this.gl.glIsEnabled(32925);
            if (samples > 0 && available && !enabled) {
                this.gl.glEnable(32925);
            }
            this.caps.add(Caps.Multisample);
        }
        if (this.hasExtension("GL_ARB_framebuffer_sRGB") && this.hasExtension("GL_EXT_texture_sRGB") || this.caps.contains((Object)Caps.OpenGL30)) {
            this.caps.add(Caps.Srgb);
        }
        if (this.hasExtension("GL_ARB_seamless_cube_map") || this.caps.contains((Object)Caps.OpenGL32)) {
            this.caps.add(Caps.SeamlessCubemap);
        }
        if (this.caps.contains((Object)Caps.OpenGL32) && !this.hasExtension("GL_ARB_compatibility")) {
            this.caps.add(Caps.CoreProfile);
        }
        if (this.hasExtension("GL_ARB_get_program_binary") && (binaryFormats = this.getInteger(34814)) > 0) {
            this.caps.add(Caps.BinaryShader);
        }
        logger.log(Level.INFO, "OpenGL Renderer Information\n * Vendor: {0}\n * Renderer: {1}\n * OpenGL Version: {2}\n * GLSL Version: {3}\n * Profile: {4}", new Object[]{this.gl.glGetString(7936), this.gl.glGetString(7937), this.gl.glGetString(7938), this.gl.glGetString(35724), this.caps.contains((Object)Caps.CoreProfile) ? "Core" : "Compatibility"});
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Supported capabilities: \n");
            for (Caps cap : this.caps) {
                sb.append("\t").append(cap.toString()).append("\n");
            }
            logger.log(Level.FINE, sb.toString());
        }
        this.texUtil.initialize(this.caps);
    }

    private void loadCapabilities() {
        if (this.gl2 != null) {
            this.loadCapabilitiesGL2();
        } else {
            this.loadCapabilitiesES();
        }
        this.loadCapabilitiesCommon();
    }

    private int getInteger(int en) {
        this.intBuf16.clear();
        this.gl.glGetInteger(en, this.intBuf16);
        return this.intBuf16.get(0);
    }

    private boolean getBoolean(int en) {
        this.gl.glGetBoolean(en, this.nameBuf);
        return this.nameBuf.get(0) != 0;
    }

    @Override
    public void initialize() {
        this.loadCapabilities();
        this.gl.glPixelStorei(3317, 1);
        if (this.caps.contains((Object)Caps.CoreProfile)) {
            this.gl3.glGenVertexArrays(this.intBuf16);
            int vaoId = this.intBuf16.get(0);
            this.gl3.glBindVertexArray(vaoId);
        }
        if (this.gl2 != null) {
            this.gl2.glEnable(34370);
            if (!this.caps.contains((Object)Caps.CoreProfile)) {
                this.gl2.glEnable(34913);
                this.context.pointSprite = true;
            }
        }
    }

    @Override
    public void invalidateState() {
        this.context.reset();
        if (this.gl2 != null) {
            this.context.initialDrawBuf = this.getInteger(3073);
            this.context.initialReadBuf = this.getInteger(3074);
        }
    }

    @Override
    public void resetGLObjects() {
        logger.log(Level.FINE, "Reseting objects and invalidating state");
        this.objManager.resetObjects();
        this.statistics.clearMemory();
        this.invalidateState();
    }

    @Override
    public void cleanup() {
        logger.log(Level.FINE, "Deleting objects and invalidating state");
        this.objManager.deleteAllObjects(this);
        this.statistics.clearMemory();
        this.invalidateState();
    }

    @Override
    public void setDepthRange(float start, float end) {
        this.gl.glDepthRange(start, end);
    }

    @Override
    public void clearBuffers(boolean color, boolean depth, boolean stencil) {
        int bits = 0;
        if (color) {
            if (!this.context.colorWriteEnabled) {
                this.gl.glColorMask(true, true, true, true);
                this.context.colorWriteEnabled = true;
            }
            bits = 16384;
        }
        if (depth) {
            if (!this.context.depthWriteEnabled) {
                this.gl.glDepthMask(true);
                this.context.depthWriteEnabled = true;
            }
            bits |= 0x100;
        }
        if (stencil) {
            bits |= 0x400;
        }
        if (bits != 0) {
            this.gl.glClear(bits);
        }
    }

    @Override
    public void setBackgroundColor(ColorRGBA color) {
        if (!this.context.clearColor.equals(color)) {
            this.gl.glClearColor(color.r, color.g, color.b, color.a);
            this.context.clearColor.set(color);
        }
    }

    @Override
    public void setAlphaToCoverage(boolean value) {
        if (this.caps.contains((Object)Caps.Multisample)) {
            if (value) {
                this.gl.glEnable(32926);
            } else {
                this.gl.glDisable(32926);
            }
        }
    }

    @Override
    public void applyRenderState(RenderState state) {
        if (this.gl2 != null) {
            if (state.isWireframe() && !this.context.wireframe) {
                this.gl2.glPolygonMode(1032, 6913);
                this.context.wireframe = true;
            } else if (!state.isWireframe() && this.context.wireframe) {
                this.gl2.glPolygonMode(1032, 6914);
                this.context.wireframe = false;
            }
        }
        if (state.isDepthTest() && !this.context.depthTestEnabled) {
            this.gl.glEnable(2929);
            this.gl.glDepthFunc(this.convertTestFunction(this.context.depthFunc));
            this.context.depthTestEnabled = true;
        } else if (!state.isDepthTest() && this.context.depthTestEnabled) {
            this.gl.glDisable(2929);
            this.context.depthTestEnabled = false;
        }
        if (state.getDepthFunc() != this.context.depthFunc) {
            this.gl.glDepthFunc(this.convertTestFunction(state.getDepthFunc()));
            this.context.depthFunc = state.getDepthFunc();
        }
        if (state.isDepthWrite() && !this.context.depthWriteEnabled) {
            this.gl.glDepthMask(true);
            this.context.depthWriteEnabled = true;
        } else if (!state.isDepthWrite() && this.context.depthWriteEnabled) {
            this.gl.glDepthMask(false);
            this.context.depthWriteEnabled = false;
        }
        if (state.isColorWrite() && !this.context.colorWriteEnabled) {
            this.gl.glColorMask(true, true, true, true);
            this.context.colorWriteEnabled = true;
        } else if (!state.isColorWrite() && this.context.colorWriteEnabled) {
            this.gl.glColorMask(false, false, false, false);
            this.context.colorWriteEnabled = false;
        }
        if (state.isPolyOffset()) {
            if (!this.context.polyOffsetEnabled) {
                this.gl.glEnable(32823);
                this.gl.glPolygonOffset(state.getPolyOffsetFactor(), state.getPolyOffsetUnits());
                this.context.polyOffsetEnabled = true;
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            } else if (state.getPolyOffsetFactor() != this.context.polyOffsetFactor || state.getPolyOffsetUnits() != this.context.polyOffsetUnits) {
                this.gl.glPolygonOffset(state.getPolyOffsetFactor(), state.getPolyOffsetUnits());
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            }
        } else if (this.context.polyOffsetEnabled) {
            this.gl.glDisable(32823);
            this.context.polyOffsetEnabled = false;
            this.context.polyOffsetFactor = 0.0f;
            this.context.polyOffsetUnits = 0.0f;
        }
        if (state.getFaceCullMode() != this.context.cullMode) {
            if (state.getFaceCullMode() == RenderState.FaceCullMode.Off) {
                this.gl.glDisable(2884);
            } else {
                this.gl.glEnable(2884);
            }
            switch (state.getFaceCullMode()) {
                case Off: {
                    break;
                }
                case Back: {
                    this.gl.glCullFace(1029);
                    break;
                }
                case Front: {
                    this.gl.glCullFace(1028);
                    break;
                }
                case FrontAndBack: {
                    this.gl.glCullFace(1032);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized face cull mode: " + (Object)((Object)state.getFaceCullMode()));
                }
            }
            this.context.cullMode = state.getFaceCullMode();
        }
        if (state.getBlendMode() != this.context.blendMode) {
            if (state.getBlendMode() == RenderState.BlendMode.Off) {
                this.gl.glDisable(3042);
            } else {
                if (this.context.blendMode == RenderState.BlendMode.Off) {
                    this.gl.glEnable(3042);
                }
                switch (state.getBlendMode()) {
                    case Off: {
                        break;
                    }
                    case Additive: {
                        this.gl.glBlendFunc(1, 1);
                        break;
                    }
                    case AlphaAdditive: {
                        this.gl.glBlendFunc(770, 1);
                        break;
                    }
                    case Alpha: {
                        this.gl.glBlendFunc(770, 771);
                        break;
                    }
                    case PremultAlpha: {
                        this.gl.glBlendFunc(1, 771);
                        break;
                    }
                    case Modulate: {
                        this.gl.glBlendFunc(774, 0);
                        break;
                    }
                    case ModulateX2: {
                        this.gl.glBlendFunc(774, 768);
                        break;
                    }
                    case Color: 
                    case Screen: {
                        this.gl.glBlendFunc(1, 769);
                        break;
                    }
                    case Exclusion: {
                        this.gl.glBlendFunc(775, 769);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unrecognized blend mode: " + (Object)((Object)state.getBlendMode()));
                    }
                }
            }
            this.context.blendMode = state.getBlendMode();
        }
        if (this.context.stencilTest != state.isStencilTest() || this.context.frontStencilStencilFailOperation != state.getFrontStencilStencilFailOperation() || this.context.frontStencilDepthFailOperation != state.getFrontStencilDepthFailOperation() || this.context.frontStencilDepthPassOperation != state.getFrontStencilDepthPassOperation() || this.context.backStencilStencilFailOperation != state.getBackStencilStencilFailOperation() || this.context.backStencilDepthFailOperation != state.getBackStencilDepthFailOperation() || this.context.backStencilDepthPassOperation != state.getBackStencilDepthPassOperation() || this.context.frontStencilFunction != state.getFrontStencilFunction() || this.context.backStencilFunction != state.getBackStencilFunction()) {
            this.context.frontStencilStencilFailOperation = state.getFrontStencilStencilFailOperation();
            this.context.frontStencilDepthFailOperation = state.getFrontStencilDepthFailOperation();
            this.context.frontStencilDepthPassOperation = state.getFrontStencilDepthPassOperation();
            this.context.backStencilStencilFailOperation = state.getBackStencilStencilFailOperation();
            this.context.backStencilDepthFailOperation = state.getBackStencilDepthFailOperation();
            this.context.backStencilDepthPassOperation = state.getBackStencilDepthPassOperation();
            this.context.frontStencilFunction = state.getFrontStencilFunction();
            this.context.backStencilFunction = state.getBackStencilFunction();
            if (state.isStencilTest()) {
                this.gl.glEnable(2960);
                this.gl.glStencilOpSeparate(1028, this.convertStencilOperation(state.getFrontStencilStencilFailOperation()), this.convertStencilOperation(state.getFrontStencilDepthFailOperation()), this.convertStencilOperation(state.getFrontStencilDepthPassOperation()));
                this.gl.glStencilOpSeparate(1029, this.convertStencilOperation(state.getBackStencilStencilFailOperation()), this.convertStencilOperation(state.getBackStencilDepthFailOperation()), this.convertStencilOperation(state.getBackStencilDepthPassOperation()));
                this.gl.glStencilFuncSeparate(1028, this.convertTestFunction(state.getFrontStencilFunction()), 0, Integer.MAX_VALUE);
                this.gl.glStencilFuncSeparate(1029, this.convertTestFunction(state.getBackStencilFunction()), 0, Integer.MAX_VALUE);
            } else {
                this.gl.glDisable(2960);
            }
        }
    }

    private int convertStencilOperation(RenderState.StencilOperation stencilOp) {
        switch (stencilOp) {
            case Keep: {
                return 7680;
            }
            case Zero: {
                return 0;
            }
            case Replace: {
                return 7681;
            }
            case Increment: {
                return 7682;
            }
            case IncrementWrap: {
                return 34055;
            }
            case Decrement: {
                return 7683;
            }
            case DecrementWrap: {
                return 34056;
            }
            case Invert: {
                return 5386;
            }
        }
        throw new UnsupportedOperationException("Unrecognized stencil operation: " + (Object)((Object)stencilOp));
    }

    private int convertTestFunction(RenderState.TestFunction testFunc) {
        switch (testFunc) {
            case Never: {
                return 512;
            }
            case Less: {
                return 513;
            }
            case LessOrEqual: {
                return 515;
            }
            case Greater: {
                return 516;
            }
            case GreaterOrEqual: {
                return 518;
            }
            case Equal: {
                return 514;
            }
            case NotEqual: {
                return 517;
            }
            case Always: {
                return 519;
            }
        }
        throw new UnsupportedOperationException("Unrecognized test function: " + (Object)((Object)testFunc));
    }

    @Override
    public void setViewPort(int x, int y, int w, int h) {
        if (x != this.vpX || this.vpY != y || this.vpW != w || this.vpH != h) {
            this.gl.glViewport(x, y, w, h);
            this.vpX = x;
            this.vpY = y;
            this.vpW = w;
            this.vpH = h;
        }
    }

    @Override
    public void setClipRect(int x, int y, int width, int height) {
        if (!this.context.clipRectEnabled) {
            this.gl.glEnable(3089);
            this.context.clipRectEnabled = true;
        }
        if (this.clipX != x || this.clipY != y || this.clipW != width || this.clipH != height) {
            this.gl.glScissor(x, y, width, height);
            this.clipX = x;
            this.clipY = y;
            this.clipW = width;
            this.clipH = height;
        }
    }

    @Override
    public void clearClipRect() {
        if (this.context.clipRectEnabled) {
            this.gl.glDisable(3089);
            this.context.clipRectEnabled = false;
            this.clipX = 0;
            this.clipY = 0;
            this.clipW = 0;
            this.clipH = 0;
        }
    }

    @Override
    public void postFrame() {
        this.objManager.deleteUnused(this);
        this.gl.resetStats();
    }

    protected void updateUniformLocation(Shader shader, Uniform uniform) {
        int loc = this.gl.glGetUniformLocation(shader.getId(), uniform.getName());
        if (loc < 0) {
            uniform.setLocation(-1);
            logger.log(Level.FINE, "Uniform {0} is not declared in shader {1}.", new Object[]{uniform.getName(), shader.getSources()});
        } else {
            uniform.setLocation(loc);
        }
    }

    protected void bindProgram(Shader shader) {
        int shaderId = shader.getId();
        if (this.context.boundShaderProgram != shaderId) {
            this.gl.glUseProgram(shaderId);
            this.statistics.onShaderUse(shader, true);
            this.context.boundShader = shader;
            this.context.boundShaderProgram = shaderId;
        } else {
            this.statistics.onShaderUse(shader, false);
        }
    }

    protected void updateUniform(Shader shader, Uniform uniform) {
        int shaderId = shader.getId();
        assert (uniform.getName() != null);
        assert (shader.getId() > 0);
        this.bindProgram(shader);
        int loc = uniform.getLocation();
        if (loc == -1) {
            return;
        }
        if (loc == -2) {
            this.updateUniformLocation(shader, uniform);
            if (uniform.getLocation() == -1) {
                uniform.clearUpdateNeeded();
                return;
            }
            loc = uniform.getLocation();
        }
        if (uniform.getVarType() == null) {
            return;
        }
        this.statistics.onUniformSet();
        uniform.clearUpdateNeeded();
        switch (uniform.getVarType()) {
            case Float: {
                Float f = (Float)uniform.getValue();
                this.gl.glUniform1f(loc, f.floatValue());
                break;
            }
            case Vector2: {
                Vector2f v2 = (Vector2f)uniform.getValue();
                this.gl.glUniform2f(loc, v2.getX(), v2.getY());
                break;
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)uniform.getValue();
                this.gl.glUniform3f(loc, v3.getX(), v3.getY(), v3.getZ());
                break;
            }
            case Vector4: {
                Object val = uniform.getValue();
                if (val instanceof ColorRGBA) {
                    ColorRGBA c = (ColorRGBA)val;
                    this.gl.glUniform4f(loc, c.r, c.g, c.b, c.a);
                    break;
                }
                if (val instanceof Vector4f) {
                    Vector4f c = (Vector4f)val;
                    this.gl.glUniform4f(loc, c.x, c.y, c.z, c.w);
                    break;
                }
                Quaternion c = (Quaternion)uniform.getValue();
                this.gl.glUniform4f(loc, c.getX(), c.getY(), c.getZ(), c.getW());
                break;
            }
            case Boolean: {
                Boolean b = (Boolean)uniform.getValue();
                this.gl.glUniform1i(loc, b != false ? 1 : 0);
                break;
            }
            case Matrix3: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                assert (fb.remaining() == 9);
                this.gl.glUniformMatrix3(loc, false, fb);
                break;
            }
            case Matrix4: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                assert (fb.remaining() == 16);
                this.gl.glUniformMatrix4(loc, false, fb);
                break;
            }
            case IntArray: {
                IntBuffer ib = (IntBuffer)uniform.getValue();
                this.gl.glUniform1(loc, ib);
                break;
            }
            case FloatArray: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                this.gl.glUniform1(loc, fb);
                break;
            }
            case Vector2Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                this.gl.glUniform2(loc, fb);
                break;
            }
            case Vector3Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                this.gl.glUniform3(loc, fb);
                break;
            }
            case Vector4Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                this.gl.glUniform4(loc, fb);
                break;
            }
            case Matrix4Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                this.gl.glUniformMatrix4(loc, false, fb);
                break;
            }
            case Int: {
                Integer i = (Integer)uniform.getValue();
                this.gl.glUniform1i(loc, i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported uniform type: " + (Object)((Object)uniform.getVarType()));
            }
        }
    }

    protected void updateShaderUniforms(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform uniform = uniforms.getValue(i);
            if (!uniform.isUpdateNeeded()) continue;
            this.updateUniform(shader, uniform);
        }
    }

    protected void resetUniformLocations(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform uniform = uniforms.getValue(i);
            uniform.reset();
        }
    }

    public int convertShaderType(Shader.ShaderType type) {
        switch (type) {
            case Fragment: {
                return 35632;
            }
            case Vertex: {
                return 35633;
            }
            case Geometry: {
                return 36313;
            }
            case TessellationControl: {
                return 36488;
            }
            case TessellationEvaluation: {
                return 36487;
            }
        }
        throw new UnsupportedOperationException("Unrecognized shader type.");
    }

    public void updateShaderSourceData(Shader.ShaderSource source) {
        int id = source.getId();
        if (id == -1) {
            id = this.gl.glCreateShader(this.convertShaderType(source.getType()));
            if (id <= 0) {
                throw new RendererException("Invalid ID received when trying to create shader.");
            }
        } else {
            throw new RendererException("Cannot recompile shader source");
        }
        source.setId(id);
        boolean gles2 = this.caps.contains((Object)Caps.OpenGLES20);
        String language = source.getLanguage();
        if (gles2 && !language.equals("GLSL100")) {
            throw new RendererException("This shader cannot run in OpenGL ES 2. Only GLSL 1.00 shaders are supported.");
        }
        this.stringBuf.setLength(0);
        if (language.startsWith("GLSL")) {
            int version = Integer.parseInt(language.substring(4));
            if (version > 100) {
                this.stringBuf.append("#version ");
                this.stringBuf.append(language.substring(4));
                if (version >= 150) {
                    this.stringBuf.append(" core");
                }
                this.stringBuf.append("\n");
            } else if (gles2) {
                this.stringBuf.append("#version 100\n");
                if (source.getType() == Shader.ShaderType.Fragment) {
                    this.stringBuf.append("precision mediump float;\n");
                }
            } else {
                this.stringBuf.append("#version 110\n");
            }
        }
        if (this.linearizeSrgbImages) {
            this.stringBuf.append("#define SRGB 1\n");
        }
        this.stringBuf.append("#define ").append(source.getType().name().toUpperCase()).append("_SHADER 1\n");
        this.stringBuf.append(source.getDefines());
        this.stringBuf.append(source.getSource());
        this.intBuf1.clear();
        this.intBuf1.put(0, this.stringBuf.length());
        this.gl.glShaderSource(id, new String[]{this.stringBuf.toString()}, this.intBuf1);
        this.gl.glCompileShader(id);
        this.gl.glGetShader(id, 35713, this.intBuf1);
        boolean compiledOK = this.intBuf1.get(0) == 1;
        String infoLog = null;
        if (!compiledOK) {
            this.gl.glGetShader(id, 35716, this.intBuf1);
            int length = this.intBuf1.get(0);
            if (length > 3) {
                infoLog = this.gl.glGetShaderInfoLog(id, length);
            }
        }
        if (compiledOK) {
            if (infoLog != null) {
                logger.log(Level.WARNING, "{0} compiled successfully, compiler warnings: \n{1}", new Object[]{source.getName(), infoLog});
            } else {
                logger.log(Level.FINE, "{0} compiled successfully.", source.getName());
            }
        } else {
            logger.log(Level.WARNING, "Bad compile of:\n{0}", new Object[]{ShaderDebug.formatShaderSource(this.stringBuf.toString())});
            if (infoLog != null) {
                throw new RendererException("compile error in: " + source + "\n" + infoLog);
            }
            throw new RendererException("compile error in: " + source + "\nerror: <not provided>");
        }
        source.clearUpdateNeeded();
    }

    public void updateShaderData(Shader shader) {
        int id = shader.getId();
        boolean needRegister = false;
        if (id == -1) {
            id = this.gl.glCreateProgram();
            if (id == 0) {
                throw new RendererException("Invalid ID (" + id + ") received when trying to create shader program.");
            }
            shader.setId(id);
            needRegister = true;
        }
        boolean bindFragDataRequired = false;
        for (Shader.ShaderSource source : shader.getSources()) {
            if (source.isUpdateNeeded()) {
                this.updateShaderSourceData(source);
            }
            if (source.getType() == Shader.ShaderType.Fragment && source.getLanguage().equals("GLSL150")) {
                bindFragDataRequired = true;
            }
            this.gl.glAttachShader(id, source.getId());
        }
        if (bindFragDataRequired) {
            this.gl3.glBindFragDataLocation(id, 0, "outFragColor");
            for (int i = 0; i < this.limits.get((Object)Limits.FrameBufferMrtAttachments); ++i) {
                this.gl3.glBindFragDataLocation(id, i, "outFragData[" + i + "]");
            }
        }
        this.gl.glLinkProgram(id);
        this.gl.glGetProgram(id, 35714, this.intBuf1);
        boolean linkOK = this.intBuf1.get(0) == 1;
        String infoLog = null;
        if (!linkOK) {
            this.gl.glGetProgram(id, 35716, this.intBuf1);
            int length = this.intBuf1.get(0);
            if (length > 3) {
                infoLog = this.gl.glGetProgramInfoLog(id, length);
            }
        }
        if (linkOK) {
            if (infoLog != null) {
                logger.log(Level.WARNING, "Shader linked successfully. Linker warnings: \n{0}", infoLog);
            } else {
                logger.fine("Shader linked successfully.");
            }
            shader.clearUpdateNeeded();
            if (needRegister) {
                this.objManager.registerObject(shader);
                this.statistics.onNewShader();
            } else {
                this.resetUniformLocations(shader);
            }
        } else {
            if (infoLog != null) {
                throw new RendererException("Shader failed to link, shader:" + shader + "\n" + infoLog);
            }
            throw new RendererException("Shader failed to link, shader:" + shader + "\ninfo: <not provided>");
        }
    }

    @Override
    public void setShader(Shader shader) {
        if (shader == null) {
            throw new IllegalArgumentException("Shader cannot be null");
        }
        if (shader.isUpdateNeeded()) {
            this.updateShaderData(shader);
        }
        assert (shader.getId() > 0);
        this.updateShaderUniforms(shader);
        this.bindProgram(shader);
    }

    @Override
    public void deleteShaderSource(Shader.ShaderSource source) {
        if (source.getId() < 0) {
            logger.warning("Shader source is not uploaded to GPU, cannot delete.");
            return;
        }
        source.clearUpdateNeeded();
        this.gl.glDeleteShader(source.getId());
        source.resetObject();
    }

    @Override
    public void deleteShader(Shader shader) {
        if (shader.getId() == -1) {
            logger.warning("Shader is not uploaded to GPU, cannot delete.");
            return;
        }
        for (Shader.ShaderSource source : shader.getSources()) {
            if (source.getId() == -1) continue;
            this.gl.glDetachShader(shader.getId(), source.getId());
            this.deleteShaderSource(source);
        }
        this.gl.glDeleteProgram(shader.getId());
        this.statistics.onDeleteShader();
        shader.resetObject();
    }

    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst) {
        this.copyFrameBuffer(src, dst, true);
    }

    @Override
    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst, boolean copyDepth) {
        int mask;
        int dstY1;
        int dstX1;
        int srcY1;
        int srcX1;
        int prevFBO;
        int dstY0;
        int dstX0;
        int srcY0;
        int srcX0;
        if (this.caps.contains((Object)Caps.FrameBufferBlit)) {
            srcX0 = 0;
            srcY0 = 0;
            dstX0 = 0;
            dstY0 = 0;
            prevFBO = this.context.boundFBO;
            if (this.mainFbOverride != null) {
                if (src == null) {
                    src = this.mainFbOverride;
                }
                if (dst == null) {
                    dst = this.mainFbOverride;
                }
            }
            if (src != null && src.isUpdateNeeded()) {
                this.updateFrameBuffer(src);
            }
            if (dst != null && dst.isUpdateNeeded()) {
                this.updateFrameBuffer(dst);
            }
            if (src == null) {
                this.glfbo.glBindFramebufferEXT(36008, 0);
                srcX0 = this.vpX;
                srcY0 = this.vpY;
                srcX1 = this.vpX + this.vpW;
                srcY1 = this.vpY + this.vpH;
            } else {
                this.glfbo.glBindFramebufferEXT(36008, src.getId());
                srcX1 = src.getWidth();
                srcY1 = src.getHeight();
            }
            if (dst == null) {
                this.glfbo.glBindFramebufferEXT(36009, 0);
                dstX0 = this.vpX;
                dstY0 = this.vpY;
                dstX1 = this.vpX + this.vpW;
                dstY1 = this.vpY + this.vpH;
            } else {
                this.glfbo.glBindFramebufferEXT(36009, dst.getId());
                dstX1 = dst.getWidth();
                dstY1 = dst.getHeight();
            }
            mask = 16384;
            if (copyDepth) {
                mask |= 0x100;
            }
        } else {
            throw new RendererException("Framebuffer blitting not supported by the video hardware");
        }
        this.glfbo.glBlitFramebufferEXT(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, 9728);
        this.glfbo.glBindFramebufferEXT(36160, prevFBO);
    }

    private void checkFrameBufferError() {
        int status = this.glfbo.glCheckFramebufferStatusEXT(36160);
        switch (status) {
            case 36053: {
                break;
            }
            case 36061: {
                throw new IllegalStateException("Framebuffer object format is unsupported by the video hardware.");
            }
            case 36054: {
                throw new IllegalStateException("Framebuffer has erronous attachment.");
            }
            case 36055: {
                throw new IllegalStateException("Framebuffer doesn't have any renderbuffers attached.");
            }
            case 36057: {
                throw new IllegalStateException("Framebuffer attachments must have same dimensions.");
            }
            case 36058: {
                throw new IllegalStateException("Framebuffer attachments must have same formats.");
            }
            case 36059: {
                throw new IllegalStateException("Incomplete draw buffer.");
            }
            case 36060: {
                throw new IllegalStateException("Incomplete read buffer.");
            }
            case 36182: {
                throw new IllegalStateException("Incomplete multisample buffer.");
            }
            default: {
                throw new IllegalStateException("Some video driver error or programming error occured. Framebuffer object status is invalid. ");
            }
        }
    }

    private void updateRenderBuffer(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        int id = rb.getId();
        if (id == -1) {
            this.glfbo.glGenRenderbuffersEXT(this.intBuf1);
            id = this.intBuf1.get(0);
            rb.setId(id);
        }
        if (this.context.boundRB != id) {
            this.glfbo.glBindRenderbufferEXT(36161, id);
            this.context.boundRB = id;
        }
        int rbSize = this.limits.get((Object)Limits.RenderBufferSize);
        if (fb.getWidth() > rbSize || fb.getHeight() > rbSize) {
            throw new RendererException("Resolution " + fb.getWidth() + ":" + fb.getHeight() + " is not supported.");
        }
        GLImageFormat glFmt = this.texUtil.getImageFormatWithError(rb.getFormat(), fb.isSrgb());
        if (fb.getSamples() > 1 && this.caps.contains((Object)Caps.FrameBufferMultisample)) {
            int samples = fb.getSamples();
            int maxSamples = this.limits.get((Object)Limits.FrameBufferSamples);
            if (maxSamples < samples) {
                samples = maxSamples;
            }
            this.glfbo.glRenderbufferStorageMultisampleEXT(36161, samples, glFmt.internalFormat, fb.getWidth(), fb.getHeight());
        } else {
            this.glfbo.glRenderbufferStorageEXT(36161, glFmt.internalFormat, fb.getWidth(), fb.getHeight());
        }
    }

    private int convertAttachmentSlot(int attachmentSlot) {
        if (attachmentSlot == -100) {
            return 36096;
        }
        if (attachmentSlot == -101) {
            return 33306;
        }
        if (attachmentSlot < 0 || attachmentSlot >= 16) {
            throw new UnsupportedOperationException("Invalid FBO attachment slot: " + attachmentSlot);
        }
        return 36064 + attachmentSlot;
    }

    public void updateRenderTexture(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        Texture tex = rb.getTexture();
        Image image = tex.getImage();
        if (image.isUpdateNeeded()) {
            this.checkNonPowerOfTwo(tex);
            this.updateTexImageData(image, tex.getType(), 0, false);
            this.setupTextureParams(tex);
        }
        this.glfbo.glFramebufferTexture2DEXT(36160, this.convertAttachmentSlot(rb.getSlot()), this.convertTextureType(tex.getType(), image.getMultiSamples(), rb.getFace()), image.getId(), 0);
    }

    public void updateFrameBufferAttachment(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        boolean needAttach;
        if (rb.getTexture() == null) {
            needAttach = rb.getId() == -1;
            this.updateRenderBuffer(fb, rb);
        } else {
            needAttach = false;
            this.updateRenderTexture(fb, rb);
        }
        if (needAttach) {
            this.glfbo.glFramebufferRenderbufferEXT(36160, this.convertAttachmentSlot(rb.getSlot()), 36161, rb.getId());
        }
    }

    public void updateFrameBuffer(FrameBuffer fb) {
        FrameBuffer.RenderBuffer depthBuf;
        int id = fb.getId();
        if (id == -1) {
            this.glfbo.glGenFramebuffersEXT(this.intBuf1);
            id = this.intBuf1.get(0);
            fb.setId(id);
            this.objManager.registerObject(fb);
            this.statistics.onNewFrameBuffer();
        }
        if (this.context.boundFBO != id) {
            this.glfbo.glBindFramebufferEXT(36160, id);
            this.context.boundDrawBuf = 0;
            this.context.boundFBO = id;
        }
        if ((depthBuf = fb.getDepthBuffer()) != null) {
            this.updateFrameBufferAttachment(fb, depthBuf);
        }
        for (int i = 0; i < fb.getNumColorBuffers(); ++i) {
            FrameBuffer.RenderBuffer colorBuf = fb.getColorBuffer(i);
            this.updateFrameBufferAttachment(fb, colorBuf);
        }
        this.checkFrameBufferError();
        fb.clearUpdateNeeded();
    }

    public Vector2f[] getFrameBufferSamplePositions(FrameBuffer fb) {
        if (fb.getSamples() <= 1) {
            throw new IllegalArgumentException("Framebuffer must be multisampled");
        }
        if (!this.caps.contains((Object)Caps.TextureMultisample)) {
            throw new RendererException("Multisampled textures are not supported");
        }
        this.setFrameBuffer(fb);
        Vector2f[] samplePositions = new Vector2f[fb.getSamples()];
        FloatBuffer samplePos = BufferUtils.createFloatBuffer(2);
        for (int i = 0; i < samplePositions.length; ++i) {
            this.glext.glGetMultisample(36432, i, samplePos);
            samplePos.clear();
            samplePositions[i] = new Vector2f(samplePos.get(0) - 0.5f, samplePos.get(1) - 0.5f);
        }
        return samplePositions;
    }

    @Override
    public void setMainFrameBufferOverride(FrameBuffer fb) {
        this.mainFbOverride = fb;
    }

    @Override
    public void setFrameBuffer(FrameBuffer fb) {
        int i;
        if (fb == null && this.mainFbOverride != null) {
            fb = this.mainFbOverride;
        }
        if (!(this.context.boundFB != fb || fb != null && fb.isUpdateNeeded())) {
            return;
        }
        if (!this.caps.contains((Object)Caps.FrameBuffer)) {
            throw new RendererException("Framebuffer objects are not supported by the video hardware");
        }
        if (this.context.boundFB != null) {
            for (i = 0; i < this.context.boundFB.getNumColorBuffers(); ++i) {
                FrameBuffer.RenderBuffer rb = this.context.boundFB.getColorBuffer(i);
                Texture tex = rb.getTexture();
                if (tex == null || !tex.getMinFilter().usesMipMapLevels()) continue;
                this.setTexture(0, rb.getTexture());
                int textureType = this.convertTextureType(tex.getType(), tex.getImage().getMultiSamples(), rb.getFace());
                this.glfbo.glGenerateMipmapEXT(textureType);
            }
        }
        if (fb == null) {
            if (this.context.boundFBO != 0) {
                this.glfbo.glBindFramebufferEXT(36160, 0);
                this.statistics.onFrameBufferUse(null, true);
                this.context.boundFBO = 0;
            }
            if (this.gl2 != null) {
                if (this.context.boundDrawBuf != -1) {
                    this.gl2.glDrawBuffer(this.context.initialDrawBuf);
                    this.context.boundDrawBuf = -1;
                }
                if (this.context.boundReadBuf != -1) {
                    this.gl2.glReadBuffer(this.context.initialReadBuf);
                    this.context.boundReadBuf = -1;
                }
            }
            this.context.boundFB = null;
        } else {
            if (fb.getNumColorBuffers() == 0 && fb.getDepthBuffer() == null) {
                throw new IllegalArgumentException("The framebuffer: " + fb + "\nDoesn't have any color/depth buffers");
            }
            if (fb.isUpdateNeeded()) {
                this.updateFrameBuffer(fb);
            }
            this.setViewPort(0, 0, fb.getWidth(), fb.getHeight());
            if (this.context.boundFBO != fb.getId()) {
                this.glfbo.glBindFramebufferEXT(36160, fb.getId());
                this.statistics.onFrameBufferUse(fb, true);
                this.context.boundFBO = fb.getId();
            } else {
                this.statistics.onFrameBufferUse(fb, false);
            }
            if (fb.getNumColorBuffers() == 0) {
                if (this.gl2 != null) {
                    if (this.context.boundDrawBuf != -2) {
                        this.gl2.glDrawBuffer(0);
                        this.context.boundDrawBuf = -2;
                    }
                    if (this.context.boundReadBuf != -2) {
                        this.gl2.glReadBuffer(0);
                        this.context.boundReadBuf = -2;
                    }
                }
            } else {
                if (fb.getNumColorBuffers() > this.limits.get((Object)Limits.FrameBufferAttachments)) {
                    throw new RendererException("Framebuffer has more color attachments than are supported by the video hardware!");
                }
                if (fb.isMultiTarget()) {
                    if (!this.caps.contains((Object)Caps.FrameBufferMRT)) {
                        throw new RendererException("Multiple render targets  are not supported by the video hardware");
                    }
                    if (fb.getNumColorBuffers() > this.limits.get((Object)Limits.FrameBufferMrtAttachments)) {
                        throw new RendererException("Framebuffer has more multi targets than are supported by the video hardware!");
                    }
                    if (this.context.boundDrawBuf != 100 + fb.getNumColorBuffers()) {
                        this.intBuf16.clear();
                        for (i = 0; i < fb.getNumColorBuffers(); ++i) {
                            this.intBuf16.put(36064 + i);
                        }
                        this.intBuf16.flip();
                        this.glext.glDrawBuffers(this.intBuf16);
                        this.context.boundDrawBuf = 100 + fb.getNumColorBuffers();
                    }
                } else {
                    FrameBuffer.RenderBuffer rb = fb.getColorBuffer(fb.getTargetIndex());
                    if (this.gl2 != null && this.context.boundDrawBuf != rb.getSlot()) {
                        this.gl2.glDrawBuffer(36064 + rb.getSlot());
                        this.context.boundDrawBuf = rb.getSlot();
                    }
                }
            }
            assert (fb.getId() >= 0);
            assert (this.context.boundFBO == fb.getId());
            this.context.boundFB = fb;
        }
    }

    @Override
    public void readFrameBuffer(FrameBuffer fb, ByteBuffer byteBuf) {
        this.readFrameBufferWithGLFormat(fb, byteBuf, 6408, 5121);
    }

    private void readFrameBufferWithGLFormat(FrameBuffer fb, ByteBuffer byteBuf, int glFormat, int dataType) {
        if (fb != null) {
            FrameBuffer.RenderBuffer rb = fb.getColorBuffer();
            if (rb == null) {
                throw new IllegalArgumentException("Specified framebuffer does not have a colorbuffer");
            }
            this.setFrameBuffer(fb);
            if (this.gl2 != null && this.context.boundReadBuf != rb.getSlot()) {
                this.gl2.glReadBuffer(36064 + rb.getSlot());
                this.context.boundReadBuf = rb.getSlot();
            }
        } else {
            this.setFrameBuffer(null);
        }
        this.gl.glReadPixels(this.vpX, this.vpY, this.vpW, this.vpH, glFormat, dataType, byteBuf);
    }

    @Override
    public void readFrameBufferWithFormat(FrameBuffer fb, ByteBuffer byteBuf, Image.Format format) {
        GLImageFormat glFormat = this.texUtil.getImageFormatWithError(format, false);
        this.readFrameBufferWithGLFormat(fb, byteBuf, glFormat.format, glFormat.dataType);
    }

    private void deleteRenderBuffer(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        this.intBuf1.put(0, rb.getId());
        this.glfbo.glDeleteRenderbuffersEXT(this.intBuf1);
    }

    @Override
    public void deleteFrameBuffer(FrameBuffer fb) {
        if (fb.getId() != -1) {
            if (this.context.boundFBO == fb.getId()) {
                this.glfbo.glBindFramebufferEXT(36160, 0);
                this.context.boundFBO = 0;
            }
            if (fb.getDepthBuffer() != null) {
                this.deleteRenderBuffer(fb, fb.getDepthBuffer());
            }
            if (fb.getColorBuffer() != null) {
                this.deleteRenderBuffer(fb, fb.getColorBuffer());
            }
            this.intBuf1.put(0, fb.getId());
            this.glfbo.glDeleteFramebuffersEXT(this.intBuf1);
            fb.resetObject();
            this.statistics.onDeleteFrameBuffer();
        }
    }

    private int convertTextureType(Texture.Type type, int samples, int face) {
        if (samples > 1 && !this.caps.contains((Object)Caps.TextureMultisample)) {
            throw new RendererException("Multisample textures are not supported by the video hardware.");
        }
        switch (type) {
            case TwoDimensional: {
                if (samples > 1) {
                    return 37120;
                }
                return 3553;
            }
            case TwoDimensionalArray: {
                if (!this.caps.contains((Object)Caps.TextureArray)) {
                    throw new RendererException("Array textures are not supported by the video hardware.");
                }
                if (samples > 1) {
                    return 37122;
                }
                return 35866;
            }
            case ThreeDimensional: {
                if (!this.caps.contains((Object)Caps.OpenGL20)) {
                    throw new RendererException("3D textures are not supported by the video hardware.");
                }
                return 32879;
            }
            case CubeMap: {
                if (face < 0) {
                    return 34067;
                }
                if (face < 6) {
                    return 34069 + face;
                }
                throw new UnsupportedOperationException("Invalid cube map face index: " + face);
            }
        }
        throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)type));
    }

    private int convertMagFilter(Texture.MagFilter filter) {
        switch (filter) {
            case Bilinear: {
                return 9729;
            }
            case Nearest: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown mag filter: " + (Object)((Object)filter));
    }

    private int convertMinFilter(Texture.MinFilter filter, boolean haveMips) {
        if (haveMips) {
            switch (filter) {
                case Trilinear: {
                    return 9987;
                }
                case BilinearNearestMipMap: {
                    return 9985;
                }
                case NearestLinearMipMap: {
                    return 9986;
                }
                case NearestNearestMipMap: {
                    return 9984;
                }
                case BilinearNoMipMaps: {
                    return 9729;
                }
                case NearestNoMipMaps: {
                    return 9728;
                }
            }
            throw new UnsupportedOperationException("Unknown min filter: " + (Object)((Object)filter));
        }
        switch (filter) {
            case Trilinear: 
            case BilinearNearestMipMap: 
            case BilinearNoMipMaps: {
                return 9729;
            }
            case NearestLinearMipMap: 
            case NearestNearestMipMap: 
            case NearestNoMipMaps: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown min filter: " + (Object)((Object)filter));
    }

    private int convertWrapMode(Texture.WrapMode mode) {
        switch (mode) {
            case BorderClamp: 
            case Clamp: 
            case EdgeClamp: {
                return 33071;
            }
            case Repeat: {
                return 10497;
            }
            case MirroredRepeat: {
                return 33648;
            }
        }
        throw new UnsupportedOperationException("Unknown wrap mode: " + (Object)((Object)mode));
    }

    private void setupTextureParams(Texture tex) {
        Image image = tex.getImage();
        int target = this.convertTextureType(tex.getType(), image != null ? image.getMultiSamples() : 1, -1);
        boolean haveMips = true;
        if (image != null) {
            boolean bl = haveMips = image.isGeneratedMipmapsRequired() || image.hasMipmaps();
        }
        if (image.getLastTextureState().magFilter != tex.getMagFilter()) {
            int magFilter = this.convertMagFilter(tex.getMagFilter());
            this.gl.glTexParameteri(target, 10240, magFilter);
            image.getLastTextureState().magFilter = tex.getMagFilter();
        }
        if (image.getLastTextureState().minFilter != tex.getMinFilter()) {
            int minFilter = this.convertMinFilter(tex.getMinFilter(), haveMips);
            this.gl.glTexParameteri(target, 10241, minFilter);
            image.getLastTextureState().minFilter = tex.getMinFilter();
        }
        if (this.caps.contains((Object)Caps.SeamlessCubemap) && tex.getType() == Texture.Type.CubeMap) {
            if (haveMips && !this.context.seamlessCubemap) {
                this.gl.glEnable(34895);
                this.context.seamlessCubemap = true;
            } else if (!haveMips && this.context.seamlessCubemap) {
                this.gl.glDisable(34895);
                this.context.seamlessCubemap = false;
            }
        }
        if (tex.getAnisotropicFilter() > 1 && this.caps.contains((Object)Caps.TextureFilterAnisotropic)) {
            this.gl.glTexParameterf(target, 34046, tex.getAnisotropicFilter());
        }
        switch (tex.getType()) {
            case ThreeDimensional: 
            case CubeMap: {
                if (this.gl2 != null && image.getLastTextureState().rWrap != tex.getWrap(Texture.WrapAxis.R)) {
                    this.gl2.glTexParameteri(target, 32882, this.convertWrapMode(tex.getWrap(Texture.WrapAxis.R)));
                    image.getLastTextureState().rWrap = tex.getWrap(Texture.WrapAxis.R);
                }
            }
            case TwoDimensional: 
            case TwoDimensionalArray: {
                if (image.getLastTextureState().tWrap != tex.getWrap(Texture.WrapAxis.T)) {
                    this.gl.glTexParameteri(target, 10243, this.convertWrapMode(tex.getWrap(Texture.WrapAxis.T)));
                    image.getLastTextureState().tWrap = tex.getWrap(Texture.WrapAxis.T);
                }
                if (image.getLastTextureState().sWrap == tex.getWrap(Texture.WrapAxis.S)) break;
                this.gl.glTexParameteri(target, 10242, this.convertWrapMode(tex.getWrap(Texture.WrapAxis.S)));
                image.getLastTextureState().sWrap = tex.getWrap(Texture.WrapAxis.S);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)tex.getType()));
            }
        }
        if (tex.isNeedCompareModeUpdate() && this.gl2 != null) {
            if (tex.getShadowCompareMode() != Texture.ShadowCompareMode.Off) {
                this.gl2.glTexParameteri(target, 34892, 34894);
                this.gl2.glTexParameteri(target, 34891, 32841);
                if (tex.getShadowCompareMode() == Texture.ShadowCompareMode.GreaterOrEqual) {
                    this.gl2.glTexParameteri(target, 34893, 518);
                } else {
                    this.gl2.glTexParameteri(target, 34893, 515);
                }
            } else {
                this.gl2.glTexParameteri(target, 34892, 0);
            }
            tex.compareModeUpdated();
        }
    }

    private void checkNonPowerOfTwo(Texture tex) {
        if (!tex.getImage().isNPOT()) {
            return;
        }
        if (this.caps.contains((Object)Caps.NonPowerOfTwoTextures)) {
            return;
        }
        if (!this.caps.contains((Object)Caps.PartialNonPowerOfTwoTextures)) {
            throw new RendererException("non-power-of-2 textures are not supported by the video hardware");
        }
        if (tex.getMinFilter().usesMipMapLevels()) {
            throw new RendererException("non-power-of-2 textures with mip-maps are not supported by the video hardware");
        }
        switch (tex.getType()) {
            case ThreeDimensional: 
            case CubeMap: {
                if (tex.getWrap(Texture.WrapAxis.R) != Texture.WrapMode.EdgeClamp) {
                    throw new RendererException("repeating non-power-of-2 textures are not supported by the video hardware");
                }
            }
            case TwoDimensional: 
            case TwoDimensionalArray: {
                if (tex.getWrap(Texture.WrapAxis.S) == Texture.WrapMode.EdgeClamp && tex.getWrap(Texture.WrapAxis.T) == Texture.WrapMode.EdgeClamp) break;
                throw new RendererException("repeating non-power-of-2 textures are not supported by the video hardware");
            }
            default: {
                throw new UnsupportedOperationException("unrecongized texture type");
            }
        }
    }

    public void updateTexImageData(Image img, Texture.Type type, int unit, boolean scaleToPot) {
        int imageSamples;
        int texId = img.getId();
        if (texId == -1) {
            this.gl.glGenTextures(this.intBuf1);
            texId = this.intBuf1.get(0);
            img.setId(texId);
            this.objManager.registerObject(img);
            this.statistics.onNewTexture();
        }
        int target = this.convertTextureType(type, img.getMultiSamples(), -1);
        if (this.context.boundTextures[unit] != img) {
            if (this.context.boundTextureUnit != unit) {
                this.gl.glActiveTexture(33984 + unit);
                this.context.boundTextureUnit = unit;
            }
            this.gl.glBindTexture(target, texId);
            this.context.boundTextures[unit] = img;
            this.statistics.onTextureUse(img, true);
        }
        if (!img.hasMipmaps() && img.isGeneratedMipmapsRequired()) {
            if (!this.caps.contains((Object)Caps.FrameBuffer) && this.gl2 != null) {
                this.gl2.glTexParameteri(target, 33169, 1);
                img.setMipmapsGenerated(true);
            }
        } else if (img.hasMipmaps()) {
            this.gl.glTexParameteri(target, 33085, img.getMipMapSizes().length - 1);
        } else {
            this.gl.glTexParameteri(target, 33085, 0);
        }
        if ((imageSamples = img.getMultiSamples()) > 1) {
            if (img.getFormat().isDepthFormat()) {
                img.setMultiSamples(Math.min(this.limits.get((Object)Limits.DepthTextureSamples), imageSamples));
            } else {
                img.setMultiSamples(Math.min(this.limits.get((Object)Limits.ColorTextureSamples), imageSamples));
            }
        }
        if (!this.caps.contains((Object)Caps.TextureMultisample) && img.getMultiSamples() > 1) {
            throw new RendererException("Multisample textures are not supported by the video hardware");
        }
        if (img.getFormat().isDepthFormat() && !this.caps.contains((Object)Caps.DepthTexture)) {
            throw new RendererException("Depth textures are not supported by the video hardware");
        }
        if (target == 34067) {
            int cubeSize = this.limits.get((Object)Limits.CubemapSize);
            if (img.getWidth() > cubeSize || img.getHeight() > cubeSize) {
                throw new RendererException("Cannot upload cubemap " + img + ". The maximum supported cubemap resolution is " + cubeSize);
            }
            if (img.getWidth() != img.getHeight()) {
                throw new RendererException("Cubemaps must have square dimensions");
            }
        } else {
            int texSize = this.limits.get((Object)Limits.TextureSize);
            if (img.getWidth() > texSize || img.getHeight() > texSize) {
                throw new RendererException("Cannot upload texture " + img + ". The maximum supported texture resolution is " + texSize);
            }
        }
        Image imageForUpload = scaleToPot ? MipMapGenerator.resizeToPowerOf2(img) : img;
        if (target == 34067) {
            List<ByteBuffer> data = imageForUpload.getData();
            if (data.size() != 6) {
                logger.log(Level.WARNING, "Invalid texture: {0}\nCubemap textures must contain 6 data units.", img);
                return;
            }
            for (int i = 0; i < 6; ++i) {
                this.texUtil.uploadTexture(imageForUpload, 34069 + i, i, this.linearizeSrgbImages);
            }
        } else if (target == 35866) {
            if (!this.caps.contains((Object)Caps.TextureArray)) {
                throw new RendererException("Texture arrays not supported by graphics hardware");
            }
            List<ByteBuffer> data = imageForUpload.getData();
            this.texUtil.uploadTexture(imageForUpload, target, -1, this.linearizeSrgbImages);
            for (int i = 0; i < data.size(); ++i) {
                this.texUtil.uploadTexture(imageForUpload, target, i, this.linearizeSrgbImages);
            }
        } else {
            this.texUtil.uploadTexture(imageForUpload, target, 0, this.linearizeSrgbImages);
        }
        if (img.getMultiSamples() != imageSamples) {
            img.setMultiSamples(imageSamples);
        }
        if ((this.caps.contains((Object)Caps.FrameBuffer) || this.gl2 == null) && !img.hasMipmaps() && img.isGeneratedMipmapsRequired() && img.getData(0) != null) {
            this.glfbo.glGenerateMipmapEXT(target);
            img.setMipmapsGenerated(true);
        }
        img.clearUpdateNeeded();
    }

    @Override
    public void setTexture(int unit, Texture tex) {
        Image image = tex.getImage();
        if (image.isUpdateNeeded() || image.isGeneratedMipmapsRequired() && !image.isMipmapsGenerated()) {
            boolean scaleToPot = false;
            try {
                this.checkNonPowerOfTwo(tex);
            }
            catch (RendererException ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    int nextWidth = FastMath.nearestPowerOfTwo(tex.getImage().getWidth());
                    int nextHeight = FastMath.nearestPowerOfTwo(tex.getImage().getHeight());
                    logger.log(Level.WARNING, "Non-power-of-2 textures are not supported! Scaling texture '" + tex.getName() + "' of size " + tex.getImage().getWidth() + "x" + tex.getImage().getHeight() + " to " + nextWidth + "x" + nextHeight);
                }
                scaleToPot = true;
            }
            this.updateTexImageData(image, tex.getType(), unit, scaleToPot);
        }
        int texId = image.getId();
        assert (texId != -1);
        Image[] textures = this.context.boundTextures;
        int type = this.convertTextureType(tex.getType(), image.getMultiSamples(), -1);
        if (textures[unit] != image) {
            if (this.context.boundTextureUnit != unit) {
                this.gl.glActiveTexture(33984 + unit);
                this.context.boundTextureUnit = unit;
            }
            this.gl.glBindTexture(type, texId);
            textures[unit] = image;
            this.statistics.onTextureUse(image, true);
        } else {
            this.statistics.onTextureUse(image, false);
        }
        this.setupTextureParams(tex);
    }

    @Override
    public void modifyTexture(Texture tex, Image pixels, int x, int y) {
        this.setTexture(0, tex);
        int target = this.convertTextureType(tex.getType(), pixels.getMultiSamples(), -1);
        this.texUtil.uploadSubTexture(pixels, target, 0, x, y, this.linearizeSrgbImages);
    }

    @Override
    public void deleteImage(Image image) {
        int texId = image.getId();
        if (texId != -1) {
            this.intBuf1.put(0, texId);
            this.intBuf1.position(0).limit(1);
            this.gl.glDeleteTextures(this.intBuf1);
            image.resetObject();
            this.statistics.onDeleteTexture();
        }
    }

    private int convertUsage(VertexBuffer.Usage usage) {
        switch (usage) {
            case Static: {
                return 35044;
            }
            case Dynamic: {
                return 35048;
            }
            case Stream: {
                return 35040;
            }
        }
        throw new UnsupportedOperationException("Unknown usage type.");
    }

    private int convertFormat(VertexBuffer.Format format) {
        switch (format) {
            case Byte: {
                return 5120;
            }
            case UnsignedByte: {
                return 5121;
            }
            case Short: {
                return 5122;
            }
            case UnsignedShort: {
                return 5123;
            }
            case Int: {
                return 5124;
            }
            case UnsignedInt: {
                return 5125;
            }
            case Float: {
                return 5126;
            }
            case Double: {
                return 5130;
            }
        }
        throw new UnsupportedOperationException("Unknown buffer format.");
    }

    @Override
    public void updateBufferData(VertexBuffer vb) {
        int target;
        int bufId = vb.getId();
        boolean created = false;
        if (bufId == -1) {
            this.gl.glGenBuffers(this.intBuf1);
            bufId = this.intBuf1.get(0);
            vb.setId(bufId);
            this.objManager.registerObject(vb);
            created = true;
        }
        if (vb.getBufferType() == VertexBuffer.Type.Index) {
            target = 34963;
            if (this.context.boundElementArrayVBO != bufId) {
                this.gl.glBindBuffer(target, bufId);
                this.context.boundElementArrayVBO = bufId;
            }
        } else {
            target = 34962;
            if (this.context.boundArrayVBO != bufId) {
                this.gl.glBindBuffer(target, bufId);
                this.context.boundArrayVBO = bufId;
            }
        }
        int usage = this.convertUsage(vb.getUsage());
        vb.getData().rewind();
        switch (vb.getFormat()) {
            case Byte: 
            case UnsignedByte: {
                this.gl.glBufferData(target, (ByteBuffer)vb.getData(), usage);
                break;
            }
            case Short: 
            case UnsignedShort: {
                this.gl.glBufferData(target, (ShortBuffer)vb.getData(), usage);
                break;
            }
            case Int: 
            case UnsignedInt: {
                this.glext.glBufferData(target, (IntBuffer)vb.getData(), usage);
                break;
            }
            case Float: {
                this.gl.glBufferData(target, (FloatBuffer)vb.getData(), usage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown buffer format.");
            }
        }
        vb.clearUpdateNeeded();
    }

    @Override
    public void deleteBuffer(VertexBuffer vb) {
        int bufId = vb.getId();
        if (bufId != -1) {
            this.intBuf1.put(0, bufId);
            this.intBuf1.position(0).limit(1);
            this.gl.glDeleteBuffers(this.intBuf1);
            vb.resetObject();
        }
    }

    public void clearVertexAttribs() {
        IDList attribList = this.context.attribIndexList;
        for (int i = 0; i < attribList.oldLen; ++i) {
            int idx = attribList.oldList[i];
            this.gl.glDisableVertexAttribArray(idx);
            if (this.context.boundAttribs[idx].isInstanced()) {
                this.glext.glVertexAttribDivisorARB(idx, 0);
            }
            this.context.boundAttribs[idx] = null;
        }
        this.context.attribIndexList.copyNewToOld();
    }

    public void setVertexAttrib(VertexBuffer vb, VertexBuffer idb) {
        if (vb.getBufferType() == VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Index buffers not allowed to be set to vertex attrib");
        }
        if (this.context.boundShaderProgram <= 0) {
            throw new IllegalStateException("Cannot render mesh without shader bound");
        }
        Attribute attrib = this.context.boundShader.getAttribute(vb.getBufferType());
        int loc = attrib.getLocation();
        if (loc == -1) {
            return;
        }
        if (loc == -2) {
            loc = this.gl.glGetAttribLocation(this.context.boundShaderProgram, "in" + vb.getBufferType().name());
            if (loc < 0) {
                attrib.setLocation(-1);
                return;
            }
            attrib.setLocation(loc);
        }
        if (vb.isInstanced() && !this.caps.contains((Object)Caps.MeshInstancing)) {
            throw new RendererException("Instancing is required, but not supported by the graphics hardware");
        }
        int slotsRequired = 1;
        if (vb.getNumComponents() > 4) {
            if (vb.getNumComponents() % 4 != 0) {
                throw new RendererException("Number of components in multi-slot buffers must be divisible by 4");
            }
            slotsRequired = vb.getNumComponents() / 4;
        }
        if (vb.isUpdateNeeded() && idb == null) {
            this.updateBufferData(vb);
        }
        VertexBuffer[] attribs = this.context.boundAttribs;
        for (int i = 0; i < slotsRequired; ++i) {
            if (this.context.attribIndexList.moveToNew(loc + i)) continue;
            this.gl.glEnableVertexAttribArray(loc + i);
        }
        if (attribs[loc] != vb) {
            int i;
            int bufId;
            int n = bufId = idb != null ? idb.getId() : vb.getId();
            assert (bufId != -1);
            if (this.context.boundArrayVBO != bufId) {
                this.gl.glBindBuffer(34962, bufId);
                this.context.boundArrayVBO = bufId;
            }
            if (slotsRequired == 1) {
                this.gl.glVertexAttribPointer(loc, vb.getNumComponents(), this.convertFormat(vb.getFormat()), vb.isNormalized(), vb.getStride(), vb.getOffset());
            } else {
                for (i = 0; i < slotsRequired; ++i) {
                    this.gl.glVertexAttribPointer(loc + i, 4, this.convertFormat(vb.getFormat()), vb.isNormalized(), 16 * slotsRequired, 16 * i);
                }
            }
            for (i = 0; i < slotsRequired; ++i) {
                int slot = loc + i;
                if (vb.isInstanced() && (attribs[slot] == null || !attribs[slot].isInstanced())) {
                    this.glext.glVertexAttribDivisorARB(slot, vb.getInstanceSpan());
                } else if (!vb.isInstanced() && attribs[slot] != null && attribs[slot].isInstanced()) {
                    this.glext.glVertexAttribDivisorARB(slot, 0);
                }
                attribs[slot] = vb;
            }
        }
    }

    public void setVertexAttrib(VertexBuffer vb) {
        this.setVertexAttrib(vb, null);
    }

    public void drawTriangleArray(Mesh.Mode mode, int count, int vertCount) {
        boolean useInstancing;
        boolean bl = useInstancing = count > 1 && this.caps.contains((Object)Caps.MeshInstancing);
        if (useInstancing) {
            this.glext.glDrawArraysInstancedARB(this.convertElementMode(mode), 0, vertCount, count);
        } else {
            this.gl.glDrawArrays(this.convertElementMode(mode), 0, vertCount);
        }
    }

    public void drawTriangleList(VertexBuffer indexBuf, Mesh mesh, int count) {
        boolean useInstancing;
        if (indexBuf.getBufferType() != VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Only index buffers are allowed as triangle lists.");
        }
        switch (indexBuf.getFormat()) {
            case UnsignedShort: {
                break;
            }
            case UnsignedInt: {
                if (this.caps.contains((Object)Caps.IntegerIndexBuffer)) break;
                throw new RendererException("32-bit index buffers are not supported by the video hardware");
            }
            default: {
                throw new RendererException("Unexpected format for index buffer: " + (Object)((Object)indexBuf.getFormat()));
            }
        }
        if (indexBuf.isUpdateNeeded()) {
            this.updateBufferData(indexBuf);
        }
        int bufId = indexBuf.getId();
        assert (bufId != -1);
        if (this.context.boundElementArrayVBO != bufId) {
            this.gl.glBindBuffer(34963, bufId);
            this.context.boundElementArrayVBO = bufId;
        }
        int vertCount = mesh.getVertexCount();
        boolean bl = useInstancing = count > 1 && this.caps.contains((Object)Caps.MeshInstancing);
        if (mesh.getMode() == Mesh.Mode.Hybrid) {
            int[] modeStart = mesh.getModeStart();
            int[] elementLengths = mesh.getElementLengths();
            int elMode = this.convertElementMode(Mesh.Mode.Triangles);
            int fmt = this.convertFormat(indexBuf.getFormat());
            int elSize = indexBuf.getFormat().getComponentSize();
            int listStart = modeStart[0];
            int stripStart = modeStart[1];
            int fanStart = modeStart[2];
            int curOffset = 0;
            for (int i = 0; i < elementLengths.length; ++i) {
                if (i == stripStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                } else if (i == fanStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleFan);
                }
                int elementLength = elementLengths[i];
                if (useInstancing) {
                    this.glext.glDrawElementsInstancedARB(elMode, elementLength, fmt, curOffset, count);
                } else {
                    this.gl.glDrawRangeElements(elMode, 0, vertCount, elementLength, fmt, curOffset);
                }
                curOffset += elementLength * elSize;
            }
        } else if (useInstancing) {
            this.glext.glDrawElementsInstancedARB(this.convertElementMode(mesh.getMode()), indexBuf.getData().limit(), this.convertFormat(indexBuf.getFormat()), 0L, count);
        } else {
            this.gl.glDrawRangeElements(this.convertElementMode(mesh.getMode()), 0, vertCount, indexBuf.getData().limit(), this.convertFormat(indexBuf.getFormat()), 0L);
        }
    }

    public int convertElementMode(Mesh.Mode mode) {
        switch (mode) {
            case Points: {
                return 0;
            }
            case Lines: {
                return 1;
            }
            case LineLoop: {
                return 2;
            }
            case LineStrip: {
                return 3;
            }
            case Triangles: {
                return 4;
            }
            case TriangleFan: {
                return 6;
            }
            case TriangleStrip: {
                return 5;
            }
            case Patch: {
                return 14;
            }
        }
        throw new UnsupportedOperationException("Unrecognized mesh mode: " + (Object)((Object)mode));
    }

    public void updateVertexArray(Mesh mesh, VertexBuffer instanceData) {
        VertexBuffer interleavedData;
        int id = mesh.getId();
        if (id == -1) {
            IntBuffer temp = this.intBuf1;
            this.gl3.glGenVertexArrays(temp);
            id = temp.get(0);
            mesh.setId(id);
        }
        if (this.context.boundVertexArray != id) {
            this.gl3.glBindVertexArray(id);
            this.context.boundVertexArray = id;
        }
        if ((interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData)) != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        if (instanceData != null) {
            this.setVertexAttrib(instanceData, null);
        }
        for (VertexBuffer vb : mesh.getBufferList().getArray()) {
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
    }

    private void renderMeshVertexArray(Mesh mesh, int lod, int count, VertexBuffer instanceData) {
        VertexBuffer indices;
        if (mesh.getId() == -1) {
            this.updateVertexArray(mesh, instanceData);
        }
        if (this.context.boundVertexArray != mesh.getId()) {
            this.gl3.glBindVertexArray(mesh.getId());
            this.context.boundVertexArray = mesh.getId();
        }
        if ((indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : mesh.getBuffer(VertexBuffer.Type.Index)) != null) {
            this.drawTriangleList(indices, mesh, count);
        } else {
            this.drawTriangleArray(mesh.getMode(), count, mesh.getVertexCount());
        }
        this.clearVertexAttribs();
    }

    private void renderMeshDefault(Mesh mesh, int lod, int count, VertexBuffer[] instanceData) {
        count = Math.max(mesh.getInstanceCount(), count);
        VertexBuffer interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData);
        if (interleavedData != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        VertexBuffer indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : mesh.getBuffer(VertexBuffer.Type.Index);
        if (instanceData != null) {
            for (VertexBuffer vb : instanceData) {
                this.setVertexAttrib(vb, null);
            }
        }
        for (VertexBuffer vb : mesh.getBufferList().getArray()) {
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
        if (indices != null) {
            this.drawTriangleList(indices, mesh, count);
        } else {
            this.drawTriangleArray(mesh.getMode(), count, mesh.getVertexCount());
        }
        this.clearVertexAttribs();
    }

    @Override
    public void renderMesh(Mesh mesh, int lod, int count, VertexBuffer[] instanceData) {
        if (mesh.getVertexCount() == 0) {
            return;
        }
        if (this.context.lineWidth != mesh.getLineWidth()) {
            this.gl.glLineWidth(mesh.getLineWidth());
            this.context.lineWidth = mesh.getLineWidth();
        }
        if (this.gl4 != null && mesh.getMode().equals((Object)Mesh.Mode.Patch)) {
            this.gl4.glPatchParameter(mesh.getPatchVertexCount());
        }
        this.statistics.onMeshDrawn(mesh, lod, count);
        this.renderMeshDefault(mesh, lod, count, instanceData);
    }

    @Override
    public void setMainFrameBufferSrgb(boolean enableSrgb) {
        if (!this.caps.contains((Object)Caps.Srgb) && enableSrgb) {
            logger.warning("sRGB framebuffer is not supported by video hardware, but was requested.");
            return;
        }
        this.setFrameBuffer(null);
        if (enableSrgb) {
            if (!this.getBoolean(36282)) {
                logger.warning("Driver claims that default framebuffer is not sRGB capable. Enabling anyway.");
            }
            this.gl.glEnable(36281);
            logger.log(Level.FINER, "SRGB FrameBuffer enabled (Gamma Correction)");
        } else {
            this.gl.glDisable(36281);
        }
    }

    @Override
    public void setLinearizeSrgbImages(boolean linearize) {
        if (this.caps.contains((Object)Caps.Srgb)) {
            this.linearizeSrgbImages = linearize;
        }
    }
}

