/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.image;

import com.jme3.texture.image.ImageCodec;
import java.nio.ByteBuffer;

class ByteAlignedImageCodec
extends ImageCodec {
    private final int ap;
    private final int az;
    private final int rp;
    private final int rz;
    private final int gp;
    private final int gz;
    private final int bp;
    private final int bz;
    boolean be;

    public ByteAlignedImageCodec(int bpp, int flags, int az, int rz, int gz, int bz, int ap, int rp, int gp, int bp) {
        super(bpp, flags, (int)((1L << (az << 3)) - 1L), (int)((1L << (rz << 3)) - 1L), (int)((1L << (gz << 3)) - 1L), (int)((1L << (bz << 3)) - 1L));
        this.ap = ap;
        this.az = az;
        this.rp = rp;
        this.rz = rz;
        this.gp = gp;
        this.gz = gz;
        this.bp = bp;
        this.bz = bz;
    }

    private static void readPixelRaw(ByteBuffer buf, int idx, int bpp, byte[] result) {
        buf.position(idx);
        buf.get(result, 0, bpp);
    }

    private static void writePixelRaw(ByteBuffer buf, int idx, byte[] pixel, int bpp) {
        buf.position(idx);
        buf.put(pixel, 0, bpp);
    }

    private static int readComponent(byte[] encoded, int position, int size) {
        try {
            int component = 0;
            for (int i = size - 1; i >= 0; --i) {
                component = component << 8 | encoded[position + i] & 0xFF;
            }
            return component;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    private void writeComponent(int component, int position, int size, byte[] result) {
        for (int i = 0; i < size; ++i) {
            byte bt = (byte)(component >> i * 8 & 0xFF);
            result[position++] = bt;
        }
    }

    @Override
    public void readComponents(ByteBuffer buf, int x, int y, int width, int offset, int[] components, byte[] tmp) {
        ByteAlignedImageCodec.readPixelRaw(buf, (x + y * width + offset) * this.bpp + offset, this.bpp, tmp);
        components[0] = ByteAlignedImageCodec.readComponent(tmp, this.ap, this.az);
        components[1] = ByteAlignedImageCodec.readComponent(tmp, this.rp, this.rz);
        components[2] = ByteAlignedImageCodec.readComponent(tmp, this.gp, this.gz);
        components[3] = ByteAlignedImageCodec.readComponent(tmp, this.bp, this.bz);
    }

    @Override
    public void writeComponents(ByteBuffer buf, int x, int y, int width, int offset, int[] components, byte[] tmp) {
        this.writeComponent(components[0], this.ap, this.az, tmp);
        this.writeComponent(components[1], this.rp, this.rz, tmp);
        this.writeComponent(components[2], this.gp, this.gz, tmp);
        this.writeComponent(components[3], this.bp, this.bz, tmp);
        ByteAlignedImageCodec.writePixelRaw(buf, (x + y * width) * this.bpp + offset, tmp, this.bpp);
    }
}

