/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public class PFMLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(PFMLoader.class.getName());

    private String readString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i;
        while ((i = is.read()) != 10 && i != -1) {
            sb.append((char)i);
        }
        return sb.toString();
    }

    private void flipScanline(byte[] scanline) {
        for (int i = 0; i < scanline.length; i += 4) {
            byte tmp = scanline[i + 3];
            scanline[i + 3] = scanline[i + 0];
            scanline[i + 0] = tmp;
            tmp = scanline[i + 2];
            scanline[i + 2] = scanline[i + 1];
            scanline[i + 1] = tmp;
        }
    }

    private Image load(InputStream in, boolean needYFlip) throws IOException {
        Image.Format format = null;
        String fmtStr = this.readString(in);
        if (fmtStr.equals("PF")) {
            format = Image.Format.RGB32F;
        } else if (fmtStr.equals("Pf")) {
            format = Image.Format.Luminance32F;
        } else {
            throw new IOException("File is not PFM format");
        }
        String sizeStr = this.readString(in);
        int spaceIdx = sizeStr.indexOf(" ");
        if (spaceIdx <= 0 || spaceIdx >= sizeStr.length() - 1) {
            throw new IOException("Invalid size syntax in PFM file");
        }
        int width = Integer.parseInt(sizeStr.substring(0, spaceIdx));
        int height = Integer.parseInt(sizeStr.substring(spaceIdx + 1));
        if (width <= 0 || height <= 0) {
            throw new IOException("Invalid size specified in PFM file");
        }
        String scaleStr = this.readString(in);
        float scale = Float.parseFloat(scaleStr);
        ByteOrder order = scale < 0.0f ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        boolean needEndienFlip = order != ByteOrder.nativeOrder();
        System.gc();
        int bytesPerPixel = format.getBitsPerPixel() / 8;
        int scanLineBytes = bytesPerPixel * width;
        ByteBuffer imageData = BufferUtils.createByteBuffer(width * height * bytesPerPixel);
        byte[] scanline = new byte[width * bytesPerPixel];
        for (int y = height - 1; y >= 0; --y) {
            if (!needYFlip) {
                imageData.position(scanLineBytes * y);
            }
            int read = 0;
            int off = 0;
            do {
                read = in.read(scanline, off, scanline.length - off);
                off += read;
            } while (read > 0);
            if (needEndienFlip) {
                this.flipScanline(scanline);
            }
            imageData.put(scanline);
        }
        imageData.rewind();
        return new Image(format, width, height, imageData, null, ColorSpace.Linear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info) throws IOException {
        if (!(info.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        InputStream in = null;
        try {
            in = info.openStream();
            Image image = this.load(in, ((TextureKey)info.getKey()).isFlipY());
            return image;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

