/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.FlacTrack;
import de.jarnbjo.jmf.OggJmfStream;
import de.jarnbjo.jmf.OggTrack;
import de.jarnbjo.jmf.VorbisTrack;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.PhysicalOggStream;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class OggParser
implements Demultiplexer {
    private static final String DEMULTIPLEXER_NAME = "Ogg demultiplexer";
    private final ContentDescriptor[] supportedContentTypes = new ContentDescriptor[]{new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName((String)"application/ogg")), new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName((String)"application/x-ogg"))};
    private Track[] tracks;
    private PullDataSource source;
    private PullSourceStream stream;
    private PhysicalOggStream oggStream;

    public Time getDuration() {
        if (this.tracks == null) {
            return Time.TIME_UNKNOWN;
        }
        long max = 0L;
        for (int i = 0; i < this.tracks.length; ++i) {
            if (this.tracks[i].getDuration().getNanoseconds() <= max) continue;
            max = this.tracks[i].getDuration().getNanoseconds();
        }
        return new Time(max);
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedContentTypes;
    }

    public Track[] getTracks() throws BadHeaderException, IOException {
        if (this.tracks == null) {
            try {
                Collection coll = this.oggStream.getLogicalStreams();
                this.tracks = new Track[coll.size()];
                int i = 0;
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    LogicalOggStream los = (LogicalOggStream)iter.next();
                    System.out.println("type: " + los.getFormat());
                    this.tracks[i] = OggTrack.createInstance(los);
                    ++i;
                }
            }
            catch (OggFormatException e) {
                throw new BadHeaderException(e.getMessage());
            }
            catch (VorbisFormatException e) {
                throw new BadHeaderException(e.getMessage());
            }
        }
        return this.tracks;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public Time getMediaTime() {
        return Time.TIME_UNKNOWN;
    }

    public Time setPosition(Time time, int rounding) {
        try {
            if (this.tracks[0] instanceof VorbisTrack) {
                long sampleRate = ((VorbisTrack)this.tracks[0]).getSampleRate();
                this.oggStream.setTime(time.getNanoseconds() * sampleRate / 1000000000L);
            } else if (this.tracks[0] instanceof FlacTrack) {
                long sampleRate = ((FlacTrack)this.tracks[0]).getSampleRate();
                this.oggStream.setTime(time.getNanoseconds() * sampleRate / 1000000000L);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Time.TIME_UNKNOWN;
    }

    public void start() throws IOException {
        if (this.source != null) {
            this.source.start();
        }
    }

    public void stop() {
        if (this.source != null) {
            try {
                this.source.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void open() {
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void reset() {
        this.setPosition(new Time(0L), 0);
    }

    public String getName() {
        return DEMULTIPLEXER_NAME;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        try {
            if (!(source instanceof PullDataSource)) {
                throw new IncompatibleSourceException("DataSource not supported: " + source);
            }
            this.source = (PullDataSource)source;
            if (this.source.getStreams() == null || this.source.getStreams().length == 0) {
                throw new IOException("DataSource has no streams.");
            }
            if (this.source.getStreams().length > 1) {
                throw new IOException("This demultiplexer only supports datasources with one stream.");
            }
            this.stream = this.source.getStreams()[0];
            this.oggStream = new OggJmfStream(this.stream);
            if (!(this.stream instanceof Seekable)) {
                throw new IncompatibleSourceException("Stream is not seekable.");
            }
        }
        catch (IncompatibleSourceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }
}

