/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.anim;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.anim.AbstractTween;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.Tweens;

public class SpatialTweens {
    public static Tween move(Spatial target, Vector3f from, Vector3f to) {
        from = from != null ? from : target.getLocalTranslation();
        to = to != null ? to : target.getLocalTranslation();
        return new MoveSpatial(target, from, to);
    }

    public static Tween move(Spatial target, Vector3f from, Vector3f to, double length) {
        from = from != null ? from : target.getLocalTranslation();
        to = to != null ? to : target.getLocalTranslation();
        return new MoveSpatial(target, from, to, length);
    }

    public static Tween rotate(Spatial target, Quaternion from, Quaternion to, double length) {
        from = from != null ? from : target.getLocalRotation();
        to = to != null ? to : target.getLocalRotation();
        return new RotateSpatial(target, from, to, length);
    }

    public static Tween scale(Spatial target, float from, float to, double length) {
        return SpatialTweens.scale(target, new Vector3f(from, from, from), new Vector3f(to, to, to), length);
    }

    public static Tween scale(Spatial target, Vector3f from, Vector3f to, double length) {
        from = from != null ? from : target.getLocalScale();
        to = to != null ? to : target.getLocalScale();
        return new ScaleSpatial(target, from, to, length);
    }

    public static Tween detach(Spatial target) {
        return Tweens.callMethod(target, "removeFromParent", new Object[0]);
    }

    public static Tween attach(Spatial target, Spatial parent) {
        return Tweens.callMethod(parent, "attachChild", target);
    }

    private static class ScaleSpatial
    extends AbstractTween {
        private final Spatial target;
        private final Vector3f from;
        private final Vector3f to;
        private final Vector3f value;

        public ScaleSpatial(Spatial target, Vector3f from, Vector3f to, double length) {
            super(length);
            this.target = target;
            this.from = from.clone();
            this.to = to.clone();
            this.value = from.clone();
        }

        @Override
        protected void doInterpolate(double t) {
            this.value.interpolateLocal(this.from, this.to, (float)t);
            this.target.setLocalScale(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[target=" + this.target + ", from=" + this.from + ", to=" + this.to + ", length=" + this.getLength() + "]";
        }
    }

    private static class RotateSpatial
    extends AbstractTween {
        private final Spatial target;
        private final Quaternion from;
        private final Quaternion to;
        private final Quaternion value;

        public RotateSpatial(Spatial target, Quaternion from, Quaternion to, double length) {
            super(length);
            this.target = target;
            this.from = from.clone();
            this.to = to.clone();
            this.value = from.clone();
        }

        @Override
        protected void doInterpolate(double t) {
            this.value.slerp(this.from, this.to, (float)t);
            this.target.setLocalRotation(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[target=" + this.target + ", from=" + this.from + ", to=" + this.to + ", length=" + this.getLength() + "]";
        }
    }

    private static class MoveSpatial
    extends AbstractTween {
        private final Spatial target;
        private final Vector3f from;
        private final Vector3f to;
        private final Vector3f value;

        public MoveSpatial(Spatial target, Vector3f from, Vector3f to) {
            this(target, from, to, to.distance(from));
        }

        public MoveSpatial(Spatial target, Vector3f from, Vector3f to, double length) {
            super(length);
            this.target = target;
            this.from = from.clone();
            this.to = to.clone();
            this.value = new Vector3f(from);
        }

        @Override
        protected void doInterpolate(double t) {
            this.value.interpolateLocal(this.from, this.to, (float)t);
            this.target.setLocalTranslation(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[target=" + this.target + ", from=" + this.from + ", to=" + this.to + ", length=" + this.getLength() + "]";
        }
    }
}

