/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Vector2f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.event.DefaultMouseListener;

public class HoverMouseListener<T extends Spatial>
extends DefaultMouseListener {
    private Command<T> command;
    private long hoverStart;
    private double triggerTime;
    private Spatial lastSpatial;
    private Vector2f lastPosition = new Vector2f();
    private MouseMotionEvent lastEvent;
    private boolean hoverSent;

    public HoverMouseListener(Command<T> command) {
        this(3.0, command);
    }

    public HoverMouseListener(double triggerTime, Command<T> command) {
        this.triggerTime = triggerTime;
        this.command = command;
    }

    @Override
    public void mouseButtonEvent(MouseButtonEvent event, Spatial target, Spatial capture) {
        this.reset(event.getX(), event.getY(), target);
    }

    @Override
    public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
    }

    @Override
    public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
    }

    @Override
    public void mouseMoved(MouseMotionEvent event, Spatial target, Spatial capture) {
        double y;
        if (this.lastEvent == event) {
            return;
        }
        this.lastEvent = event;
        if (this.lastSpatial != target) {
            this.reset(event.getX(), event.getY(), target);
            return;
        }
        double x = (float)event.getX() - this.lastPosition.x;
        double dSq = x * x + (y = (double)((float)event.getY() - this.lastPosition.y)) * y;
        if (dSq > 4.0) {
            this.reset(event.getX(), event.getY(), target);
            return;
        }
        if (this.hoverSent) {
            return;
        }
        long time = System.currentTimeMillis();
        if ((double)(time - this.hoverStart) / 1000.0 > this.triggerTime) {
            this.command.execute(target);
            this.hoverSent = true;
        }
    }

    protected void reset(float x, float y, Spatial s) {
        this.hoverStart = System.currentTimeMillis();
        this.lastSpatial = s;
        this.lastPosition.set(x, y);
        if (this.hoverSent) {
            this.command.execute(null);
        }
        this.hoverSent = false;
    }
}

