/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.Light;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.io.IOException;

public class DirectionalLight
extends Light {
    protected Vector3f direction = new Vector3f(0.0f, -1.0f, 0.0f);

    @Override
    public void computeLastDistance(Spatial owner) {
        this.lastDistance = 0.0f;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f dir) {
        this.direction.set(dir);
        if (!this.direction.isUnitVector()) {
            this.direction.normalizeLocal();
        }
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        return true;
    }

    @Override
    public boolean intersectsFrustum(Camera camera, TempVars vars) {
        return true;
    }

    @Override
    public Light.Type getType() {
        return Light.Type.Directional;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.direction, "direction", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.direction = (Vector3f)ic.readSavable("direction", null);
    }
}

