/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public abstract class AbstractControl
implements Control {
    protected boolean enabled = true;
    protected Spatial spatial;

    @Override
    public void setSpatial(Spatial spatial) {
        if (this.spatial != null && spatial != null && spatial != this.spatial) {
            throw new IllegalStateException("This control has already been added to a Spatial");
        }
        this.spatial = spatial;
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected abstract void controlUpdate(float var1);

    protected abstract void controlRender(RenderManager var1, ViewPort var2);

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        try {
            AbstractControl c = (AbstractControl)this.clone();
            c.spatial = null;
            c.setSpatial(spatial);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Can't clone control for spatial", e);
        }
    }

    @Override
    public void update(float tpf) {
        if (!this.enabled) {
            return;
        }
        this.controlUpdate(tpf);
    }

    @Override
    public void render(RenderManager rm, ViewPort vp) {
        if (!this.enabled) {
            return;
        }
        this.controlRender(rm, vp);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
    }
}

