/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.renderer.Renderer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.NativeObject;
import java.util.ArrayList;

public class FrameBuffer
extends NativeObject {
    public static final int SLOT_UNDEF = -1;
    public static final int SLOT_DEPTH = -100;
    public static final int SLOT_DEPTH_STENCIL = -101;
    private int width = 0;
    private int height = 0;
    private int samples = 1;
    private ArrayList<RenderBuffer> colorBufs = new ArrayList();
    private RenderBuffer depthBuf = null;
    private int colorBufIndex = 0;
    private boolean srgb;

    public FrameBuffer(int width, int height, int samples) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("FrameBuffer must have valid size.");
        }
        this.width = width;
        this.height = height;
        this.samples = samples == 0 ? 1 : samples;
    }

    protected FrameBuffer(FrameBuffer src) {
        super(src.id);
    }

    public void setDepthBuffer(Image.Format format) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        if (!format.isDepthFormat()) {
            throw new IllegalArgumentException("Depth buffer format must be depth.");
        }
        this.depthBuf = new RenderBuffer();
        this.depthBuf.slot = format.isDepthStencilFormat() ? -101 : -100;
        this.depthBuf.format = format;
    }

    public void setColorBuffer(Image.Format format) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        if (format.isDepthFormat()) {
            throw new IllegalArgumentException("Color buffer format must be color/luminance.");
        }
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = 0;
        colorBuf.format = format;
        this.colorBufs.clear();
        this.colorBufs.add(colorBuf);
    }

    private void checkSetTexture(Texture tex, boolean depth) {
        Image img = tex.getImage();
        if (img == null) {
            throw new IllegalArgumentException("Texture not initialized with RTT.");
        }
        if (depth && !img.getFormat().isDepthFormat()) {
            throw new IllegalArgumentException("Texture image format must be depth.");
        }
        if (!depth && img.getFormat().isDepthFormat()) {
            throw new IllegalArgumentException("Texture image format must be color/luminance.");
        }
        if (this.width != img.getWidth() || this.height != img.getHeight()) {
            throw new IllegalArgumentException("Texture image resolution must match FB resolution");
        }
        if (this.samples != tex.getImage().getMultiSamples()) {
            throw new IllegalStateException("Texture samples must match framebuffer samples");
        }
    }

    public void setMultiTarget(boolean enabled) {
        this.colorBufIndex = enabled ? -1 : 0;
    }

    public boolean isMultiTarget() {
        return this.colorBufIndex == -1;
    }

    public void setTargetIndex(int index) {
        if (index < 0 || index >= 16) {
            throw new IllegalArgumentException("Target index must be between 0 and 16");
        }
        if (this.colorBufs.size() < index) {
            throw new IllegalArgumentException("The target at " + index + " is not set!");
        }
        this.colorBufIndex = index;
        this.setUpdateNeeded();
    }

    public int getTargetIndex() {
        return this.colorBufIndex;
    }

    public void setColorTexture(Texture2D tex) {
        this.clearColorTargets();
        this.addColorTexture(tex);
    }

    public void setColorTexture(TextureCubeMap tex, TextureCubeMap.Face face) {
        this.clearColorTargets();
        this.addColorTexture(tex, face);
    }

    public void clearColorTargets() {
        this.colorBufs.clear();
    }

    public void addColorTexture(Texture2D tex) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, false);
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = this.colorBufs.size();
        colorBuf.tex = tex;
        colorBuf.format = img.getFormat();
        this.colorBufs.add(colorBuf);
    }

    public void addColorTexture(TextureCubeMap tex, TextureCubeMap.Face face) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, false);
        RenderBuffer colorBuf = new RenderBuffer();
        colorBuf.slot = this.colorBufs.size();
        colorBuf.tex = tex;
        colorBuf.format = img.getFormat();
        colorBuf.face = face.ordinal();
        this.colorBufs.add(colorBuf);
    }

    public void setDepthTexture(Texture2D tex) {
        if (this.id != -1) {
            throw new UnsupportedOperationException("FrameBuffer already initialized.");
        }
        Image img = tex.getImage();
        this.checkSetTexture(tex, true);
        this.depthBuf = new RenderBuffer();
        this.depthBuf.slot = img.getFormat().isDepthStencilFormat() ? -101 : -100;
        this.depthBuf.tex = tex;
        this.depthBuf.format = img.getFormat();
    }

    public int getNumColorBuffers() {
        return this.colorBufs.size();
    }

    public RenderBuffer getColorBuffer(int index) {
        return this.colorBufs.get(index);
    }

    public RenderBuffer getColorBuffer() {
        if (this.colorBufs.isEmpty()) {
            return null;
        }
        return this.colorBufs.get(0);
    }

    public RenderBuffer getDepthBuffer() {
        return this.depthBuf;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getSamples() {
        return this.samples;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String mrtStr = this.colorBufIndex >= 0 ? "" + this.colorBufIndex : "mrt";
        sb.append("FrameBuffer[format=").append(this.width).append("x").append(this.height).append("x").append(this.samples).append(", drawBuf=").append(mrtStr).append("]\n");
        if (this.depthBuf != null) {
            sb.append("Depth => ").append(this.depthBuf).append("\n");
        }
        for (RenderBuffer colorBuf : this.colorBufs) {
            sb.append("Color(").append(colorBuf.slot).append(") => ").append(colorBuf).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void resetObject() {
        this.id = -1;
        for (int i = 0; i < this.colorBufs.size(); ++i) {
            this.colorBufs.get(i).resetObject();
        }
        if (this.depthBuf != null) {
            this.depthBuf.resetObject();
        }
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteFrameBuffer(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new FrameBuffer(this);
    }

    @Override
    public long getUniqueId() {
        return 0x300000000L | (long)this.id;
    }

    public void setSrgb(boolean srgb) {
        this.srgb = srgb;
    }

    public boolean isSrgb() {
        return this.srgb;
    }

    public class RenderBuffer {
        Texture tex;
        Image.Format format;
        int id = -1;
        int slot = -1;
        int face = -1;

        public Image.Format getFormat() {
            return this.format;
        }

        public Texture getTexture() {
            return this.tex;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getFace() {
            return this.face;
        }

        public void resetObject() {
            this.id = -1;
        }

        public RenderBuffer createDestructableClone() {
            if (this.tex != null) {
                return null;
            }
            RenderBuffer destructClone = new RenderBuffer();
            destructClone.id = this.id;
            return destructClone;
        }

        public String toString() {
            if (this.tex != null) {
                return "TextureTarget[format=" + (Object)((Object)this.format) + "]";
            }
            return "BufferTarget[format=" + (Object)((Object)this.format) + "]";
        }
    }
}

