/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Objects;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.HashMap;
import java.util.Map;

public abstract class Action
implements VersionedObject<Action>,
Command<Button> {
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_NAME = "name";
    public static final String KEY_ICON = "icon";
    public static final String KEY_LARGE_ICON = "largeIcon";
    public static final String KEY_SHORT_DESCRIPTION = "shortDescription";
    public static final String KEY_SELECTED = "selected";
    private long version;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean enabled = true;

    public Action() {
    }

    public Action(String name) {
        this.setName(name);
    }

    public Action(String name, GuiComponent icon) {
        this.setName(name);
        this.setIcon(icon);
    }

    public Action(String name, GuiComponent icon, boolean enabled) {
        this.setName(name);
        this.setIcon(icon);
        this.setEnabled(enabled);
    }

    public abstract void execute(Button var1);

    public void setEnabled(boolean b) {
        this.putValue(KEY_ENABLED, b);
    }

    public boolean isEnabled() {
        return this.getValue(KEY_ENABLED, true);
    }

    public void setSelected(boolean b) {
        this.putValue(KEY_SELECTED, b);
    }

    public boolean isSelected() {
        return this.getValue(KEY_SELECTED, true);
    }

    public void setName(String name) {
        this.putValue(KEY_NAME, name);
    }

    public String getName() {
        return (String)this.getValue(KEY_NAME);
    }

    public void setIcon(GuiComponent component) {
        this.putValue(KEY_ICON, component);
    }

    public GuiComponent getIcon() {
        return (GuiComponent)this.getValue(KEY_ICON);
    }

    public void setLargeIcon(GuiComponent component) {
        this.putValue(KEY_LARGE_ICON, component);
    }

    public GuiComponent getLargeIcon() {
        return this.getValue(KEY_LARGE_ICON, this.getIcon());
    }

    public void putValue(String key, Object value) {
        Object existing = this.properties.put(key, value);
        if (!Objects.equal((Object)existing, (Object)value)) {
            this.incrementVersion();
        }
    }

    public <T> T getValue(String key) {
        return (T)this.properties.get(key);
    }

    public <T> T getValue(String key, T defaultValue) {
        Object result = this.properties.get(key);
        return (T)(result == null ? defaultValue : result);
    }

    protected void incrementVersion() {
        ++this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public Action getObject() {
        return this;
    }

    public VersionedReference<Action> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected void appendFields(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append("properties=");
        sb.append(this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendFields(sb);
        return this.getClass().getName() + "[" + sb + "]";
    }
}

