/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel;

import com.jme3.network.kernel.EndpointEvent;
import com.jme3.network.kernel.Envelope;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.kernel.KernelException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractKernel
implements Kernel {
    static Logger log = Logger.getLogger(AbstractKernel.class.getName());
    private AtomicLong nextId = new AtomicLong(1L);
    private ConcurrentLinkedQueue<EndpointEvent> endpointEvents = new ConcurrentLinkedQueue();
    private LinkedBlockingQueue<Envelope> envelopes = new LinkedBlockingQueue();

    protected AbstractKernel() {
    }

    protected void reportError(Exception e) {
        log.log(Level.SEVERE, "Unhanddled kernel error", e);
    }

    protected long nextEndpointId() {
        return this.nextId.getAndIncrement();
    }

    @Override
    public boolean hasEnvelopes() {
        return !this.envelopes.isEmpty();
    }

    @Override
    public Envelope read() throws InterruptedException {
        return this.envelopes.take();
    }

    @Override
    public EndpointEvent nextEvent() {
        return this.endpointEvents.poll();
    }

    protected void addEvent(EndpointEvent e) {
        this.endpointEvents.add(e);
    }

    protected void addEnvelope(Envelope env) {
        if (!this.envelopes.offer(env)) {
            throw new KernelException("Critical error, could not enqueue envelope.");
        }
    }
}

