/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public final class Natives {
    private static final Logger logger = Logger.getLogger(Natives.class.getName());
    private static final byte[] buf = new byte[102400];
    private static File extractionDirOverride = null;
    private static File extractionDir = null;

    public static void setExtractionDir(String name) {
        extractionDirOverride = new File(name).getAbsoluteFile();
    }

    public static File getExtractionDir() {
        if (extractionDirOverride != null) {
            return extractionDirOverride;
        }
        if (extractionDir == null) {
            File workingFolder = new File("").getAbsoluteFile();
            if (!workingFolder.canWrite()) {
                Natives.setStorageExtractionDir();
            } else {
                try {
                    File file = new File(workingFolder.getAbsolutePath() + File.separator + ".jmetestwrite");
                    file.createNewFile();
                    file.delete();
                    extractionDir = workingFolder;
                }
                catch (Exception e) {
                    Natives.setStorageExtractionDir();
                }
            }
        }
        return extractionDir;
    }

    private static void setStorageExtractionDir() {
        logger.log(Level.WARNING, "Working directory is not writable. Using home directory instead.");
        extractionDir = new File(JmeSystem.getStorageFolder(), "natives_" + Integer.toHexString(Natives.computeNativesHash()));
        if (!extractionDir.exists()) {
            extractionDir.mkdir();
        }
    }

    private static int computeNativesHash() {
        URLConnection conn = null;
        try {
            int hash;
            String classpath = System.getProperty("java.class.path");
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/jme3/system/Natives.class");
            StringBuilder sb = new StringBuilder(url.toString());
            if (sb.indexOf("jar:") == 0) {
                sb.delete(0, 4);
                sb.delete(sb.indexOf("!"), sb.length());
                sb.delete(sb.lastIndexOf("/") + 1, sb.length());
            }
            try {
                url = new URL(sb.toString());
            }
            catch (MalformedURLException ex) {
                throw new UnsupportedOperationException(ex);
            }
            conn = url.openConnection();
            int n = hash = classpath.hashCode() ^ (int)conn.getLastModified();
            return n;
        }
        catch (IOException ex) {
            throw new UnsupportedOperationException(ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.getOutputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void extractNativeLib(String sysName, String name) throws IOException {
        Natives.extractNativeLib(sysName, name, false, true);
    }

    public static void extractNativeLib(String sysName, String name, boolean load) throws IOException {
        Natives.extractNativeLib(sysName, name, load, true);
    }

    public static void extractNativeLib(String sysName, String name, boolean load, boolean warning) throws IOException {
        URL url;
        String path;
        String fullname;
        if (!name.contains(".")) {
            fullname = System.mapLibraryName(name);
            path = "native/" + sysName + "/" + fullname;
            if (sysName.equals("macosx")) {
                path = path.replaceAll("dylib", "jnilib");
            }
        } else {
            fullname = name;
            path = "native/" + sysName + "/" + fullname;
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource(path)) == null) {
            path = fullname;
            if (sysName.equals("macosx") && !name.contains(".")) {
                path = path.replaceAll("dylib", "jnilib");
            }
            url = Thread.currentThread().getContextClassLoader().getResource(path);
        }
        if (url == null) {
            block22: {
                if (!warning) {
                    logger.log(Level.WARNING, "Cannot locate native library in classpath: {0}/{1}", new String[]{sysName, fullname});
                }
                try {
                    System.loadLibrary(name);
                }
                catch (UnsatisfiedLinkError e) {
                    if (warning) break block22;
                    logger.log(Level.WARNING, "Cannot load native library: {0}/{1}", new String[]{sysName, fullname});
                }
            }
            return;
        }
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        File targetFile = new File(Natives.getExtractionDir(), fullname);
        FileOutputStream out = null;
        try {
            int len;
            long sourceLastModified;
            long targetLastModified;
            if (targetFile.exists() && (targetLastModified = targetFile.lastModified()) + 1000L > (sourceLastModified = conn.getLastModified())) {
                logger.log(Level.FINE, "Not copying library {0}. Latest already extracted.", fullname);
                return;
            }
            out = new FileOutputStream(targetFile);
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            ((OutputStream)out).close();
            out = null;
            targetFile.setLastModified(conn.getLastModified());
        }
        catch (FileNotFoundException ex) {
            if (ex.getMessage().contains("used by another process")) {
                return;
            }
            throw ex;
        }
        finally {
            if (load) {
                System.load(targetFile.getAbsolutePath());
            }
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        logger.log(Level.FINE, "Copied {0} to {1}", new Object[]{fullname, targetFile});
    }

    protected static boolean isUsingNativeBullet() {
        try {
            Class<?> clazz = Class.forName("com.jme3.bullet.util.NativeMeshUtil");
            return clazz != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void extractNativeLibs(Platform platform, AppSettings settings) throws IOException {
        throw new UnsupportedEncodingException("Now, why would you EVER want to do that?");
    }
}

