/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.Track;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.asset.TextureKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.fbx.AnimationList;
import com.jme3.scene.plugins.fbx.ContentTextureKey;
import com.jme3.scene.plugins.fbx.ContentTextureLocator;
import com.jme3.scene.plugins.fbx.SceneKey;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.file.FbxFile;
import com.jme3.scene.plugins.fbx.file.FbxReader;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SceneLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(SceneLoader.class.getName());
    private AssetManager assetManager;
    private AnimationList animList;
    private String sceneName;
    private String sceneFilename;
    private String sceneFolderName;
    private float unitSize;
    private float animFrameRate;
    private final double secondsPerUnit = 2.165150866196751E-11;
    private Map<Long, MeshData> meshDataMap = new HashMap<Long, MeshData>();
    private Map<Long, MaterialData> matDataMap = new HashMap<Long, MaterialData>();
    private Map<Long, TextureData> texDataMap = new HashMap<Long, TextureData>();
    private Map<Long, ImageData> imgDataMap = new HashMap<Long, ImageData>();
    private Map<Long, ModelData> modelDataMap = new HashMap<Long, ModelData>();
    private Map<Long, BindPoseData> poseDataMap = new HashMap<Long, BindPoseData>();
    private Map<Long, SkinData> skinMap = new HashMap<Long, SkinData>();
    private Map<Long, ClusterData> clusterMap = new HashMap<Long, ClusterData>();
    private Map<Long, AnimCurveData> acurveMap = new HashMap<Long, AnimCurveData>();
    private Map<Long, AnimNode> anodeMap = new HashMap<Long, AnimNode>();
    private Map<Long, AnimLayer> alayerMap = new HashMap<Long, AnimLayer>();
    private Map<Long, List<Long>> refMap = new HashMap<Long, List<Long>>();
    private Map<Long, List<PropertyLink>> propMap = new HashMap<Long, List<PropertyLink>>();
    private Map<Long, Node> modelMap = new HashMap<Long, Node>();
    private Map<Long, Limb> limbMap = new HashMap<Long, Limb>();
    private Map<Long, BindPose> bindMap = new HashMap<Long, BindPose>();
    private Map<Long, Geometry> geomMap = new HashMap<Long, Geometry>();
    private Map<Long, Material> matMap = new HashMap<Long, Material>();
    private Map<Long, Texture> texMap = new HashMap<Long, Texture>();
    private Map<Long, Image> imgMap = new HashMap<Long, Image>();
    private Skeleton skeleton;
    private AnimControl animControl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo assetInfo) throws IOException {
        this.assetManager = assetInfo.getManager();
        AssetKey assetKey = assetInfo.getKey();
        if (assetKey instanceof SceneKey) {
            this.animList = ((SceneKey)assetKey).getAnimations();
        } else if (!(assetKey instanceof ModelKey)) {
            throw new AssetLoadException("Invalid asset key");
        }
        InputStream stream = assetInfo.openStream();
        Node sceneNode = null;
        try {
            this.sceneFilename = assetKey.getName();
            this.sceneFolderName = assetKey.getFolder();
            String ext = assetKey.getExtension();
            this.sceneName = this.sceneFilename.substring(0, this.sceneFilename.length() - ext.length() - 1);
            if (this.sceneFolderName != null && this.sceneFolderName.length() > 0) {
                this.sceneName = this.sceneName.substring(this.sceneFolderName.length());
            }
            this.reset();
            this.loadScene(stream);
            sceneNode = this.linkScene();
        }
        finally {
            this.releaseObjects();
            if (stream != null) {
                stream.close();
            }
        }
        return sceneNode;
    }

    private void reset() {
        this.unitSize = 1.0f;
        this.animFrameRate = 30.0f;
    }

    private void loadScene(InputStream stream) throws IOException {
        logger.log(Level.FINE, "Loading scene {0}", this.sceneFilename);
        long startTime = System.currentTimeMillis();
        FbxFile scene = FbxReader.readFBX(stream);
        for (FbxElement e : scene.rootElements) {
            if (e.id.equals("GlobalSettings")) {
                this.loadGlobalSettings(e);
                continue;
            }
            if (e.id.equals("Objects")) {
                this.loadObjects(e);
                continue;
            }
            if (!e.id.equals("Connections")) continue;
            this.loadConnections(e);
        }
        long estimatedTime = System.currentTimeMillis() - startTime;
        logger.log(Level.FINE, "Loading done in {0} ms", estimatedTime);
    }

    private void loadGlobalSettings(FbxElement element) {
        for (FbxElement e : element.children) {
            if (!e.id.equals("Properties70")) continue;
            for (FbxElement e2 : e.children) {
                float framerate;
                if (!e2.id.equals("P")) continue;
                String propName = (String)e2.properties.get(0);
                if (propName.equals("UnitScaleFactor")) {
                    this.unitSize = ((Double)e2.properties.get(4)).floatValue();
                    continue;
                }
                if (!propName.equals("CustomFrameRate") || (framerate = ((Double)e2.properties.get(4)).floatValue()) == -1.0f) continue;
                this.animFrameRate = framerate;
            }
        }
    }

    private void loadObjects(FbxElement element) {
        for (FbxElement e : element.children) {
            if (e.id.equals("Geometry")) {
                this.loadGeometry(e);
                continue;
            }
            if (e.id.equals("Material")) {
                this.loadMaterial(e);
                continue;
            }
            if (e.id.equals("Model")) {
                this.loadModel(e);
                continue;
            }
            if (e.id.equals("Pose")) {
                this.loadPose(e);
                continue;
            }
            if (e.id.equals("Texture")) {
                this.loadTexture(e);
                continue;
            }
            if (e.id.equals("Video")) {
                this.loadImage(e);
                continue;
            }
            if (e.id.equals("Deformer")) {
                this.loadDeformer(e);
                continue;
            }
            if (e.id.equals("AnimationLayer")) {
                this.loadAnimLayer(e);
                continue;
            }
            if (e.id.equals("AnimationCurve")) {
                this.loadAnimCurve(e);
                continue;
            }
            if (!e.id.equals("AnimationCurveNode")) continue;
            this.loadAnimNode(e);
        }
    }

    private void loadGeometry(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String type = (String)element.properties.get(2);
        if (type.equals("Mesh")) {
            MeshData data = new MeshData();
            for (FbxElement e : element.children) {
                if (e.id.equals("Vertices")) {
                    data.vertices = (double[])e.properties.get(0);
                    continue;
                }
                if (e.id.equals("PolygonVertexIndex")) {
                    data.indices = (int[])e.properties.get(0);
                    continue;
                }
                if (e.id.equals("LayerElementNormal")) {
                    for (FbxElement e2 : e.children) {
                        if (e2.id.equals("MappingInformationType")) {
                            data.normalsMapping = (String)e2.properties.get(0);
                            if (data.normalsMapping.equals("ByVertice") || data.normalsMapping.equals("ByPolygonVertex")) continue;
                            throw new AssetLoadException("Not supported LayerElementNormal.MappingInformationType = " + data.normalsMapping);
                        }
                        if (e2.id.equals("ReferenceInformationType")) {
                            data.normalsReference = (String)e2.properties.get(0);
                            if (data.normalsReference.equals("Direct")) continue;
                            throw new AssetLoadException("Not supported LayerElementNormal.ReferenceInformationType = " + data.normalsReference);
                        }
                        if (!e2.id.equals("Normals")) continue;
                        data.normals = (double[])e2.properties.get(0);
                    }
                    continue;
                }
                if (e.id.equals("LayerElementTangent")) {
                    for (FbxElement e2 : e.children) {
                        if (e2.id.equals("MappingInformationType")) {
                            data.tangentsMapping = (String)e2.properties.get(0);
                            if (data.tangentsMapping.equals("ByVertice") || data.tangentsMapping.equals("ByPolygonVertex")) continue;
                            throw new AssetLoadException("Not supported LayerElementTangent.MappingInformationType = " + data.tangentsMapping);
                        }
                        if (e2.id.equals("ReferenceInformationType")) {
                            data.tangentsReference = (String)e2.properties.get(0);
                            if (data.tangentsReference.equals("Direct")) continue;
                            throw new AssetLoadException("Not supported LayerElementTangent.ReferenceInformationType = " + data.tangentsReference);
                        }
                        if (!e2.id.equals("Tangents")) continue;
                        data.tangents = (double[])e2.properties.get(0);
                    }
                    continue;
                }
                if (e.id.equals("LayerElementBinormal")) {
                    for (FbxElement e2 : e.children) {
                        if (e2.id.equals("MappingInformationType")) {
                            data.binormalsMapping = (String)e2.properties.get(0);
                            if (data.binormalsMapping.equals("ByVertice") || data.binormalsMapping.equals("ByPolygonVertex")) continue;
                            throw new AssetLoadException("Not supported LayerElementBinormal.MappingInformationType = " + data.binormalsMapping);
                        }
                        if (e2.id.equals("ReferenceInformationType")) {
                            data.binormalsReference = (String)e2.properties.get(0);
                            if (data.binormalsReference.equals("Direct")) continue;
                            throw new AssetLoadException("Not supported LayerElementBinormal.ReferenceInformationType = " + data.binormalsReference);
                        }
                        if (!e2.id.equals("Tangents")) continue;
                        data.binormals = (double[])e2.properties.get(0);
                    }
                    continue;
                }
                if (e.id.equals("LayerElementUV")) {
                    for (FbxElement e2 : e.children) {
                        if (e2.id.equals("MappingInformationType")) {
                            data.uvMapping = (String)e2.properties.get(0);
                            if (data.uvMapping.equals("ByPolygonVertex")) continue;
                            throw new AssetLoadException("Not supported LayerElementUV.MappingInformationType = " + data.uvMapping);
                        }
                        if (e2.id.equals("ReferenceInformationType")) {
                            data.uvReference = (String)e2.properties.get(0);
                            if (data.uvReference.equals("IndexToDirect")) continue;
                            throw new AssetLoadException("Not supported LayerElementUV.ReferenceInformationType = " + data.uvReference);
                        }
                        if (e2.id.equals("UV")) {
                            data.uv = (double[])e2.properties.get(0);
                            continue;
                        }
                        if (!e2.id.equals("UVIndex")) continue;
                        data.uvIndex = (int[])e2.properties.get(0);
                    }
                    continue;
                }
                if (!e.id.equals("LayerElementMaterial")) continue;
                for (FbxElement e2 : e.children) {
                    if (e2.id.equals("MappingInformationType")) {
                        data.materialsMapping = (String)e2.properties.get(0);
                        if (data.materialsMapping.equals("AllSame")) continue;
                        throw new AssetLoadException("Not supported LayerElementMaterial.MappingInformationType = " + data.materialsMapping);
                    }
                    if (e2.id.equals("ReferenceInformationType")) {
                        data.materialsReference = (String)e2.properties.get(0);
                        if (data.materialsReference.equals("IndexToDirect")) continue;
                        throw new AssetLoadException("Not supported LayerElementMaterial.ReferenceInformationType = " + data.materialsReference);
                    }
                    if (!e2.id.equals("Materials")) continue;
                    data.materials = (int[])e2.properties.get(0);
                }
            }
            this.meshDataMap.put(id, data);
        }
    }

    private void loadMaterial(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        if (type.equals("")) {
            MaterialData data = new MaterialData();
            data.name = path.substring(0, path.indexOf(0));
            for (FbxElement e : element.children) {
                if (e.id.equals("ShadingModel")) {
                    data.shadingModel = (String)e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("Properties70")) continue;
                for (FbxElement e2 : e.children) {
                    double z;
                    double y;
                    double x;
                    if (!e2.id.equals("P")) continue;
                    String propName = (String)e2.properties.get(0);
                    if (propName.equals("AmbientColor")) {
                        x = (Double)e2.properties.get(4);
                        y = (Double)e2.properties.get(5);
                        z = (Double)e2.properties.get(6);
                        data.ambientColor.set((float)x, (float)y, (float)z);
                        continue;
                    }
                    if (propName.equals("AmbientFactor")) {
                        x = (Double)e2.properties.get(4);
                        data.ambientFactor = (float)x;
                        continue;
                    }
                    if (propName.equals("DiffuseColor")) {
                        x = (Double)e2.properties.get(4);
                        y = (Double)e2.properties.get(5);
                        z = (Double)e2.properties.get(6);
                        data.diffuseColor.set((float)x, (float)y, (float)z);
                        continue;
                    }
                    if (propName.equals("DiffuseFactor")) {
                        x = (Double)e2.properties.get(4);
                        data.diffuseFactor = (float)x;
                        continue;
                    }
                    if (propName.equals("SpecularColor")) {
                        x = (Double)e2.properties.get(4);
                        y = (Double)e2.properties.get(5);
                        z = (Double)e2.properties.get(6);
                        data.specularColor.set((float)x, (float)y, (float)z);
                        continue;
                    }
                    if (!propName.equals("Shininess") && !propName.equals("ShininessExponent")) continue;
                    x = (Double)e2.properties.get(4);
                    data.shininessExponent = (float)x;
                }
            }
            this.matDataMap.put(id, data);
        }
    }

    private void loadModel(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        ModelData data = new ModelData();
        data.name = path.substring(0, path.indexOf(0));
        data.type = type;
        for (FbxElement e : element.children) {
            if (!e.id.equals("Properties70")) continue;
            for (FbxElement e2 : e.children) {
                double z;
                double y;
                double x;
                if (!e2.id.equals("P")) continue;
                String propName = (String)e2.properties.get(0);
                if (propName.equals("Lcl Translation")) {
                    x = (Double)e2.properties.get(4);
                    y = (Double)e2.properties.get(5);
                    z = (Double)e2.properties.get(6);
                    data.localTranslation.set((float)x, (float)y, (float)z).divideLocal(this.unitSize);
                    continue;
                }
                if (propName.equals("Lcl Rotation")) {
                    x = (Double)e2.properties.get(4);
                    y = (Double)e2.properties.get(5);
                    z = (Double)e2.properties.get(6);
                    data.localRotation.fromAngles((float)x * ((float)Math.PI / 180), (float)y * ((float)Math.PI / 180), (float)z * ((float)Math.PI / 180));
                    continue;
                }
                if (propName.equals("Lcl Scaling")) {
                    x = (Double)e2.properties.get(4);
                    y = (Double)e2.properties.get(5);
                    z = (Double)e2.properties.get(6);
                    data.localScale.set((float)x, (float)y, (float)z).multLocal(this.unitSize);
                    continue;
                }
                if (!propName.equals("PreRotation")) continue;
                x = (Double)e2.properties.get(4);
                y = (Double)e2.properties.get(5);
                z = (Double)e2.properties.get(6);
                data.preRotation = this.quatFromBoneAngles((float)x * ((float)Math.PI / 180), (float)y * ((float)Math.PI / 180), (float)z * ((float)Math.PI / 180));
            }
        }
        this.modelDataMap.put(id, data);
    }

    private void loadPose(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        if (type.equals("BindPose")) {
            BindPoseData data = new BindPoseData();
            data.name = path.substring(0, path.indexOf(0));
            for (FbxElement e : element.children) {
                if (!e.id.equals("PoseNode")) continue;
                NodeTransformData item = new NodeTransformData();
                for (FbxElement e2 : e.children) {
                    if (e2.id.equals("Node")) {
                        item.nodeId = (Long)e2.properties.get(0);
                        continue;
                    }
                    if (!e2.id.equals("Matrix")) continue;
                    item.transform = (double[])e2.properties.get(0);
                }
                data.list.add(item);
            }
            this.poseDataMap.put(id, data);
        }
    }

    private void loadTexture(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        if (type.equals("")) {
            TextureData data = new TextureData();
            data.name = path.substring(0, path.indexOf(0));
            for (FbxElement e : element.children) {
                if (e.id.equals("Type")) {
                    data.bindType = (String)e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("FileName")) continue;
                data.filename = (String)e.properties.get(0);
            }
            this.texDataMap.put(id, data);
        }
    }

    private void loadImage(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        if (type.equals("Clip")) {
            ImageData data = new ImageData();
            data.name = path.substring(0, path.indexOf(0));
            for (FbxElement e : element.children) {
                if (e.id.equals("Type")) {
                    data.type = (String)e.properties.get(0);
                    continue;
                }
                if (e.id.equals("FileName")) {
                    data.filename = (String)e.properties.get(0);
                    continue;
                }
                if (e.id.equals("RelativeFilename")) {
                    data.relativeFilename = (String)e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("Content") || e.properties.size() <= 0) continue;
                data.content = (byte[])e.properties.get(0);
            }
            this.imgDataMap.put(id, data);
        }
    }

    private void loadDeformer(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String type = (String)element.properties.get(2);
        if (type.equals("Skin")) {
            SkinData skinData = new SkinData();
            for (FbxElement e : element.children) {
                if (!e.id.equals("SkinningType")) continue;
                skinData.type = (String)e.properties.get(0);
            }
            this.skinMap.put(id, skinData);
        } else if (type.equals("Cluster")) {
            ClusterData clusterData = new ClusterData();
            for (FbxElement e : element.children) {
                if (e.id.equals("Indexes")) {
                    clusterData.indexes = (int[])e.properties.get(0);
                    continue;
                }
                if (e.id.equals("Weights")) {
                    clusterData.weights = (double[])e.properties.get(0);
                    continue;
                }
                if (e.id.equals("Transform")) {
                    clusterData.transform = (double[])e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("TransformLink")) continue;
                clusterData.transformLink = (double[])e.properties.get(0);
            }
            this.clusterMap.put(id, clusterData);
        }
    }

    private void loadAnimLayer(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        if (type.equals("")) {
            AnimLayer layer = new AnimLayer();
            layer.name = path.substring(0, path.indexOf(0));
            this.alayerMap.put(id, layer);
        }
    }

    private void loadAnimCurve(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String type = (String)element.properties.get(2);
        if (type.equals("")) {
            AnimCurveData data = new AnimCurveData();
            for (FbxElement e : element.children) {
                if (e.id.equals("KeyTime")) {
                    data.keyTimes = (long[])e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("KeyValueFloat")) continue;
                data.keyValues = (float[])e.properties.get(0);
            }
            this.acurveMap.put(id, data);
        }
    }

    private void loadAnimNode(FbxElement element) {
        long id = (Long)element.properties.get(0);
        String path = (String)element.properties.get(1);
        String type = (String)element.properties.get(2);
        if (type.equals("")) {
            Double x = null;
            Double y = null;
            Double z = null;
            for (FbxElement e : element.children) {
                if (!e.id.equals("Properties70")) continue;
                for (FbxElement e2 : e.children) {
                    if (!e2.id.equals("P")) continue;
                    String propName = (String)e2.properties.get(0);
                    if (propName.equals("d|X")) {
                        x = (Double)e2.properties.get(4);
                        continue;
                    }
                    if (propName.equals("d|Y")) {
                        y = (Double)e2.properties.get(4);
                        continue;
                    }
                    if (!propName.equals("d|Z")) continue;
                    z = (Double)e2.properties.get(4);
                }
            }
            if (x != null && y != null && z != null) {
                AnimNode node = new AnimNode();
                node.value = new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
                node.name = path.substring(0, path.indexOf(0));
                this.anodeMap.put(id, node);
            }
        }
    }

    private void loadConnections(FbxElement element) {
        for (FbxElement e : element.children) {
            long refId;
            long objId;
            if (!e.id.equals("C")) continue;
            String type = (String)e.properties.get(0);
            if (type.equals("OO")) {
                objId = (Long)e.properties.get(1);
                refId = (Long)e.properties.get(2);
                List<Long> links = this.refMap.get(objId);
                if (links == null) {
                    links = new ArrayList<Long>();
                    this.refMap.put(objId, links);
                }
                links.add(refId);
                continue;
            }
            if (!type.equals("OP")) continue;
            objId = (Long)e.properties.get(1);
            refId = (Long)e.properties.get(2);
            String propName = (String)e.properties.get(3);
            List<PropertyLink> props = this.propMap.get(objId);
            if (props == null) {
                props = new ArrayList<PropertyLink>();
                this.propMap.put(objId, props);
            }
            props.add(new PropertyLink(refId, propName));
        }
    }

    private Geometry createGeomerty(MeshData data) {
        float z;
        float y;
        int srcCount;
        int i;
        int n;
        int i2;
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Triangles);
        boolean isQuads = false;
        if (data.indices != null) {
            int index;
            data.iCount = data.indices.length;
            data.srcVertexCount = data.vertices.length / 3;
            boolean allTriangles = true;
            boolean allQads = true;
            for (i2 = 0; i2 < data.indices.length; ++i2) {
                if (i2 % 3 == 2) {
                    if (data.indices[i2] >= 0) {
                        allTriangles = false;
                    }
                } else if (data.indices[i2] < 0) {
                    allTriangles = false;
                }
                if (i2 % 4 == 3) {
                    if (data.indices[i2] < 0) continue;
                    allQads = false;
                    continue;
                }
                if (data.indices[i2] >= 0) continue;
                allQads = false;
            }
            if (allTriangles) {
                isQuads = false;
                data.vCount = data.iCount;
            } else if (allQads) {
                isQuads = true;
                data.vCount = 6 * (data.iCount / 4);
            } else {
                throw new AssetLoadException("Unsupported PolygonVertexIndex stride");
            }
            data.vertexMap = new int[data.vCount];
            data.indexMap = new int[data.vCount];
            n = 0;
            for (i = 0; i < data.iCount; ++i) {
                index = data.indices[i];
                if (index >= 0) continue;
                int lastIndex = -(index + 1);
                if (isQuads) {
                    data.vertexMap[n + 0] = data.indices[i - 3];
                    data.vertexMap[n + 1] = data.indices[i - 2];
                    data.vertexMap[n + 2] = data.indices[i - 1];
                    data.vertexMap[n + 3] = data.indices[i - 3];
                    data.vertexMap[n + 4] = data.indices[i - 1];
                    data.vertexMap[n + 5] = lastIndex;
                    data.indexMap[n + 0] = i - 3;
                    data.indexMap[n + 1] = i - 2;
                    data.indexMap[n + 2] = i - 1;
                    data.indexMap[n + 3] = i - 3;
                    data.indexMap[n + 4] = i - 1;
                    data.indexMap[n + 5] = i - 0;
                    n += 6;
                    continue;
                }
                data.vertexMap[n + 0] = data.indices[i - 2];
                data.vertexMap[n + 1] = data.indices[i - 1];
                data.vertexMap[n + 2] = lastIndex;
                data.indexMap[n + 0] = i - 2;
                data.indexMap[n + 1] = i - 1;
                data.indexMap[n + 2] = i - 0;
                n += 3;
            }
            data.reverseVertexMap = new ArrayList<List<Integer>>(data.srcVertexCount);
            for (i = 0; i < data.srcVertexCount; ++i) {
                data.reverseVertexMap.add(new ArrayList());
            }
            for (i = 0; i < data.vCount; ++i) {
                index = data.vertexMap[i];
                data.reverseVertexMap.get(index).add(i);
            }
        } else {
            data.iCount = data.vCount = data.srcVertexCount;
            data.vertexMap = new int[data.vCount];
            data.indexMap = new int[data.vCount];
            data.reverseVertexMap = new ArrayList<List<Integer>>(data.vCount);
            for (int i3 = 0; i3 < data.vCount; ++i3) {
                data.vertexMap[i3] = i3;
                data.indexMap[i3] = i3;
                ArrayList<Integer> reverseIndices = new ArrayList<Integer>(1);
                reverseIndices.add(i3);
                data.reverseVertexMap.add(reverseIndices);
            }
        }
        if (data.vertices != null) {
            FloatBuffer posBuf = BufferUtils.createFloatBuffer((int)(data.vCount * 3));
            mesh.setBuffer(VertexBuffer.Type.Position, 3, posBuf);
            int srcCount2 = data.vertices.length / 3;
            for (i2 = 0; i2 < data.vCount; ++i2) {
                int index = data.vertexMap[i2];
                if (index > srcCount2) {
                    throw new AssetLoadException("Invalid vertex mapping. Unexpected lookup vertex " + index + " from " + srcCount2);
                }
                float x = (float)data.vertices[3 * index + 0] / this.unitSize;
                float y2 = (float)data.vertices[3 * index + 1] / this.unitSize;
                float z2 = (float)data.vertices[3 * index + 2] / this.unitSize;
                posBuf.put(x).put(y2).put(z2);
            }
        }
        if (data.normals != null) {
            FloatBuffer normBuf = BufferUtils.createFloatBuffer((int)(data.vCount * 3));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, normBuf);
            int[] mapping = null;
            if (data.normalsMapping.equals("ByVertice")) {
                mapping = data.vertexMap;
            } else if (data.normalsMapping.equals("ByPolygonVertex")) {
                mapping = data.indexMap;
            }
            srcCount = data.normals.length / 3;
            for (i = 0; i < data.vCount; ++i) {
                int index = mapping[i];
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid normal mapping. Unexpected lookup normal " + index + " from " + srcCount);
                }
                float x = (float)data.normals[3 * index + 0];
                y = (float)data.normals[3 * index + 1];
                z = (float)data.normals[3 * index + 2];
                normBuf.put(x).put(y).put(z);
            }
        }
        if (data.tangents != null) {
            FloatBuffer tanBuf = BufferUtils.createFloatBuffer((int)(data.vCount * 4));
            mesh.setBuffer(VertexBuffer.Type.Tangent, 4, tanBuf);
            int[] mapping = null;
            if (data.tangentsMapping.equals("ByVertice")) {
                mapping = data.vertexMap;
            } else if (data.tangentsMapping.equals("ByPolygonVertex")) {
                mapping = data.indexMap;
            }
            srcCount = data.tangents.length / 3;
            for (i = 0; i < data.vCount; ++i) {
                int index = mapping[i];
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid tangent mapping. Unexpected lookup tangent " + index + " from " + srcCount);
                }
                float x = (float)data.tangents[3 * index + 0];
                y = (float)data.tangents[3 * index + 1];
                z = (float)data.tangents[3 * index + 2];
                tanBuf.put(x).put(y).put(z).put(-1.0f);
            }
        }
        if (data.binormals != null) {
            FloatBuffer binormBuf = BufferUtils.createFloatBuffer((int)(data.vCount * 3));
            mesh.setBuffer(VertexBuffer.Type.Binormal, 3, binormBuf);
            int[] mapping = null;
            if (data.binormalsMapping.equals("ByVertice")) {
                mapping = data.vertexMap;
            } else if (data.binormalsMapping.equals("ByPolygonVertex")) {
                mapping = data.indexMap;
            }
            srcCount = data.binormals.length / 3;
            for (i = 0; i < data.vCount; ++i) {
                int index = mapping[i];
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid binormal mapping. Unexpected lookup binormal " + index + " from " + srcCount);
                }
                float x = (float)data.binormals[3 * index + 0];
                y = (float)data.binormals[3 * index + 1];
                z = (float)data.binormals[3 * index + 2];
                binormBuf.put(x).put(y).put(z);
            }
        }
        if (data.uv != null) {
            int[] unIndexMap = data.vertexMap;
            if (data.uvIndex != null) {
                int uvIndexSrcCount = data.uvIndex.length;
                if (uvIndexSrcCount != data.iCount) {
                    throw new AssetLoadException("Invalid number of texcoord index data " + uvIndexSrcCount + " expected " + data.iCount);
                }
                unIndexMap = new int[data.vCount];
                n = 0;
                for (i = 0; i < data.iCount; ++i) {
                    int index = data.uvIndex[i];
                    if (isQuads && i % 4 == 3) {
                        unIndexMap[n + 0] = data.uvIndex[i - 3];
                        unIndexMap[n + 1] = data.uvIndex[i - 1];
                        unIndexMap[n + 2] = index;
                        n += 3;
                        continue;
                    }
                    unIndexMap[i] = index;
                }
            }
            FloatBuffer tcBuf = BufferUtils.createFloatBuffer((int)(data.vCount * 2));
            mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, tcBuf);
            srcCount = data.uv.length / 2;
            for (i = 0; i < data.vCount; ++i) {
                int index = unIndexMap[i];
                if (index > srcCount) {
                    throw new AssetLoadException("Invalid texcoord mapping. Unexpected lookup texcoord " + index + " from " + srcCount);
                }
                float u = index >= 0 ? (float)data.uv[2 * index + 0] : 0.0f;
                float v = index >= 0 ? (float)data.uv[2 * index + 1] : 0.0f;
                tcBuf.put(u).put(v);
            }
        }
        mesh.setStatic();
        mesh.updateBound();
        mesh.updateCounts();
        Geometry geom = new Geometry();
        geom.setMesh(mesh);
        return geom;
    }

    private Material createMaterial(MaterialData data) {
        Material m = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        m.setName(data.name);
        data.ambientColor.multLocal(data.ambientFactor);
        data.diffuseColor.multLocal(data.diffuseFactor);
        data.specularColor.multLocal(data.specularFactor);
        m.setColor("Ambient", new ColorRGBA(data.ambientColor.x, data.ambientColor.y, data.ambientColor.z, 1.0f));
        m.setColor("Diffuse", new ColorRGBA(data.diffuseColor.x, data.diffuseColor.y, data.diffuseColor.z, 1.0f));
        m.setColor("Specular", new ColorRGBA(data.specularColor.x, data.specularColor.y, data.specularColor.z, 1.0f));
        m.setFloat("Shininess", data.shininessExponent);
        m.setBoolean("UseMaterialColors", true);
        m.getAdditionalRenderState().setAlphaTest(true);
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        return m;
    }

    private Node createNode(ModelData data) {
        Node model = new Node(data.name);
        model.setLocalTranslation(data.localTranslation);
        model.setLocalRotation(data.localRotation);
        model.setLocalScale(data.localScale);
        return model;
    }

    private Limb createLimb(ModelData data) {
        Limb limb = new Limb();
        limb.name = data.name;
        Quaternion rotation = data.preRotation.mult(data.localRotation);
        limb.bindTransform = new Transform(data.localTranslation, rotation, data.localScale);
        return limb;
    }

    private BindPose createPose(BindPoseData data) {
        BindPose pose = new BindPose();
        pose.name = data.name;
        for (NodeTransformData item : data.list) {
            Transform t = this.buildTransform(item.transform);
            t.getScale().multLocal(this.unitSize);
            pose.nodeTransforms.put(item.nodeId, t);
        }
        return pose;
    }

    private Texture createTexture(TextureData data) {
        Texture2D tex = new Texture2D();
        tex.setName(data.name);
        return tex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createImage(ImageData data) {
        Texture tex;
        String locatorPath;
        File file;
        Image image = null;
        if (data.filename != null && (file = new File(data.filename)).exists() && file.isFile()) {
            File dir = new File(file.getParent());
            String locatorPath2 = dir.getAbsolutePath();
            Texture tex2 = null;
            try {
                this.assetManager.registerLocator(locatorPath2, FileLocator.class);
                tex2 = this.assetManager.loadTexture(file.getName());
            }
            catch (Exception exception) {
            }
            finally {
                this.assetManager.unregisterLocator(locatorPath2, FileLocator.class);
            }
            if (tex2 != null) {
                image = tex2.getImage();
            }
        }
        if (image == null && data.relativeFilename != null) {
            File dir = new File(this.sceneFolderName);
            locatorPath = dir.getAbsolutePath();
            tex = null;
            try {
                this.assetManager.registerLocator(locatorPath, FileLocator.class);
                tex = this.assetManager.loadTexture(data.relativeFilename);
            }
            catch (Exception exception) {
            }
            finally {
                this.assetManager.unregisterLocator(locatorPath, FileLocator.class);
            }
            if (tex != null) {
                image = tex.getImage();
            }
        }
        if (image == null && data.content != null) {
            String filename = null;
            if (data.filename != null) {
                filename = new File(data.filename).getName();
            }
            if (filename != null && data.relativeFilename != null) {
                filename = data.relativeFilename;
            }
            if (filename != null) {
                locatorPath = this.sceneFilename;
                filename = this.sceneFilename + File.separatorChar + filename;
                tex = null;
                try {
                    this.assetManager.registerLocator(locatorPath, ContentTextureLocator.class);
                    tex = this.assetManager.loadTexture((TextureKey)new ContentTextureKey(filename, data.content));
                }
                catch (Exception exception) {
                }
                finally {
                    this.assetManager.unregisterLocator(locatorPath, ContentTextureLocator.class);
                }
                if (tex != null) {
                    image = tex.getImage();
                }
            }
        }
        if (image == null) {
            throw new AssetLoadException("Content not loaded for image " + data.name);
        }
        return image;
    }

    private Transform buildTransform(double[] transform) {
        float[] m = new float[transform.length];
        for (int i = 0; i < transform.length; ++i) {
            m[i] = (float)transform[i];
        }
        Matrix4f matrix = new Matrix4f(m);
        Vector3f pos = matrix.toTranslationVector();
        Quaternion rot = matrix.toRotationQuat();
        Vector3f scale = matrix.toScaleVector();
        return new Transform(pos, rot, scale);
    }

    private Quaternion quatFromBoneAngles(float xAngle, float yAngle, float zAngle) {
        float angle = zAngle * 0.5f;
        float sinZ = FastMath.sin((float)angle);
        float cosZ = FastMath.cos((float)angle);
        angle = yAngle * 0.5f;
        float sinY = FastMath.sin((float)angle);
        float cosY = FastMath.cos((float)angle);
        angle = xAngle * 0.5f;
        float sinX = FastMath.sin((float)angle);
        float cosX = FastMath.cos((float)angle);
        float cosYXcosZ = cosY * cosZ;
        float sinYXsinZ = sinY * sinZ;
        float cosYXsinZ = cosY * sinZ;
        float sinYXcosZ = sinY * cosZ;
        float w = cosYXcosZ * cosX + sinYXsinZ * sinX;
        float x = cosYXcosZ * sinX - sinYXsinZ * cosX;
        float y = sinYXcosZ * cosX + cosYXsinZ * sinX;
        float z = cosYXsinZ * cosX - sinYXcosZ * sinX;
        return new Quaternion(x, y, z, w).normalizeLocal();
    }

    private Node linkScene() {
        logger.log(Level.FINE, "Linking scene objects");
        long startTime = System.currentTimeMillis();
        Node sceneNode = this.linkSceneNodes();
        this.linkMaterials();
        this.linkMeshes(sceneNode);
        this.linkSkins(sceneNode);
        this.linkAnimations();
        long estimatedTime = System.currentTimeMillis() - startTime;
        logger.log(Level.FINE, "Linking done in {0} ms", estimatedTime);
        return sceneNode;
    }

    private Node linkSceneNodes() {
        Object data;
        Node sceneNode = new Node(this.sceneName + "-scene");
        Iterator<Object> iterator = this.modelDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            long nodeId = iterator.next();
            data = this.modelDataMap.get(nodeId);
            Node node = this.createNode((ModelData)data);
            this.modelMap.put(nodeId, node);
        }
        iterator = this.modelMap.keySet().iterator();
        while (iterator.hasNext()) {
            long modelId = iterator.next();
            List<Long> refs = this.refMap.get(modelId);
            if (refs == null) continue;
            Node model = this.modelMap.get(modelId);
            for (long refId : refs) {
                Node rootNode = refId != 0L ? this.modelMap.get(refId) : sceneNode;
                if (rootNode == null) continue;
                rootNode.attachChild((Spatial)model);
            }
        }
        iterator = this.poseDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            long poseId = iterator.next();
            data = this.poseDataMap.get(poseId);
            BindPose pose = this.createPose((BindPoseData)data);
            if (pose == null) continue;
            this.bindMap.put(poseId, pose);
        }
        for (BindPose pose : this.bindMap.values()) {
            for (long nodeId : pose.nodeTransforms.keySet()) {
                Node model = this.modelMap.get(nodeId);
                if (model == null) continue;
                Transform t = pose.nodeTransforms.get(nodeId);
                model.setLocalTransform(t);
            }
        }
        return sceneNode;
    }

    private void linkMaterials() {
        Image img;
        Texture tex;
        Object data;
        for (long matId : this.matDataMap.keySet()) {
            data = this.matDataMap.get(matId);
            Material material = this.createMaterial((MaterialData)data);
            if (material == null) continue;
            this.matMap.put(matId, material);
        }
        for (long texId : this.texDataMap.keySet()) {
            data = this.texDataMap.get(texId);
            tex = this.createTexture((TextureData)data);
            if (tex == null) continue;
            this.texMap.put(texId, tex);
        }
        for (long imgId : this.imgDataMap.keySet()) {
            data = this.imgDataMap.get(imgId);
            img = this.createImage((ImageData)data);
            if (img == null) continue;
            this.imgMap.put(imgId, img);
        }
        for (long imgId : this.imgMap.keySet()) {
            List<Long> refs = this.refMap.get(imgId);
            if (refs == null) continue;
            img = this.imgMap.get(imgId);
            Iterator<Object> iterator = refs.iterator();
            while (iterator.hasNext()) {
                long refId = iterator.next();
                Texture tex2 = this.texMap.get(refId);
                if (tex2 == null) continue;
                tex2.setImage(img);
            }
        }
        for (long texId : this.texMap.keySet()) {
            List<PropertyLink> props = this.propMap.get(texId);
            if (props == null) continue;
            tex = this.texMap.get(texId);
            for (PropertyLink prop : props) {
                Material mat = this.matMap.get(prop.ref);
                if (mat == null) continue;
                if (prop.propName.equals("DiffuseColor")) {
                    mat.setTexture("DiffuseMap", tex);
                    mat.setColor("Diffuse", ColorRGBA.White);
                    continue;
                }
                if (prop.propName.equals("SpecularColor")) {
                    mat.setTexture("SpecularMap", tex);
                    mat.setColor("Specular", ColorRGBA.White);
                    continue;
                }
                if (!prop.propName.equals("NormalMap")) continue;
                mat.setTexture("NormalMap", tex);
            }
        }
    }

    private void linkMeshes(Node sceneNode) {
        Node rootNode;
        List<Long> refs;
        Geometry geom;
        for (long meshId : this.meshDataMap.keySet()) {
            MeshData data = this.meshDataMap.get(meshId);
            geom = this.createGeomerty(data);
            if (geom == null) continue;
            this.geomMap.put(meshId, geom);
        }
        block1: for (long geomId : this.geomMap.keySet()) {
            refs = this.refMap.get(geomId);
            if (refs == null) continue;
            geom = this.geomMap.get(geomId);
            for (long refId : refs) {
                rootNode = refId != 0L ? this.modelMap.get(refId) : sceneNode;
                if (rootNode == null) continue;
                geom.setName(rootNode.getName() + "-mesh");
                geom.updateModelBound();
                rootNode.attachChild((Spatial)geom);
                continue block1;
            }
        }
        for (long matId : this.matMap.keySet()) {
            refs = this.refMap.get(matId);
            if (refs == null) continue;
            Material mat = this.matMap.get(matId);
            for (long refId : refs) {
                rootNode = this.modelMap.get(refId);
                if (rootNode == null) continue;
                for (Spatial child : rootNode.getChildren()) {
                    child.setMaterial(mat);
                }
            }
        }
    }

    private void linkSkins(Node sceneNode) {
        List<Long> refs;
        Limb limb;
        for (long nodeId : this.modelDataMap.keySet()) {
            ModelData data = this.modelDataMap.get(nodeId);
            if (!data.type.equals("LimbNode")) continue;
            limb = this.createLimb(data);
            this.limbMap.put(nodeId, limb);
        }
        if (this.limbMap.size() == 0) {
            return;
        }
        HashMap<Long, Bone> bones = new HashMap<Long, Bone>();
        for (long limbId : this.limbMap.keySet()) {
            limb = this.limbMap.get(limbId);
            Bone bone = new Bone(limb.name);
            Transform t = limb.bindTransform;
            bone.setBindTransforms(t.getTranslation(), t.getRotation(), t.getScale());
            bones.put(limbId, bone);
        }
        for (long limbId : this.limbMap.keySet()) {
            refs = this.refMap.get(limbId);
            if (refs == null) continue;
            long rootLimbId = 0L;
            for (long refId : refs) {
                if (!this.limbMap.containsKey(refId)) continue;
                rootLimbId = refId;
                break;
            }
            if (rootLimbId == 0L) continue;
            Bone bone = (Bone)bones.get(limbId);
            Bone root = (Bone)bones.get(rootLimbId);
            root.addChild(bone);
        }
        block4: for (long clusterId : this.clusterMap.keySet()) {
            refs = this.refMap.get(clusterId);
            if (refs == null) continue;
            for (long skinId : refs) {
                if (!this.skinMap.containsKey(skinId)) continue;
                ClusterData data = this.clusterMap.get(clusterId);
                data.skinId = skinId;
                continue block4;
            }
        }
        this.skeleton = new Skeleton(bones.values().toArray(new Bone[0]));
        this.skeleton.setBindingPose();
        for (long limbId : bones.keySet()) {
            Bone bone = (Bone)bones.get(limbId);
            Limb limb2 = this.limbMap.get(limbId);
            limb2.boneIndex = this.skeleton.getBoneIndex(bone);
        }
        for (long skinId : this.skinMap.keySet()) {
            Mesh mesh = null;
            MeshData meshData = null;
            for (long meshId : this.refMap.get(skinId)) {
                Geometry g = this.geomMap.get(meshId);
                if (g == null) continue;
                meshData = this.meshDataMap.get(meshId);
                mesh = g.getMesh();
                break;
            }
            if (mesh == null || meshData == null) continue;
            FloatBuffer boneWeightData = BufferUtils.createFloatBuffer((int)(meshData.vCount * 4));
            ByteBuffer boneIndicesData = BufferUtils.createByteBuffer((int)(meshData.vCount * 4));
            mesh.setBuffer(VertexBuffer.Type.BoneWeight, 4, boneWeightData);
            mesh.setBuffer(VertexBuffer.Type.BoneIndex, 4, boneIndicesData);
            mesh.getBuffer(VertexBuffer.Type.BoneWeight).setUsage(VertexBuffer.Usage.CpuOnly);
            mesh.getBuffer(VertexBuffer.Type.BoneIndex).setUsage(VertexBuffer.Usage.CpuOnly);
            VertexBuffer weightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
            VertexBuffer indicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
            indicesHW.setUsage(VertexBuffer.Usage.CpuOnly);
            weightsHW.setUsage(VertexBuffer.Usage.CpuOnly);
            mesh.setBuffer(weightsHW);
            mesh.setBuffer(indicesHW);
            boolean bonesLimitExceeded = false;
            Iterator iterator = bones.keySet().iterator();
            while (iterator.hasNext()) {
                long limbId = (Long)iterator.next();
                ClusterData cluster = null;
                for (long clusterId : this.refMap.get(limbId)) {
                    ClusterData data = this.clusterMap.get(clusterId);
                    if (data == null || data.skinId != skinId) continue;
                    cluster = data;
                    break;
                }
                if (cluster == null || cluster.indexes == null || cluster.weights == null || cluster.indexes.length != cluster.weights.length) continue;
                Limb limb3 = this.limbMap.get(limbId);
                if (limb3.boneIndex > 255) {
                    throw new AssetLoadException("Bone index can't be packed into byte");
                }
                for (int i = 0; i < cluster.indexes.length; ++i) {
                    int vertexIndex = cluster.indexes[i];
                    if (vertexIndex >= meshData.reverseVertexMap.size()) {
                        throw new AssetLoadException("Invalid skinning vertex index. Unexpected index lookup " + vertexIndex + " from " + meshData.reverseVertexMap.size());
                    }
                    List<Integer> dstVertices = meshData.reverseVertexMap.get(vertexIndex);
                    for (int v : dstVertices) {
                        int offset;
                        float w = 0.0f;
                        for (offset = v * 4; offset < v * 4 + 4 && (w = boneWeightData.get(offset)) != 0.0f; ++offset) {
                        }
                        if (w == 0.0f) {
                            boneWeightData.put(offset, (float)cluster.weights[i]);
                            boneIndicesData.put(offset, (byte)limb3.boneIndex);
                            continue;
                        }
                        bonesLimitExceeded = true;
                    }
                }
            }
            if (bonesLimitExceeded) {
                logger.log(Level.WARNING, "Skinning support max 4 bone per vertex. Exceeding data will be discarded.");
            }
            int maxWeightsPerVert = 0;
            boneWeightData.rewind();
            for (int v = 0; v < meshData.vCount; ++v) {
                float w0 = boneWeightData.get();
                float w1 = boneWeightData.get();
                float w2 = boneWeightData.get();
                float w3 = boneWeightData.get();
                if (w3 != 0.0f) {
                    maxWeightsPerVert = Math.max(maxWeightsPerVert, 4);
                } else if (w2 != 0.0f) {
                    maxWeightsPerVert = Math.max(maxWeightsPerVert, 3);
                } else if (w1 != 0.0f) {
                    maxWeightsPerVert = Math.max(maxWeightsPerVert, 2);
                } else if (w0 != 0.0f) {
                    maxWeightsPerVert = Math.max(maxWeightsPerVert, 1);
                }
                float sum = w0 + w1 + w2 + w3;
                if (sum == 1.0f) continue;
                float mult = sum != 0.0f ? 1.0f / sum : 0.0f;
                boneWeightData.position(v * 4);
                boneWeightData.put(w0 * mult);
                boneWeightData.put(w1 * mult);
                boneWeightData.put(w2 * mult);
                boneWeightData.put(w3 * mult);
            }
            mesh.setMaxNumWeights(maxWeightsPerVert);
            mesh.generateBindPose(true);
        }
        this.animControl = new AnimControl(this.skeleton);
        sceneNode.addControl((Control)this.animControl);
        SkeletonControl control = new SkeletonControl(this.skeleton);
        sceneNode.addControl((Control)control);
    }

    private void linkAnimations() {
        AnimNode anode;
        Object acurve;
        if (this.skeleton == null) {
            return;
        }
        if (this.animList == null || this.animList.list.size() == 0) {
            return;
        }
        for (long curveId : this.acurveMap.keySet()) {
            List<PropertyLink> props = this.propMap.get(curveId);
            if (props == null) continue;
            acurve = this.acurveMap.get(curveId);
            for (PropertyLink prop : props) {
                anode = this.anodeMap.get(prop.ref);
                if (anode == null) continue;
                if (prop.propName.equals("d|X")) {
                    anode.xCurve = acurve;
                    continue;
                }
                if (prop.propName.equals("d|Y")) {
                    anode.yCurve = acurve;
                    continue;
                }
                if (!prop.propName.equals("d|Z")) continue;
                anode.zCurve = acurve;
            }
        }
        block2: for (long nodeId : this.anodeMap.keySet()) {
            List<Long> refs = this.refMap.get(nodeId);
            if (refs == null) continue;
            acurve = refs.iterator();
            while (acurve.hasNext()) {
                long layerId = (Long)acurve.next();
                if (!this.alayerMap.containsKey(layerId)) continue;
                anode = this.anodeMap.get(nodeId);
                anode.layerId = layerId;
                continue block2;
            }
        }
        HashMap<String, Animation> anims = new HashMap<String, Animation>();
        for (AnimationList.AnimInverval animInfo : this.animList.list) {
            float length = (float)(animInfo.lastFrame - animInfo.firstFrame) / this.animFrameRate;
            float animStart = (float)animInfo.firstFrame / this.animFrameRate;
            float animStop = (float)animInfo.lastFrame / this.animFrameRate;
            Animation anim = new Animation(animInfo.name, length);
            long sourceLayerId = 0L;
            Iterator<Object> iterator = this.alayerMap.keySet().iterator();
            while (iterator.hasNext()) {
                long layerId = iterator.next();
                AnimLayer layer = this.alayerMap.get(layerId);
                if (!layer.name.equals(animInfo.layerName)) continue;
                sourceLayerId = layerId;
                break;
            }
            for (Limb limb : this.limbMap.values()) {
                limb.animTranslation = null;
                limb.animRotation = null;
                limb.animScale = null;
            }
            iterator = this.anodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                long nodeId = (Long)iterator.next();
                List<PropertyLink> props = this.propMap.get(nodeId);
                if (props == null) continue;
                AnimNode anode2 = this.anodeMap.get(nodeId);
                if (sourceLayerId != 0L && anode2.layerId != sourceLayerId) continue;
                for (PropertyLink prop : props) {
                    Limb limb = this.limbMap.get(prop.ref);
                    if (limb == null) continue;
                    if (prop.propName.equals("Lcl Translation")) {
                        limb.animTranslation = anode2;
                        continue;
                    }
                    if (prop.propName.equals("Lcl Rotation")) {
                        limb.animRotation = anode2;
                        continue;
                    }
                    if (!prop.propName.equals("Lcl Scaling")) continue;
                    limb.animScale = anode2;
                }
            }
            for (Limb limb : this.limbMap.values()) {
                float z;
                float y;
                float x;
                int keyIndex;
                int i;
                int keysCount;
                boolean haveScale;
                long[] keyTimes = null;
                boolean haveTranslation = limb.animTranslation != null && limb.animTranslation.xCurve != null && limb.animTranslation.yCurve != null && limb.animTranslation.zCurve != null;
                boolean haveRotation = limb.animRotation != null && limb.animRotation.xCurve != null && limb.animRotation.yCurve != null && limb.animRotation.zCurve != null;
                boolean bl = haveScale = limb.animScale != null && limb.animScale.xCurve != null && limb.animScale.yCurve != null && limb.animScale.zCurve != null;
                if (haveTranslation) {
                    keyTimes = limb.animTranslation.xCurve.keyTimes;
                } else if (haveRotation) {
                    keyTimes = limb.animRotation.xCurve.keyTimes;
                } else if (haveScale) {
                    keyTimes = limb.animScale.xCurve.keyTimes;
                }
                if (keyTimes == null) continue;
                int firstKey = 0;
                int lastKey = keyTimes.length - 1;
                for (int i2 = 0; i2 < keyTimes.length; ++i2) {
                    float time = (float)((double)keyTimes[i2] * 2.165150866196751E-11);
                    if (time <= animStart) {
                        firstKey = i2;
                    }
                    if (!(time >= animStop)) continue;
                    lastKey = i2;
                    break;
                }
                if ((keysCount = lastKey - firstKey + 1) <= 0) continue;
                float[] times = new float[keysCount];
                Vector3f[] translations = new Vector3f[keysCount];
                Quaternion[] rotations = new Quaternion[keysCount];
                Vector3f[] scales = null;
                for (i = 0; i < keysCount; ++i) {
                    keyIndex = firstKey + i;
                    float time = (float)((double)keyTimes[keyIndex] * 2.165150866196751E-11);
                    times[i] = time - animStart;
                }
                if (haveTranslation) {
                    for (i = 0; i < keysCount; ++i) {
                        keyIndex = firstKey + i;
                        x = limb.animTranslation.xCurve.keyValues[keyIndex] - limb.animTranslation.value.x;
                        y = limb.animTranslation.yCurve.keyValues[keyIndex] - limb.animTranslation.value.y;
                        z = limb.animTranslation.zCurve.keyValues[keyIndex] - limb.animTranslation.value.z;
                        translations[i] = new Vector3f(x, y, z).divideLocal(this.unitSize);
                    }
                } else {
                    for (i = 0; i < keysCount; ++i) {
                        translations[i] = new Vector3f();
                    }
                }
                if (haveRotation) {
                    for (i = 0; i < keysCount; ++i) {
                        keyIndex = firstKey + i;
                        x = limb.animRotation.xCurve.keyValues[keyIndex];
                        y = limb.animRotation.yCurve.keyValues[keyIndex];
                        z = limb.animRotation.zCurve.keyValues[keyIndex];
                        rotations[i] = new Quaternion().fromAngles((float)Math.PI / 180 * x, (float)Math.PI / 180 * y, (float)Math.PI / 180 * z);
                    }
                } else {
                    for (i = 0; i < keysCount; ++i) {
                        rotations[i] = new Quaternion();
                    }
                }
                if (haveScale) {
                    scales = new Vector3f[keysCount];
                    for (i = 0; i < keysCount; ++i) {
                        keyIndex = firstKey + i;
                        x = limb.animScale.xCurve.keyValues[keyIndex];
                        y = limb.animScale.yCurve.keyValues[keyIndex];
                        z = limb.animScale.zCurve.keyValues[keyIndex];
                        scales[i] = new Vector3f(x, y, z);
                    }
                }
                BoneTrack track = null;
                track = haveScale ? new BoneTrack(limb.boneIndex, times, translations, rotations, scales) : new BoneTrack(limb.boneIndex, times, translations, rotations);
                anim.addTrack((Track)track);
            }
            anims.put(anim.getName(), anim);
        }
        this.animControl.setAnimations(anims);
    }

    private void releaseObjects() {
        this.meshDataMap.clear();
        this.matDataMap.clear();
        this.texDataMap.clear();
        this.imgDataMap.clear();
        this.modelDataMap.clear();
        this.poseDataMap.clear();
        this.skinMap.clear();
        this.clusterMap.clear();
        this.acurveMap.clear();
        this.anodeMap.clear();
        this.alayerMap.clear();
        this.refMap.clear();
        this.propMap.clear();
        this.modelMap.clear();
        this.limbMap.clear();
        this.bindMap.clear();
        this.geomMap.clear();
        this.matMap.clear();
        this.texMap.clear();
        this.imgMap.clear();
        this.skeleton = null;
        this.animControl = null;
        this.animList = null;
    }

    private class AnimCurveData {
        long[] keyTimes;
        float[] keyValues;

        private AnimCurveData() {
        }
    }

    private class AnimLayer {
        String name;

        private AnimLayer() {
        }
    }

    private class AnimNode {
        String name;
        Vector3f value;
        AnimCurveData xCurve;
        AnimCurveData yCurve;
        AnimCurveData zCurve;
        long layerId;

        private AnimNode() {
        }
    }

    private class BindPose {
        String name;
        Map<Long, Transform> nodeTransforms = new HashMap<Long, Transform>();

        private BindPose() {
        }
    }

    private class BindPoseData {
        String name;
        List<NodeTransformData> list = new LinkedList<NodeTransformData>();

        private BindPoseData() {
        }
    }

    private class ClusterData {
        int[] indexes;
        double[] weights;
        double[] transform;
        double[] transformLink;
        long skinId;

        private ClusterData() {
        }
    }

    private class ImageData {
        String name;
        String type;
        String filename;
        String relativeFilename;
        byte[] content;

        private ImageData() {
        }
    }

    private class Limb {
        String name;
        Transform bindTransform;
        int boneIndex;
        AnimNode animTranslation;
        AnimNode animRotation;
        AnimNode animScale;

        private Limb() {
        }
    }

    private class MaterialData {
        String name;
        String shadingModel = "phong";
        Vector3f ambientColor = new Vector3f(0.2f, 0.2f, 0.2f);
        float ambientFactor = 1.0f;
        Vector3f diffuseColor = new Vector3f(0.8f, 0.8f, 0.8f);
        float diffuseFactor = 1.0f;
        Vector3f specularColor = new Vector3f(0.2f, 0.2f, 0.2f);
        float specularFactor = 1.0f;
        float shininessExponent = 20.0f;

        private MaterialData() {
        }
    }

    private class MeshData {
        double[] vertices;
        int[] indices;
        int[] edges;
        String normalsMapping;
        String normalsReference;
        double[] normals;
        String tangentsMapping;
        String tangentsReference;
        double[] tangents;
        String binormalsMapping;
        String binormalsReference;
        double[] binormals;
        String uvMapping;
        String uvReference;
        double[] uv;
        int[] uvIndex;
        String smoothingMapping;
        String smoothingReference;
        int[] smoothing;
        String materialsMapping;
        String materialsReference;
        int[] materials;
        int iCount;
        int vCount;
        int srcVertexCount;
        int[] vertexMap;
        List<List<Integer>> reverseVertexMap;
        int[] indexMap;

        private MeshData() {
        }
    }

    private class ModelData {
        String name;
        String type;
        Vector3f localTranslation = new Vector3f();
        Quaternion localRotation = new Quaternion();
        Vector3f localScale = new Vector3f(Vector3f.UNIT_XYZ);
        Quaternion preRotation = new Quaternion();

        private ModelData() {
        }
    }

    private class NodeTransformData {
        long nodeId;
        double[] transform;

        private NodeTransformData() {
        }
    }

    private class PropertyLink {
        long ref;
        String propName;

        public PropertyLink(long id, String prop) {
            this.ref = id;
            this.propName = prop;
        }
    }

    private class SkinData {
        String type;

        private SkinData() {
        }
    }

    private class TextureData {
        String name;
        String bindType;
        String filename;

        private TextureData() {
        }
    }
}

