
import com.simsilica.lemur.*;
import com.simsilica.lemur.component.*;
import com.simsilica.mattacks.*;

selector("glass") {
    font = font("Interface/arial-30.fnt")  
    fontSize = 30   
}

selector("category.label", "glass") {
    fontSize = 30
}
selector("level.button", "glass") {
    fontSize = 25
    background = null
    insets = new Insets3f(4, 0, 0, 0)
}

selector("column.container", "glass") {
    layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)
    background = null
}

selector("row", "glass") {
    layout = new SpringGridLayout(Axis.X, Axis.Y)
}

selector("category.container", "glass") {
    layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)
    insets = new Insets3f(10, 20, 10, 20)
}

selector("answer.label", "glass") {
    color = color(1, 1, 0, 1)
    background = new QuadBackgroundComponent(texture("Interface/circle.png"))
    background.color = color(1, 1, 0, 0.75) 
}

selector("correct.answer.label", "glass") {
    fontSize = 45
    color = color(0, 1, 0, 1)
    background = new QuadBackgroundComponent(texture("Interface/circle.png"))
    background.color = color(0, 1, 0, 0.75) 
}

selector("incorrect.answer.label", "glass") {
    fontSize = 45
    color = color(1, 0, 0, 1)
    background = new QuadBackgroundComponent(texture("Interface/circle.png"))
    background.color = color(1, 0, 0, 0.75) 
}

selector("score.container", "glass") {
    background = null
}

selector("level.label", "glass") {
    textHAlignment = HAlignment.Center
}

selector( "optionPanel", "glass" ) {
    background = new QuadBackgroundComponent(color(0, 0, 0, 1))
}

def gradient = TbtQuadBackgroundComponent.create( 
                                        texture( name:"/com/simsilica/lemur/icons/bordered-gradient.png", 
                                                 generateMips:false ),
                                                 1, 1, 1, 126, 126,
                                                 1f, false );

def round = TbtQuadBackgroundComponent.create(
                                        texture( name:"Interface/circle.png", 
                                                 generateMips:false ),
                                                 0.05, 127, 127, 128, 128,
                                                 1f, false );
round.setMargin((float)(127 * 0.05), (float)(127 * 0.05));                                                 

selector( "achievement.container", "glass" ) {
    background = round.clone();
    background.color = color(0.25, 0.5, 0.5, 0.95)
}

selector( "weekly.container", "glass" ) {
    layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)
    //background = round.clone();
    background = null
    insets = new Insets3f(0, 0, 5, 0)
}

selector( "daily.container", "glass" ) {
    layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)
    //background = round.clone();
    background = null
}

selector( "goal.container", "glass" ) {
    background = round.clone();
    background.color = color(0.25, 0.5, 0.5, 0.95)
    
    insets = new Insets3f(2, 0, 2, 0)
}

selector( "goal.name.label", "glass" ) {    
    background = gradient.clone();
    background.color = color(0.25, 0.5, 0.5, 0.95)
    //fontSize = 15    
}

selector( "goal.description.label", "glass" ) {
    fontSize = 20    
}


selector( "paused.label", "glass" ) {

    fontSize = 60
    color = color(0.1, 0.3, 0.9, 1)

    background = round.clone();
    background.color = color(0.25, 0.5, 0.5, 0.95)
    
    insets = new Insets3f(10, 10, 10, 10);
}

selector( "game.buttons.container", "glass" ) {
    background = round.clone();
    background.color = color(0.25, 0.5, 0.5, 0.95)    
}


def bigRound = TbtQuadBackgroundComponent.create(
                                        texture( name:"Interface/circle.png", 
                                                 generateMips:false ),
                                                 0.25, 127, 127, 128, 128,
                                                 1f, false );
bigRound.setMargin((float)(127 * 0.25), (float)(127 * 0.25));                                                 

//selector( "optionPanel.container", "glass" ) { 
selector( "optionPanel", "glass" ) { 

    background = bigRound.clone()
    background.color = color(0.25, 0.5, 0.75, 0.95)
    //background.setMargin(50, 50)    
    insets = new Insets3f(10, 10, 10, 10);
    
    effects = [
        open:new OpenWindow(null, null, 0.5),
        close:new CloseWindow(0.5)
    ]
}

selector("window.container", "glass") {
    effects = [
        open:OpenWindow.createCentered(null, 0.5),
        close:new CloseWindow(0.5)
    ]
}

selector( "options.window.container", "glass" ) { 

    background = bigRound.clone()
    background.color = color(0.25, 0.5, 0.75, 0.95)
    //background.setMargin(50, 50)    
    insets = new Insets3f(10, 10, 10, 10);
}

selector("option.label", "glass") {
    fontSize = 20
    color = color(0.8, 0.9, 0.9, 1)
    textHAlignment = HAlignment.Right
    insets = new Insets3f(4, 0, 0, 0);
}

selector("option.slider", "button", "glass") {
    fontSize = 20
}

def doubleGradient = new QuadBackgroundComponent( color(0.5, 0.75, 0.85, 0.5) );  
doubleGradient.texture = texture( name:"/com/simsilica/lemur/icons/double-gradient-128.png", 
                                  generateMips:false )

selector( "disabled.label", "glass" ) {
    color = color(0.5, 0.5, 0.5, 0.5)
}

selector( "options.container", "glass" ) {
    background = null
    insets = new Insets3f(0, 0, 0, 0)
}

selector( "options.section.container", "glass" ) {
    insets = new Insets3f(0, 0, 10, 0)
}

selector( "section.title.label", "glass" ) {
    background = null;
    color = color(0.8, 0.8, 0.9, 1)
}

selector("option.slider", "thumb.button", "glass") {
    text = ""
    icon = new IconComponent("Interface/grid-button.png")
    icon.iconScale = vec2(0.3, 0.3)
    icon.color = color(0.5, 0.75, 0.75, 0.5)     
}

selector("option.slider", "left.button", "glass") {
    /*background = doubleGradient.clone()
    background.setColor(color(0.5, 0.75, 0.75, 0.5))
    background.setMargin(0, 4);*/
    //textVAlignment = VAlignment.Center
    //icon = new IconComponent("Interface/minus-button.png");    
}


selector("option.slider", "right.button", "glass") {
    /*background = doubleGradient.clone()
    background.setColor(color(0.5, 0.75, 0.75, 0.5))
    background.setMargin(0, 4);*/
    textVAlignment = VAlignment.Center            
    //icon = new IconComponent("Interface/plus-button.png");    
}


