
import com.simsilica.es.*;
import com.simsilica.mattacks.*;
import com.simsilica.mattacks.es.*;

levels = []

class DefaultLevelFactory implements LevelFactory {
    EntityData ed;
    String category;
    String name;
    String description;
    ModelType modelType;
    int lanes;
    float speed;
    int total;
    int scoreMultiplier = 1;
    ProblemSetFactory factory; 
    
    public DefaultLevelFactory( EntityData ed, String category, String name ) {
        this.ed = ed;
        this.category = category;
        this.name = name;
    }
 
    public ModelType modelType( String name ) {
        this.modelType = ModelType.create(name, ed);
        return modelType;
    }
 
    public void setModelType( String name ) {
        this.modelType = ModelType.create(name, ed);
    }

    public String getModelType() {
        return modelType.getType(ed);
    }
    
    public Level createLevel() {
        List<FlashCard> problems = factory.createProblems(total);
            
        Level result = new Level(category, name, description, problems,
                                 lanes, modelType, speed, scoreMultiplier);           
        return result;            
    }    
    
    public String toString() {
        return "DefaultLevelFactory[" + category + ":" + name + ", factory=" + factory 
                                      + ", modelType=" + modelType + "]";
    }
}

level = { String category, String name, Closure closure ->

    println "Configuring " + category + ":" + name;
    
    def result = new DefaultLevelFactory(ed, category, name);
    //closure.setResolveStrategy(Closure.DELEGATE_FIRST);
    closure.setResolveStrategy(Closure.DELEGATE_ONLY);
    result.with(closure);
 
    levels += result;
    
    return result;   
}
