/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.ScoreState;
import com.simsilica.mattacks.es.Answer;
import com.simsilica.mattacks.es.Decay;
import com.simsilica.mattacks.es.Explosion;
import com.simsilica.mattacks.es.FlashCard;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.es.SoundType;
import com.simsilica.mattacks.es.Velocity;
import java.util.Set;

public class AnswerState
extends BaseAppState {
    private EntityData ed;
    private EntitySet answers;
    private ScoreState score;
    private static final String[] MISS_SOUNDS = new String[]{"spaceTrash1", "spaceTrash2", "spaceTrash3", "spaceTrash4", "spaceTrash5"};
    private SoundType[] missSounds;

    protected static SoundType[] soundTypes(String[] names, EntityData ed) {
        SoundType[] results = new SoundType[names.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = SoundType.create(names[i], ed);
        }
        return results;
    }

    protected static SoundType random(SoundType[] types) {
        int i = (int)(Math.random() * (double)types.length);
        return types[i];
    }

    protected void processAnswers(Set<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        for (Entity e : entities) {
            FlashCard problem = e.get(FlashCard.class);
            Answer answer = e.get(Answer.class);
            Position pos = this.ed.getComponent(e.getId(), Position.class);
            if (answer.getValue() != -1 && pos != null) {
                float xDelta = (float)(Math.random() * 2.0 - 1.0);
                float yDelta = (float)Math.random();
                EntityId marker = this.ed.createEntity();
                this.ed.setComponents(marker, pos, answer, new Velocity(xDelta * 20.0f, yDelta * 20.0f), Decay.futureSeconds(2.0));
            }
            switch (this.score.addAnswer(problem, answer)) {
                case Correct: {
                    System.out.println("HIT:" + e);
                    e.set(new Explosion());
                    this.ed.removeComponent(e.getId(), Answer.class);
                    break;
                }
                case Incorrect: {
                    System.out.println("INCORRECT:" + e);
                    Velocity v = this.ed.getComponent(e.getId(), Velocity.class);
                    if (v == null) break;
                    e.set(new Velocity(v.getLinear().x, v.getLinear().y * 5.0f));
                    SoundType sound = AnswerState.random(this.missSounds);
                    System.out.println("Setting sound:" + sound);
                    e.set(sound);
                    e.set(problem.getCorrectAnswer());
                    break;
                }
                case Unanswered: {
                    System.out.println("MISS:" + e);
                    e.set(AnswerState.random(this.missSounds));
                    e.set(problem.getCorrectAnswer());
                }
            }
            this.ed.removeComponent(e.getId(), FlashCard.class);
        }
    }

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.score = this.getState(ScoreState.class);
        this.missSounds = AnswerState.soundTypes(MISS_SOUNDS, this.ed);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.answers = this.ed.getEntities(FlashCard.class, Answer.class);
    }

    @Override
    public void update(float tpf) {
        if (this.answers.applyChanges()) {
            this.processAnswers(this.answers.getAddedEntities());
        }
    }

    @Override
    protected void onDisable() {
        this.answers.release();
    }
}

