/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.TimeState;
import com.simsilica.mattacks.es.Decay;
import com.simsilica.mattacks.util.EntityContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecayState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(DecayState.class);
    private EntityData ed;
    private DecayContainer container;
    private TimeState timeState;

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.timeState = this.getState(TimeState.class);
        this.container = new DecayContainer(this.ed);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.container.start();
    }

    @Override
    public void update(float tpf) {
        this.container.update();
        long t = this.timeState.getTime();
        for (Entity e : this.container.getArray()) {
            Decay decay = e.get(Decay.class);
            if (decay.getEndTime() >= t) continue;
            if (log.isDebugEnabled()) {
                log.debug("*** removing:" + e.getId());
            }
            this.ed.removeEntity(e.getId());
        }
    }

    @Override
    protected void onDisable() {
        this.container.stop();
    }

    private class DecayContainer
    extends EntityContainer<Entity> {
        public DecayContainer(EntityData ed) {
            super(ed, Decay.class);
        }

        protected Entity[] getArray() {
            return (Entity[])super.getArray();
        }

        @Override
        protected Entity addObject(Entity e) {
            return e;
        }

        @Override
        protected void updateObject(Entity object, Entity e) {
        }

        @Override
        protected void removeObject(Entity object, Entity e) {
        }
    }
}

