/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.event.DefaultMouseListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.mattacks.EntityDataState;
import com.simsilica.mattacks.ModelState;
import com.simsilica.mattacks.NumberPadState;
import com.simsilica.mattacks.es.Answer;
import com.simsilica.mattacks.es.FlashCard;
import com.simsilica.mattacks.es.ModelType;
import com.simsilica.mattacks.es.Position;
import com.simsilica.mattacks.util.EntityContainer;

public class FlashCardState
extends BaseAppState {
    private ModelState models;
    private EntityData ed;
    private FlashCardContainer cards;
    private NumberPadState numberPad;

    @Override
    protected void initialize(Application app) {
        this.ed = this.getState(EntityDataState.class).getEntityData();
        this.models = this.getState(ModelState.class);
        this.numberPad = this.getState(NumberPadState.class);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.cards = new FlashCardContainer(this.ed);
        this.cards.start();
    }

    @Override
    public void update(float tpf) {
        this.cards.update();
    }

    @Override
    protected void onDisable() {
        this.cards.stop();
        this.cards = null;
    }

    private class FlashCardContainer
    extends EntityContainer<Ship> {
        public FlashCardContainer(EntityData ed) {
            super(ed, Position.class, ModelType.class, FlashCard.class);
        }

        @Override
        protected Ship addObject(Entity e) {
            Ship result = new Ship(e);
            this.updateObject(result, e);
            return result;
        }

        @Override
        protected void updateObject(Ship ship, Entity e) {
            ship.update();
        }

        @Override
        protected void removeObject(Ship ship, Entity e) {
            ship.close();
        }
    }

    private class Ship {
        Entity entity;
        Container panel;
        ClickListener listener;

        public Ship(Entity e) {
            this.entity = e;
            FlashCard card = e.get(FlashCard.class);
            this.panel = new Container();
            this.panel.addChild(new Label(String.valueOf(card.getOpA())), 0, 1).setTextHAlignment(HAlignment.Right);
            this.panel.addChild(new Label(card.getOperator() + String.valueOf(card.getOpB())), 1, 1).setTextHAlignment(HAlignment.Right);
            this.listener = new ClickListener(e.getId(), card, this.panel);
        }

        public void update() {
            Node parent;
            if (this.panel.getParent() == null && (parent = FlashCardState.this.models.getModel(this.entity.getId())) != null) {
                parent.attachChild(this.panel);
                FlashCard card = this.entity.get(FlashCard.class);
                MouseEventControl.addListenersToSpatial(parent, this.listener);
            }
        }

        public void close() {
            if (this.panel.getParent() != null) {
                Node parent = this.panel.getParent();
                MouseEventControl.removeListenersFromSpatial(parent, this.listener);
                this.panel.removeFromParent();
            }
        }
    }

    private class ClickListener
    extends DefaultMouseListener {
        private final EntityId entityId;
        private final FlashCard card;
        private ColorRGBA originalBgColor;
        private ColorRGBA mix;
        private ColorRGBA originalLabelColor;
        private Container container;

        public ClickListener(EntityId entityId, FlashCard card, Container container) {
            super(10, 10);
            this.mix = new ColorRGBA(0.0f, 1.0f, 1.0f, 1.0f);
            this.entityId = entityId;
            this.card = card;
            this.container = container;
        }

        @Override
        protected void click(MouseButtonEvent event, Spatial target, Spatial capture) {
            System.out.println("click(" + event + ", " + target + ", " + capture + ")");
            Vector3f pos = this.container.getWorldTranslation();
            Vector3f size = this.container.getSize();
            float x = pos.x + size.x;
            float y = pos.y;
            FlashCardState.this.numberPad.activateNumberPad(x, y, new SubmitAnswer(this.entityId, this.card));
        }

        protected void highlight(Panel p) {
            GuiComponent comp = p.getBackground();
            if (!(comp instanceof ColoredComponent)) {
                return;
            }
            ColoredComponent cc = (ColoredComponent)((Object)comp);
            this.originalBgColor = cc.getColor();
            ColorRGBA c = this.originalBgColor.clone().interpolateLocal(this.mix, 0.5f);
            c.a = this.originalBgColor.a;
            cc.setColor(c);
            if (p instanceof Container) {
                Container container = (Container)p;
                for (Node n : container.getLayout().getChildren()) {
                    if (!(n instanceof Label)) continue;
                    Label label = (Label)n;
                    this.originalLabelColor = label.getColor();
                    label.setColor(this.mix);
                }
            }
        }

        protected void unhighlight(Panel p) {
            if (this.originalBgColor == null) {
                return;
            }
            GuiComponent comp = p.getBackground();
            if (!(comp instanceof ColoredComponent)) {
                return;
            }
            ColoredComponent cc = (ColoredComponent)((Object)comp);
            cc.setColor(this.originalBgColor);
            if (p instanceof Container) {
                Container container = (Container)p;
                for (Node n : container.getLayout().getChildren()) {
                    if (!(n instanceof Label)) continue;
                    Label label = (Label)n;
                    label.setColor(this.originalLabelColor);
                }
            }
        }

        @Override
        public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
            this.originalBgColor = null;
            this.highlight(this.container);
        }

        @Override
        public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
            if (this.originalBgColor == null) {
                return;
            }
            this.unhighlight(this.container);
        }
    }

    private class SubmitAnswer
    implements Command<Integer> {
        private final EntityId entityId;
        private final FlashCard card;

        public SubmitAnswer(EntityId entityId, FlashCard card) {
            this.entityId = entityId;
            this.card = card;
        }

        @Override
        public void execute(Integer value) {
            System.out.println("Submit answer to:" + this.entityId + " value:" + value + "  problem:" + this.card);
            FlashCardState.this.ed.setComponent(this.entityId, new Answer(this.card, value));
        }
    }
}

