/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.PanelTweens;
import com.simsilica.lemur.anim.SpatialTweens;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.TweenAnimation;
import com.simsilica.lemur.anim.Tweens;
import com.simsilica.lemur.effect.AbstractEffect;
import com.simsilica.lemur.effect.EffectInfo;

public class OpenWindow
extends AbstractEffect<Panel> {
    public static final String DEFAULT_CHANNEL = "open";
    private Node parent;
    private double length;
    private Vector3f center;

    public OpenWindow(Node parent, double length) {
        this(DEFAULT_CHANNEL, parent, null, length);
    }

    public OpenWindow(Node parent, Vector3f center, double length) {
        this(DEFAULT_CHANNEL, parent, center, length);
    }

    public OpenWindow(String channel, Node parent, Vector3f center, double length) {
        super(channel);
        this.parent = parent;
        this.center = center;
        this.length = length;
    }

    public static OpenWindow createCentered(Application app, double length) {
        return OpenWindow.createCentered(app, 0.0f, length);
    }

    public static OpenWindow createCentered(Application app, float layer, double length) {
        if (app == null) {
            return new OpenWindow(null, new Vector3f(0.0f, 0.0f, layer), length);
        }
        if (!(app instanceof SimpleApplication)) {
            throw new IllegalArgumentException("Cannot retrieve guiNode from raw Application:" + app);
        }
        Node guiNode = ((SimpleApplication)app).getGuiNode();
        Camera cam = app.getCamera();
        Vector3f center = new Vector3f((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f, layer);
        return new OpenWindow(guiNode, center, length);
    }

    @Override
    public Animation create(Panel target, EffectInfo last) {
        if (this.parent == null) {
            SimpleApplication app = (SimpleApplication)AnimationState.getDefaultInstance().getApplication();
            this.parent = app.getGuiNode();
            if (this.center != null) {
                Camera cam = app.getCamera();
                this.center = new Vector3f((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f, this.center.z);
            }
        }
        Tween attach = SpatialTweens.attach(target, this.parent);
        Tween fade = PanelTweens.fade(target, Float.valueOf(0.0f), Float.valueOf(1.0f), this.length);
        if (this.center != null) {
            Animation existing;
            Vector3f pref = target.getPreferredSize();
            Vector3f to = new Vector3f(this.center.x - pref.x * 0.5f, this.center.y + pref.y * 0.5f, this.center.z - pref.z * 0.5f);
            Animation animation = existing = last == null ? null : last.getAnimation();
            if (existing instanceof TweenAnimation && ((TweenAnimation)existing).getRemaining() > 0.0) {
                Tween move = SpatialTweens.move(target, null, to, this.length);
                fade = Tweens.parallel(move, fade);
            } else {
                target.setLocalTranslation(to);
            }
        }
        return new TweenAnimation(Tweens.smoothStep(attach, fade));
    }
}

