/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.audio.AudioNode;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.FlashCardState;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.MainFunctions;
import com.simsilica.mattacks.NumberPadState;
import com.simsilica.mattacks.SoundCommand;
import com.simsilica.mattacks.SoundState;
import com.simsilica.mattacks.TimeState;
import com.simsilica.mattacks.TitleState;

public class PauseState
extends BaseAppState {
    private Container pausedWindow;
    private Label pausedLabel;
    private Panel gui;
    private SoundCommand open;
    private SoundCommand close;

    public PauseState() {
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void show(Panel gui) {
        if (this.gui != null) {
            this.pausedWindow.removeChild(this.gui);
        }
        this.gui = gui;
        if (this.gui != null) {
            this.pausedWindow.addChild(gui, new Object[]{BorderLayout.Position.Center});
        }
        this.setEnabled(true);
    }

    @Override
    protected void initialize(Application app) {
        InputMapper input = GuiGlobals.getInstance().getInputMapper();
        input.addDelegate(MainFunctions.F_PAUSE, this, "toggleEnabled");
        this.pausedWindow = new Container((GuiLayout)new BorderLayout(), new ElementId("paused"));
        this.pausedLabel = this.pausedWindow.addChild(new Label("PAUSED", new ElementId("paused.label")), new Object[]{BorderLayout.Position.North});
        this.open = new SoundCommand(new AudioNode(app.getAssetManager(), "Sounds/threeTone2.ogg"));
        this.close = new SoundCommand(new AudioNode(app.getAssetManager(), "Sounds/twoTone1.ogg"));
    }

    @Override
    protected void cleanup(Application app) {
        InputMapper input = GuiGlobals.getInstance().getInputMapper();
        input.removeDelegate(MainFunctions.F_PAUSE, this, "toggleEnabled");
    }

    @Override
    protected void onEnable() {
        System.out.println("PAUSING");
        Vector3f pref = this.pausedWindow.getPreferredSize();
        Camera cam = this.getApplication().getCamera();
        this.pausedWindow.setLocalTranslation((float)cam.getWidth() * 0.5f - pref.x * 0.5f, (float)cam.getHeight() * 0.5f + pref.y * 0.5f, 110.0f);
        ((Main)this.getApplication()).getGuiNode().attachChild(this.pausedWindow);
        this.open.execute(this.pausedWindow);
        this.getState(TimeState.class).setEnabled(false);
        this.getState(FlashCardState.class).setEnabled(false);
        this.getState(NumberPadState.class).setEnabled(false);
        if (this.getState(TitleState.class) != null) {
            this.getState(TitleState.class).setEnabled(false);
        }
        this.getState(SoundState.class).pauseMusic();
    }

    @Override
    protected void onDisable() {
        this.close.execute(this.pausedWindow);
        System.out.println("RESUMING");
        this.pausedWindow.removeFromParent();
        if (this.gui != null) {
            this.pausedWindow.removeChild(this.gui);
            this.gui = null;
        }
        this.getState(TimeState.class).setEnabled(true);
        if (this.getState(FlashCardState.class) != null) {
            this.getState(FlashCardState.class).setEnabled(true);
        }
        if (this.getState(TitleState.class) != null) {
            this.getState(TitleState.class).setEnabled(true);
        }
        this.getState(SoundState.class).resumeMusic();
    }
}

