/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.DynamicInsetsComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.Main;
import com.simsilica.mattacks.es.Answer;
import com.simsilica.mattacks.es.FlashCard;
import java.util.HashMap;
import java.util.Map;

public class ScoreState
extends BaseAppState {
    private final Map<FlashCard, Stats> scores = new HashMap<FlashCard, Stats>();
    private final Stats overall = new Stats();
    private Stats current = new Stats();
    private int currentMax = 0;
    private Container display;
    private Label stageTitle;
    private Label stageTotal;
    private Label stageMax;
    private Label overallTotal;
    private Label overallMax;

    public Stats getCurrentStats() {
        return this.current;
    }

    public Stats getStats(FlashCard card, boolean create) {
        Stats result = this.scores.get(card);
        if (result == null && create) {
            result = new Stats();
            this.scores.put(card, result);
        }
        return result;
    }

    public void newStage(int currentMax, String title) {
        this.currentMax = currentMax;
        this.current = new Stats();
        this.refreshDisplay();
        this.setStageTitle(title);
    }

    public void setStageTitle(String title) {
        this.stageTitle.setText(title);
    }

    public ScoreType addAnswer(FlashCard card, Answer answer) {
        ScoreType result;
        if (answer.getValue() == -1) {
            this.addMiss(card);
            return ScoreType.Unanswered;
        }
        if (card.getAnswer() == answer.getValue()) {
            ++this.getStats((FlashCard)card, (boolean)true).correct;
            ++this.overall.correct;
            ++this.current.correct;
            result = ScoreType.Correct;
        } else {
            ++this.getStats((FlashCard)card, (boolean)true).incorrect;
            ++this.overall.incorrect;
            ++this.current.incorrect;
            result = ScoreType.Incorrect;
        }
        this.refreshDisplay();
        return result;
    }

    public void addMiss(FlashCard card) {
        ++this.getStats((FlashCard)card, (boolean)true).miss;
        ++this.overall.miss;
        ++this.current.miss;
        this.refreshDisplay();
    }

    protected void refreshDisplay() {
        this.stageTotal.setText(String.valueOf(this.current.correct));
        this.stageMax.setText(String.valueOf(this.currentMax));
        this.overallTotal.setText(String.valueOf(this.overall.correct));
        this.overallMax.setText(String.valueOf(this.overall.getTotal()));
    }

    @Override
    protected void initialize(Application app) {
        this.display = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.ForcedEven, FillMode.Even), new ElementId("scorebar.container"));
        ElementId scoreId = new ElementId("score.container");
        Container sub = this.display.addChild(new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Even, FillMode.Even), scoreId), new Object[0]);
        sub.setInsetsComponent(new DynamicInsetsComponent(0.0f, 0.0f, 0.0f, 1.0f));
        sub.addChild(new Label("Level Score:"), new Object[0]);
        this.stageTotal = sub.addChild(new Label(String.valueOf(this.current.correct)), new Object[0]);
        sub.addChild(new Label("/"), new Object[0]);
        this.stageMax = sub.addChild(new Label(String.valueOf(this.currentMax)), new Object[0]);
        this.stageTitle = this.display.addChild(new Label("", new ElementId("level.label")), new Object[0]);
        sub = this.display.addChild(new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Even, FillMode.Even), scoreId), new Object[0]);
        sub.setInsetsComponent(new DynamicInsetsComponent(0.0f, 1.0f, 0.0f, 0.0f));
        sub.addChild(new Label("Overall Score:"), new Object[0]);
        this.overallTotal = sub.addChild(new Label(String.valueOf(this.overall.correct)), new Object[0]);
        sub.addChild(new Label("/"), new Object[0]);
        this.overallMax = sub.addChild(new Label(String.valueOf(this.overall.getTotal())), new Object[0]);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        ((Main)this.getApplication()).getGuiNode().attachChild(this.display);
        Camera cam = this.getApplication().getCamera();
        Vector3f pref = this.display.getPreferredSize();
        this.display.setPreferredSize(new Vector3f(cam.getWidth(), pref.y, pref.z));
        this.display.setLocalTranslation(0.0f, cam.getHeight(), 0.0f);
    }

    @Override
    protected void onDisable() {
        this.display.removeFromParent();
    }

    public class Stats {
        int correct;
        int incorrect;
        int miss;

        public int getTotal() {
            return this.correct + this.incorrect + this.miss;
        }

        public double getPercent() {
            return (double)this.correct / (double)this.getTotal();
        }
    }

    public static enum ScoreType {
        Correct,
        Incorrect,
        Unanswered;

    }
}

