/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mattacks.SoundCommand;
import java.util.ArrayList;
import java.util.List;

public class TitleState
extends BaseAppState {
    private final String title;
    private final String message;
    private final AppState state;
    private final Action[] actions;
    private Container window;
    private final CloseTitle closer = new CloseTitle();
    private final Starter starter = new Starter();
    private final List<AppState> joined = new ArrayList<AppState>();
    private Button start;
    private float time;
    private float totalTime;
    private SoundCommand ping1;
    private SoundCommand ping2;

    public TitleState(String title, String message, AppState state, float duration, Action ... actions) {
        this.title = title;
        this.message = message;
        this.state = state;
        this.time = duration;
        this.totalTime = duration;
        this.actions = actions;
    }

    public void addJoined(AppState state) {
        this.joined.add(state);
    }

    @Override
    protected void initialize(Application app) {
        this.window = new Container(new ElementId("window.container"));
        this.window.addChild(new Label(this.title, new ElementId("window.title.label")), new Object[0]);
        this.window.addChild(new Label(this.message), new Object[0]);
        Container buttons = this.window.addChild(new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y), new ElementId("window.buttons.container")), new Object[0]);
        if (this.actions != null && this.actions.length > 0) {
            for (Action a : this.actions) {
                if (a == null) continue;
                buttons.addChild(new ActionButton(a), new Object[0]).addClickCommands(this.closer);
            }
        } else {
            this.start = buttons.addChild(new Button("Ready..."), new Object[0]);
            this.start.addClickCommands(this.starter);
        }
        this.ping1 = SoundCommand.create(app.getAssetManager(), "Sounds/zap1.ogg", true);
        this.ping2 = SoundCommand.create(app.getAssetManager(), "Sounds/zap2.ogg", true);
    }

    protected void start() {
        this.getStateManager().detach(this);
        if (this.state != null) {
            this.getStateManager().attach(this.state);
        }
    }

    @Override
    protected void cleanup(Application app) {
        this.window = null;
        for (AppState a : this.joined) {
            this.getStateManager().detach(a);
        }
    }

    @Override
    public void update(float tpf) {
        if (this.actions == null || this.actions.length == 0) {
            this.time -= tpf;
            if (this.start != null) {
                String text;
                if (this.time >= this.totalTime * 0.33f && this.time < this.totalTime * 0.66f) {
                    String text2 = "Set...";
                    if (!text2.equals(this.start.getText())) {
                        this.start.setText(text2);
                        this.ping1.execute(this.start);
                    }
                } else if (this.time < this.totalTime * 0.33f && !(text = "Go!").equals(this.start.getText())) {
                    this.start.setText(text);
                    this.ping2.execute(this.start);
                }
            }
            if (this.time < 0.0f) {
                this.start();
            }
        }
    }

    @Override
    protected void onEnable() {
        if (this.start != null) {
            this.ping1.execute(this.start);
        }
        this.window.runEffect("open");
    }

    @Override
    protected void onDisable() {
        this.window.runEffect("close");
    }

    private class Starter
    implements Command<Button> {
        private Starter() {
        }

        @Override
        public void execute(Button source) {
            TitleState.this.start();
        }
    }

    private class CloseTitle
    implements Command<Button> {
        private CloseTitle() {
        }

        @Override
        public void execute(Button source) {
            TitleState.this.getStateManager().detach(TitleState.this);
        }
    }
}

