/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.achievement;

import com.simsilica.mattacks.achievement.AchievementRule;
import com.simsilica.mattacks.achievement.AchievementType;
import java.util.Objects;

public class Achievement {
    public AchievementType type;
    public String name;
    public String description;
    public String level;
    public String category;
    public String day;
    public String week;
    public String month;
    public int score;
    public int scoreMultiplier;

    public Achievement() {
    }

    public Achievement(AchievementType type, String name) {
        this.type = type;
        this.name = name;
    }

    public boolean matches(AchievementRule rule, String thisWeek, String today) {
        if (this.type != rule.getType()) {
            return false;
        }
        if (!Objects.equals(this.name, rule.getName())) {
            return false;
        }
        if (this.day != null && !Objects.equals(this.day, today)) {
            return false;
        }
        return this.week == null || Objects.equals(this.week, this.week);
    }

    public String getId() {
        switch (this.type) {
            case Level: {
                return this.day + ":" + this.category + ":" + this.level;
            }
            case Category: {
                return this.day + ":" + this.category;
            }
            case Daily: {
                return this.day;
            }
            case Monthly: {
                return this.day;
            }
        }
        return "Unknown";
    }

    public String getTypeTitle() {
        switch (this.type) {
            case Level: {
                return this.category + ":" + this.level;
            }
            case Category: {
                return "Category:" + this.category;
            }
            case Daily: {
                return "Daily";
            }
            case Monthly: {
                return "Monthly";
            }
        }
        return "Unknown";
    }

    public String getFullLevel() {
        if (this.category == null || this.level == null) {
            return null;
        }
        return this.category + ":" + this.level;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTypeTitle());
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(this.name);
        return sb.toString();
    }

    public int getTotalScore() {
        return this.score * this.scoreMultiplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Achievement other = (Achievement)o;
        if (other.type != this.type) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.level, other.level)) {
            return false;
        }
        if (!Objects.equals(this.category, other.category)) {
            return false;
        }
        if (!Objects.equals(this.day, other.day)) {
            return false;
        }
        if (!Objects.equals(this.month, other.month)) {
            return false;
        }
        return this.score == other.score;
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.type, this.name, this.level, this.category, this.day, this.month, this.score});
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Achievement[");
        sb.append("type=");
        sb.append((Object)this.type);
        sb.append(", name=");
        sb.append(this.name);
        if (this.month != null) {
            sb.append(", month=");
            sb.append(this.month);
        }
        if (this.day != null) {
            sb.append(", day=");
            sb.append(this.day);
        }
        if (this.category != null) {
            sb.append(", category=");
            sb.append(this.category);
        }
        if (this.level != null) {
            sb.append(", level=");
            sb.append(this.level);
        }
        sb.append(", score=");
        sb.append(this.score);
        sb.append(", scoreMultiplier=");
        sb.append(this.scoreMultiplier);
        sb.append("]");
        return sb.toString();
    }
}

