/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.achievement;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mattacks.achievement.Achievement;
import com.simsilica.mattacks.achievement.AchievementRule;
import com.simsilica.mattacks.achievement.AchievementType;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class Achievements
extends AbstractSet<Achievement>
implements VersionedObject<Achievements> {
    private final Set<Achievement> set = new HashSet<Achievement>();
    private final Multimap<AchievementType, Achievement> index = ArrayListMultimap.create();
    private long version;

    public boolean hasProductFor(AchievementRule rule, String week, String day) {
        for (Achievement a : this.set) {
            if (!a.matches(rule, week, day)) continue;
            return true;
        }
        return false;
    }

    public Collection<Achievement> getType(AchievementType type) {
        return this.index.get(type);
    }

    public Achievement getLevelAchievement(String category, String level, String day) {
        Achievement best = null;
        for (Achievement a : this.index.get(AchievementType.Level)) {
            if (!Objects.equals(category, a.category) || !Objects.equals(level, a.level) || !Objects.equals(day, a.day) || best != null && a.score <= best.score) continue;
            best = a;
        }
        return best;
    }

    public Achievement getCategoryAchievement(String category, String day) {
        Achievement best = null;
        for (Achievement a : this.index.get(AchievementType.Category)) {
            if (!Objects.equals(category, a.category) || !Objects.equals(day, a.day) || best != null && a.score <= best.score) continue;
            best = a;
        }
        return best;
    }

    @Override
    public boolean add(Achievement a) {
        if (this.set.add(a)) {
            this.index.put(a.type, a);
            ++this.version;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.index.clear();
        ++this.version;
    }

    @Override
    public Iterator<Achievement> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public Achievements getObject() {
        return this;
    }

    @Override
    public VersionedReference<Achievements> createReference() {
        return new VersionedReference<Achievements>(this);
    }
}

