/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mattacks.es;

import com.simsilica.es.EntityComponent;
import com.simsilica.mattacks.es.Answer;
import java.util.Objects;

public class FlashCard
implements EntityComponent {
    private final int opA;
    private final int opB;
    private final int answer;
    private final String operator;

    public FlashCard(int opA, int opB, int answer, String operator) {
        this.opA = opA;
        this.opB = opB;
        this.answer = answer;
        this.operator = operator;
    }

    public static FlashCard add(int opA, int opB) {
        return new FlashCard(opA, opB, opA + opB, "+");
    }

    public static FlashCard subtract(int opA, int opB) {
        return new FlashCard(opA, opB, opA - opB, "-");
    }

    public static FlashCard multiply(int opA, int opB) {
        return new FlashCard(opA, opB, opA * opB, "x");
    }

    public static FlashCard divide(int opA, int opB) {
        return new FlashCard(opA, opB, opA / opB, String.valueOf('\u00f7'));
    }

    public Answer getCorrectAnswer() {
        return new Answer(this, this.answer);
    }

    public int hashCode() {
        int hash = this.operator.hashCode() * 37;
        return hash += this.opA << 16 | this.opB;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FlashCard other = (FlashCard)o;
        if (!Objects.equals(other.operator, this.operator)) {
            return false;
        }
        if (other.opA != this.opA) {
            return false;
        }
        return other.opB == this.opB;
    }

    public int getOpA() {
        return this.opA;
    }

    public int getOpB() {
        return this.opB;
    }

    public int getAnswer() {
        return this.answer;
    }

    public String getOperator() {
        return this.operator;
    }

    public String toString() {
        return "FlashCard[" + this.opA + " " + this.operator + " " + this.opB + " = " + this.answer + "]";
    }
}

