/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.cache;

import com.jme3.asset.AssetKey;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.WeakRefAssetCache;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakRefCloneAssetCache
implements AssetCache {
    private static final Logger logger = Logger.getLogger(WeakRefAssetCache.class.getName());
    private final ReferenceQueue<AssetKey> refQueue = new ReferenceQueue();
    private final ConcurrentHashMap<AssetKey, AssetRef> smartCache = new ConcurrentHashMap();
    private final ThreadLocal<ArrayList<AssetKey>> assetLoadStack = new ThreadLocal<ArrayList<AssetKey>>(){

        @Override
        protected ArrayList<AssetKey> initialValue() {
            return new ArrayList<AssetKey>();
        }
    };

    private void removeCollectedAssets() {
        KeyRef ref;
        int removedAssets = 0;
        while ((ref = (KeyRef)this.refQueue.poll()) != null) {
            AssetKey key = ref.clonedKey;
            if (this.smartCache.remove(key) == null) continue;
            ++removedAssets;
        }
        if (removedAssets >= 1) {
            logger.log(Level.FINE, "WeakRefAssetCache: {0} assets were purged from the cache.", removedAssets);
        }
    }

    @Override
    public <T> void addToCache(AssetKey<T> originalKey, T obj) {
        this.removeCollectedAssets();
        CloneableSmartAsset asset = (CloneableSmartAsset)obj;
        asset.setKey(null);
        KeyRef ref = new KeyRef(originalKey, this.refQueue);
        this.smartCache.put(ref.clonedKey, new AssetRef(asset, originalKey));
        ArrayList<AssetKey> loadStack = this.assetLoadStack.get();
        loadStack.add(originalKey);
    }

    @Override
    public <T> void registerAssetClone(AssetKey<T> key, T clone) {
        ArrayList<AssetKey> loadStack = this.assetLoadStack.get();
        ((CloneableSmartAsset)clone).setKey(loadStack.remove(loadStack.size() - 1));
    }

    @Override
    public void notifyNoAssetClone() {
        ArrayList<AssetKey> loadStack = this.assetLoadStack.get();
        loadStack.remove(loadStack.size() - 1);
    }

    @Override
    public <T> T getFromCache(AssetKey<T> key) {
        AssetRef smartInfo = this.smartCache.get(key);
        if (smartInfo == null) {
            return null;
        }
        AssetKey keyForTheClone = (AssetKey)smartInfo.get();
        if (keyForTheClone == null) {
            return null;
        }
        ArrayList<AssetKey> loadStack = this.assetLoadStack.get();
        loadStack.add(keyForTheClone);
        return (T)smartInfo.asset;
    }

    @Override
    public boolean deleteFromCache(AssetKey key) {
        ArrayList<AssetKey> loadStack = this.assetLoadStack.get();
        if (!loadStack.isEmpty()) {
            throw new UnsupportedOperationException("Cache cannot be modifiedwhile assets are being loaded");
        }
        return this.smartCache.remove(key) != null;
    }

    @Override
    public void clearCache() {
        ArrayList<AssetKey> loadStack = this.assetLoadStack.get();
        if (!loadStack.isEmpty()) {
            throw new UnsupportedOperationException("Cache cannot be modifiedwhile assets are being loaded");
        }
        this.smartCache.clear();
    }

    private static final class AssetRef
    extends WeakReference<AssetKey> {
        CloneableSmartAsset asset;

        public AssetRef(CloneableSmartAsset originalAsset, AssetKey originalKey) {
            super(originalKey);
            this.asset = originalAsset;
        }
    }

    private static final class KeyRef
    extends PhantomReference<AssetKey> {
        AssetKey clonedKey;

        public KeyRef(AssetKey originalKey, ReferenceQueue<AssetKey> refQueue) {
            super(originalKey, refQueue);
            this.clonedKey = originalKey.clone();
        }
    }
}

