/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class RenderState
implements Cloneable,
Savable {
    public static final RenderState DEFAULT = new RenderState();
    public static final RenderState NULL = new RenderState();
    public static final RenderState ADDITIONAL = new RenderState();
    boolean pointSprite = false;
    boolean applyPointSprite = true;
    boolean wireframe = false;
    boolean applyWireFrame = true;
    FaceCullMode cullMode = FaceCullMode.Back;
    boolean applyCullMode = true;
    boolean depthWrite = true;
    boolean applyDepthWrite = true;
    boolean depthTest = true;
    boolean applyDepthTest = true;
    boolean colorWrite = true;
    boolean applyColorWrite = true;
    BlendMode blendMode = BlendMode.Off;
    boolean applyBlendMode = true;
    boolean alphaTest = false;
    boolean applyAlphaTest = true;
    float alphaFallOff = 0.0f;
    boolean applyAlphaFallOff = true;
    float offsetFactor = 0.0f;
    float offsetUnits = 0.0f;
    boolean offsetEnabled = false;
    boolean applyPolyOffset = true;
    boolean stencilTest = false;
    boolean applyStencilTest = false;
    TestFunction depthFunc = TestFunction.LessOrEqual;
    boolean applyDepthFunc = false;
    TestFunction alphaFunc = TestFunction.Greater;
    boolean applyAlphaFunc = false;
    StencilOperation frontStencilStencilFailOperation = StencilOperation.Keep;
    StencilOperation frontStencilDepthFailOperation = StencilOperation.Keep;
    StencilOperation frontStencilDepthPassOperation = StencilOperation.Keep;
    StencilOperation backStencilStencilFailOperation = StencilOperation.Keep;
    StencilOperation backStencilDepthFailOperation = StencilOperation.Keep;
    StencilOperation backStencilDepthPassOperation = StencilOperation.Keep;
    TestFunction frontStencilFunction = TestFunction.Always;
    TestFunction backStencilFunction = TestFunction.Always;
    int cachedHashCode = -1;

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.pointSprite, "pointSprite", false);
        oc.write(this.wireframe, "wireframe", false);
        oc.write(this.cullMode, "cullMode", FaceCullMode.Back);
        oc.write(this.depthWrite, "depthWrite", true);
        oc.write(this.depthTest, "depthTest", true);
        oc.write(this.colorWrite, "colorWrite", true);
        oc.write(this.blendMode, "blendMode", BlendMode.Off);
        oc.write(this.alphaTest, "alphaTest", false);
        oc.write(this.alphaFallOff, "alphaFallOff", 0.0f);
        oc.write(this.offsetEnabled, "offsetEnabled", false);
        oc.write(this.offsetFactor, "offsetFactor", 0.0f);
        oc.write(this.offsetUnits, "offsetUnits", 0.0f);
        oc.write(this.stencilTest, "stencilTest", false);
        oc.write(this.frontStencilStencilFailOperation, "frontStencilStencilFailOperation", StencilOperation.Keep);
        oc.write(this.frontStencilDepthFailOperation, "frontStencilDepthFailOperation", StencilOperation.Keep);
        oc.write(this.frontStencilDepthPassOperation, "frontStencilDepthPassOperation", StencilOperation.Keep);
        oc.write(this.backStencilStencilFailOperation, "frontStencilStencilFailOperation", StencilOperation.Keep);
        oc.write(this.backStencilDepthFailOperation, "backStencilDepthFailOperation", StencilOperation.Keep);
        oc.write(this.backStencilDepthPassOperation, "backStencilDepthPassOperation", StencilOperation.Keep);
        oc.write(this.frontStencilFunction, "frontStencilFunction", TestFunction.Always);
        oc.write(this.backStencilFunction, "backStencilFunction", TestFunction.Always);
        oc.write(this.applyPointSprite, "applyPointSprite", true);
        oc.write(this.applyWireFrame, "applyWireFrame", true);
        oc.write(this.applyCullMode, "applyCullMode", true);
        oc.write(this.applyDepthWrite, "applyDepthWrite", true);
        oc.write(this.applyDepthTest, "applyDepthTest", true);
        oc.write(this.applyColorWrite, "applyColorWrite", true);
        oc.write(this.applyBlendMode, "applyBlendMode", true);
        oc.write(this.applyAlphaTest, "applyAlphaTest", true);
        oc.write(this.applyAlphaFallOff, "applyAlphaFallOff", true);
        oc.write(this.applyPolyOffset, "applyPolyOffset", true);
        oc.write(this.applyDepthFunc, "applyDepthFunc", true);
        oc.write(this.applyAlphaFunc, "applyAlphaFunc", false);
        oc.write(this.depthFunc, "depthFunc", TestFunction.LessOrEqual);
        oc.write(this.alphaFunc, "alphaFunc", TestFunction.Greater);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.pointSprite = ic.readBoolean("pointSprite", false);
        this.wireframe = ic.readBoolean("wireframe", false);
        this.cullMode = ic.readEnum("cullMode", FaceCullMode.class, FaceCullMode.Back);
        this.depthWrite = ic.readBoolean("depthWrite", true);
        this.depthTest = ic.readBoolean("depthTest", true);
        this.colorWrite = ic.readBoolean("colorWrite", true);
        this.blendMode = ic.readEnum("blendMode", BlendMode.class, BlendMode.Off);
        this.alphaTest = ic.readBoolean("alphaTest", false);
        this.alphaFallOff = ic.readFloat("alphaFallOff", 0.0f);
        this.offsetEnabled = ic.readBoolean("offsetEnabled", false);
        this.offsetFactor = ic.readFloat("offsetFactor", 0.0f);
        this.offsetUnits = ic.readFloat("offsetUnits", 0.0f);
        this.stencilTest = ic.readBoolean("stencilTest", false);
        this.frontStencilStencilFailOperation = ic.readEnum("frontStencilStencilFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilDepthFailOperation = ic.readEnum("frontStencilDepthFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilDepthPassOperation = ic.readEnum("frontStencilDepthPassOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilStencilFailOperation = ic.readEnum("backStencilStencilFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilDepthFailOperation = ic.readEnum("backStencilDepthFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilDepthPassOperation = ic.readEnum("backStencilDepthPassOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilFunction = ic.readEnum("frontStencilFunction", TestFunction.class, TestFunction.Always);
        this.backStencilFunction = ic.readEnum("backStencilFunction", TestFunction.class, TestFunction.Always);
        this.depthFunc = ic.readEnum("depthFunc", TestFunction.class, TestFunction.LessOrEqual);
        this.alphaFunc = ic.readEnum("alphaFunc", TestFunction.class, TestFunction.Greater);
        this.applyPointSprite = ic.readBoolean("applyPointSprite", true);
        this.applyWireFrame = ic.readBoolean("applyWireFrame", true);
        this.applyCullMode = ic.readBoolean("applyCullMode", true);
        this.applyDepthWrite = ic.readBoolean("applyDepthWrite", true);
        this.applyDepthTest = ic.readBoolean("applyDepthTest", true);
        this.applyColorWrite = ic.readBoolean("applyColorWrite", true);
        this.applyBlendMode = ic.readBoolean("applyBlendMode", true);
        this.applyAlphaTest = ic.readBoolean("applyAlphaTest", true);
        this.applyAlphaFallOff = ic.readBoolean("applyAlphaFallOff", true);
        this.applyPolyOffset = ic.readBoolean("applyPolyOffset", true);
        this.applyDepthFunc = ic.readBoolean("applyDepthFunc", true);
        this.applyAlphaFunc = ic.readBoolean("applyAlphaFunc", false);
    }

    public RenderState clone() {
        try {
            return (RenderState)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RenderState)) {
            return false;
        }
        RenderState rs = (RenderState)o;
        if (this.pointSprite != rs.pointSprite) {
            return false;
        }
        if (this.wireframe != rs.wireframe) {
            return false;
        }
        if (this.cullMode != rs.cullMode) {
            return false;
        }
        if (this.depthWrite != rs.depthWrite) {
            return false;
        }
        if (this.depthTest != rs.depthTest) {
            return false;
        }
        if (this.depthTest && this.depthFunc != rs.depthFunc) {
            return false;
        }
        if (this.colorWrite != rs.colorWrite) {
            return false;
        }
        if (this.blendMode != rs.blendMode) {
            return false;
        }
        if (this.alphaTest != rs.alphaTest) {
            return false;
        }
        if (this.alphaTest && this.alphaFunc != rs.alphaFunc) {
            return false;
        }
        if (this.alphaFallOff != rs.alphaFallOff) {
            return false;
        }
        if (this.offsetEnabled != rs.offsetEnabled) {
            return false;
        }
        if (this.offsetFactor != rs.offsetFactor) {
            return false;
        }
        if (this.offsetUnits != rs.offsetUnits) {
            return false;
        }
        if (this.stencilTest != rs.stencilTest) {
            return false;
        }
        if (this.stencilTest) {
            if (this.frontStencilStencilFailOperation != rs.frontStencilStencilFailOperation) {
                return false;
            }
            if (this.frontStencilDepthFailOperation != rs.frontStencilDepthFailOperation) {
                return false;
            }
            if (this.frontStencilDepthPassOperation != rs.frontStencilDepthPassOperation) {
                return false;
            }
            if (this.backStencilStencilFailOperation != rs.backStencilStencilFailOperation) {
                return false;
            }
            if (this.backStencilDepthFailOperation != rs.backStencilDepthFailOperation) {
                return false;
            }
            if (this.backStencilDepthPassOperation != rs.backStencilDepthPassOperation) {
                return false;
            }
            if (this.frontStencilFunction != rs.frontStencilFunction) {
                return false;
            }
            if (this.backStencilFunction != rs.backStencilFunction) {
                return false;
            }
        }
        return true;
    }

    public void setPointSprite(boolean pointSprite) {
        this.applyPointSprite = true;
        this.pointSprite = pointSprite;
        this.cachedHashCode = -1;
    }

    public void setAlphaFallOff(float alphaFallOff) {
        this.applyAlphaFallOff = true;
        this.alphaFallOff = alphaFallOff;
        this.cachedHashCode = -1;
    }

    public void setAlphaTest(boolean alphaTest) {
        this.applyAlphaTest = true;
        this.alphaTest = alphaTest;
        this.cachedHashCode = -1;
    }

    public void setColorWrite(boolean colorWrite) {
        this.applyColorWrite = true;
        this.colorWrite = colorWrite;
        this.cachedHashCode = -1;
    }

    public void setFaceCullMode(FaceCullMode cullMode) {
        this.applyCullMode = true;
        this.cullMode = cullMode;
        this.cachedHashCode = -1;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.applyBlendMode = true;
        this.blendMode = blendMode;
        this.cachedHashCode = -1;
    }

    public void setDepthTest(boolean depthTest) {
        this.applyDepthTest = true;
        this.depthTest = depthTest;
        this.cachedHashCode = -1;
    }

    public void setDepthWrite(boolean depthWrite) {
        this.applyDepthWrite = true;
        this.depthWrite = depthWrite;
        this.cachedHashCode = -1;
    }

    public void setWireframe(boolean wireframe) {
        this.applyWireFrame = true;
        this.wireframe = wireframe;
        this.cachedHashCode = -1;
    }

    public void setPolyOffset(float factor, float units) {
        this.applyPolyOffset = true;
        if (factor == 0.0f && units == 0.0f) {
            this.offsetEnabled = false;
        } else {
            this.offsetEnabled = true;
            this.offsetFactor = factor;
            this.offsetUnits = units;
        }
        this.cachedHashCode = -1;
    }

    public void setStencil(boolean enabled, StencilOperation _frontStencilStencilFailOperation, StencilOperation _frontStencilDepthFailOperation, StencilOperation _frontStencilDepthPassOperation, StencilOperation _backStencilStencilFailOperation, StencilOperation _backStencilDepthFailOperation, StencilOperation _backStencilDepthPassOperation, TestFunction _frontStencilFunction, TestFunction _backStencilFunction) {
        this.stencilTest = enabled;
        this.applyStencilTest = true;
        this.frontStencilStencilFailOperation = _frontStencilStencilFailOperation;
        this.frontStencilDepthFailOperation = _frontStencilDepthFailOperation;
        this.frontStencilDepthPassOperation = _frontStencilDepthPassOperation;
        this.backStencilStencilFailOperation = _backStencilStencilFailOperation;
        this.backStencilDepthFailOperation = _backStencilDepthFailOperation;
        this.backStencilDepthPassOperation = _backStencilDepthPassOperation;
        this.frontStencilFunction = _frontStencilFunction;
        this.backStencilFunction = _backStencilFunction;
        this.cachedHashCode = -1;
    }

    public void setDepthFunc(TestFunction depthFunc) {
        this.applyDepthFunc = true;
        this.depthFunc = depthFunc;
        this.cachedHashCode = -1;
    }

    public void setAlphaFunc(TestFunction alphaFunc) {
        this.applyAlphaFunc = true;
        this.alphaFunc = alphaFunc;
        this.cachedHashCode = -1;
    }

    public boolean isStencilTest() {
        return this.stencilTest;
    }

    public StencilOperation getFrontStencilStencilFailOperation() {
        return this.frontStencilStencilFailOperation;
    }

    public StencilOperation getFrontStencilDepthFailOperation() {
        return this.frontStencilDepthFailOperation;
    }

    public StencilOperation getFrontStencilDepthPassOperation() {
        return this.frontStencilDepthPassOperation;
    }

    public StencilOperation getBackStencilStencilFailOperation() {
        return this.backStencilStencilFailOperation;
    }

    public StencilOperation getBackStencilDepthFailOperation() {
        return this.backStencilDepthFailOperation;
    }

    public StencilOperation getBackStencilDepthPassOperation() {
        return this.backStencilDepthPassOperation;
    }

    public TestFunction getFrontStencilFunction() {
        return this.frontStencilFunction;
    }

    public TestFunction getBackStencilFunction() {
        return this.backStencilFunction;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public boolean isPointSprite() {
        return this.pointSprite;
    }

    public boolean isAlphaTest() {
        return this.alphaTest;
    }

    public FaceCullMode getFaceCullMode() {
        return this.cullMode;
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public boolean isDepthWrite() {
        return this.depthWrite;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public boolean isColorWrite() {
        return this.colorWrite;
    }

    public float getPolyOffsetFactor() {
        return this.offsetFactor;
    }

    public float getPolyOffsetUnits() {
        return this.offsetUnits;
    }

    public boolean isPolyOffset() {
        return this.offsetEnabled;
    }

    public float getAlphaFallOff() {
        return this.alphaFallOff;
    }

    public TestFunction getDepthFunc() {
        return this.depthFunc;
    }

    public TestFunction getAlphaFunc() {
        return this.alphaFunc;
    }

    public boolean isApplyAlphaFallOff() {
        return this.applyAlphaFallOff;
    }

    public boolean isApplyAlphaTest() {
        return this.applyAlphaTest;
    }

    public boolean isApplyBlendMode() {
        return this.applyBlendMode;
    }

    public boolean isApplyColorWrite() {
        return this.applyColorWrite;
    }

    public boolean isApplyCullMode() {
        return this.applyCullMode;
    }

    public boolean isApplyDepthTest() {
        return this.applyDepthTest;
    }

    public boolean isApplyDepthWrite() {
        return this.applyDepthWrite;
    }

    public boolean isApplyPointSprite() {
        return this.applyPointSprite;
    }

    public boolean isApplyPolyOffset() {
        return this.applyPolyOffset;
    }

    public boolean isApplyWireFrame() {
        return this.applyWireFrame;
    }

    public boolean isApplyDepthFunc() {
        return this.applyDepthFunc;
    }

    public boolean isApplyAlphaFunc() {
        return this.applyAlphaFunc;
    }

    public int contentHashCode() {
        if (this.cachedHashCode == -1) {
            int hash = 7;
            hash = 79 * hash + (this.pointSprite ? 1 : 0);
            hash = 79 * hash + (this.wireframe ? 1 : 0);
            hash = 79 * hash + (this.cullMode != null ? this.cullMode.hashCode() : 0);
            hash = 79 * hash + (this.depthWrite ? 1 : 0);
            hash = 79 * hash + (this.depthTest ? 1 : 0);
            hash = 79 * hash + (this.depthFunc != null ? this.depthFunc.hashCode() : 0);
            hash = 79 * hash + (this.colorWrite ? 1 : 0);
            hash = 79 * hash + (this.blendMode != null ? this.blendMode.hashCode() : 0);
            hash = 79 * hash + (this.alphaTest ? 1 : 0);
            hash = 79 * hash + (this.alphaFunc != null ? this.alphaFunc.hashCode() : 0);
            hash = 79 * hash + Float.floatToIntBits(this.alphaFallOff);
            hash = 79 * hash + Float.floatToIntBits(this.offsetFactor);
            hash = 79 * hash + Float.floatToIntBits(this.offsetUnits);
            hash = 79 * hash + (this.offsetEnabled ? 1 : 0);
            hash = 79 * hash + (this.stencilTest ? 1 : 0);
            hash = 79 * hash + (this.frontStencilStencilFailOperation != null ? this.frontStencilStencilFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.frontStencilDepthFailOperation != null ? this.frontStencilDepthFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.frontStencilDepthPassOperation != null ? this.frontStencilDepthPassOperation.hashCode() : 0);
            hash = 79 * hash + (this.backStencilStencilFailOperation != null ? this.backStencilStencilFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.backStencilDepthFailOperation != null ? this.backStencilDepthFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.backStencilDepthPassOperation != null ? this.backStencilDepthPassOperation.hashCode() : 0);
            hash = 79 * hash + (this.frontStencilFunction != null ? this.frontStencilFunction.hashCode() : 0);
            this.cachedHashCode = hash = 79 * hash + (this.backStencilFunction != null ? this.backStencilFunction.hashCode() : 0);
        }
        return this.cachedHashCode;
    }

    public RenderState copyMergedTo(RenderState additionalState, RenderState state) {
        if (additionalState == null) {
            return this;
        }
        state.pointSprite = additionalState.applyPointSprite ? additionalState.pointSprite : this.pointSprite;
        state.wireframe = additionalState.applyWireFrame ? additionalState.wireframe : this.wireframe;
        state.cullMode = additionalState.applyCullMode ? additionalState.cullMode : this.cullMode;
        state.depthWrite = additionalState.applyDepthWrite ? additionalState.depthWrite : this.depthWrite;
        state.depthTest = additionalState.applyDepthTest ? additionalState.depthTest : this.depthTest;
        state.depthFunc = additionalState.applyDepthFunc ? additionalState.depthFunc : this.depthFunc;
        state.colorWrite = additionalState.applyColorWrite ? additionalState.colorWrite : this.colorWrite;
        state.blendMode = additionalState.applyBlendMode ? additionalState.blendMode : this.blendMode;
        state.alphaTest = additionalState.applyAlphaTest ? additionalState.alphaTest : this.alphaTest;
        state.alphaFunc = additionalState.applyAlphaFunc ? additionalState.alphaFunc : this.alphaFunc;
        state.alphaFallOff = additionalState.applyAlphaFallOff ? additionalState.alphaFallOff : this.alphaFallOff;
        if (additionalState.applyPolyOffset) {
            state.offsetEnabled = additionalState.offsetEnabled;
            state.offsetFactor = additionalState.offsetFactor;
            state.offsetUnits = additionalState.offsetUnits;
        } else {
            state.offsetEnabled = this.offsetEnabled;
            state.offsetFactor = this.offsetFactor;
            state.offsetUnits = this.offsetUnits;
        }
        if (additionalState.applyStencilTest) {
            state.stencilTest = additionalState.stencilTest;
            state.frontStencilStencilFailOperation = additionalState.frontStencilStencilFailOperation;
            state.frontStencilDepthFailOperation = additionalState.frontStencilDepthFailOperation;
            state.frontStencilDepthPassOperation = additionalState.frontStencilDepthPassOperation;
            state.backStencilStencilFailOperation = additionalState.backStencilStencilFailOperation;
            state.backStencilDepthFailOperation = additionalState.backStencilDepthFailOperation;
            state.backStencilDepthPassOperation = additionalState.backStencilDepthPassOperation;
            state.frontStencilFunction = additionalState.frontStencilFunction;
            state.backStencilFunction = additionalState.backStencilFunction;
        } else {
            state.stencilTest = this.stencilTest;
            state.frontStencilStencilFailOperation = this.frontStencilStencilFailOperation;
            state.frontStencilDepthFailOperation = this.frontStencilDepthFailOperation;
            state.frontStencilDepthPassOperation = this.frontStencilDepthPassOperation;
            state.backStencilStencilFailOperation = this.backStencilStencilFailOperation;
            state.backStencilDepthFailOperation = this.backStencilDepthFailOperation;
            state.backStencilDepthPassOperation = this.backStencilDepthPassOperation;
            state.frontStencilFunction = this.frontStencilFunction;
            state.backStencilFunction = this.backStencilFunction;
        }
        state.cachedHashCode = -1;
        return state;
    }

    public void set(RenderState state) {
        this.pointSprite = state.pointSprite;
        this.wireframe = state.wireframe;
        this.cullMode = state.cullMode;
        this.depthWrite = state.depthWrite;
        this.depthTest = state.depthTest;
        this.colorWrite = state.colorWrite;
        this.blendMode = state.blendMode;
        this.alphaTest = state.alphaTest;
        this.alphaFallOff = state.alphaFallOff;
        this.offsetEnabled = state.offsetEnabled;
        this.offsetFactor = state.offsetFactor;
        this.offsetUnits = state.offsetUnits;
        this.stencilTest = state.stencilTest;
        this.frontStencilStencilFailOperation = state.frontStencilStencilFailOperation;
        this.frontStencilDepthFailOperation = state.frontStencilDepthFailOperation;
        this.frontStencilDepthPassOperation = state.frontStencilDepthPassOperation;
        this.backStencilStencilFailOperation = state.backStencilStencilFailOperation;
        this.backStencilDepthFailOperation = state.backStencilDepthFailOperation;
        this.backStencilDepthPassOperation = state.backStencilDepthPassOperation;
        this.frontStencilFunction = state.frontStencilFunction;
        this.backStencilFunction = state.backStencilFunction;
        this.depthFunc = state.depthFunc;
        this.alphaFunc = state.alphaFunc;
        this.applyPointSprite = true;
        this.applyWireFrame = true;
        this.applyCullMode = true;
        this.applyDepthWrite = true;
        this.applyDepthTest = true;
        this.applyColorWrite = true;
        this.applyBlendMode = true;
        this.applyAlphaTest = true;
        this.applyAlphaFallOff = true;
        this.applyPolyOffset = true;
        this.applyDepthFunc = true;
        this.applyAlphaFunc = false;
    }

    public String toString() {
        return "RenderState[\npointSprite=" + this.pointSprite + "\napplyPointSprite=" + this.applyPointSprite + "\nwireframe=" + this.wireframe + "\napplyWireFrame=" + this.applyWireFrame + "\ncullMode=" + (Object)((Object)this.cullMode) + "\napplyCullMode=" + this.applyCullMode + "\ndepthWrite=" + this.depthWrite + "\napplyDepthWrite=" + this.applyDepthWrite + "\ndepthTest=" + this.depthTest + "\ndepthFunc=" + (Object)((Object)this.depthFunc) + "\napplyDepthTest=" + this.applyDepthTest + "\ncolorWrite=" + this.colorWrite + "\napplyColorWrite=" + this.applyColorWrite + "\nblendMode=" + (Object)((Object)this.blendMode) + "\napplyBlendMode=" + this.applyBlendMode + "\nalphaTest=" + this.alphaTest + "\nalphaFunc=" + (Object)((Object)this.alphaFunc) + "\napplyAlphaTest=" + this.applyAlphaTest + "\nalphaFallOff=" + this.alphaFallOff + "\napplyAlphaFallOff=" + this.applyAlphaFallOff + "\noffsetEnabled=" + this.offsetEnabled + "\napplyPolyOffset=" + this.applyPolyOffset + "\noffsetFactor=" + this.offsetFactor + "\noffsetUnits=" + this.offsetUnits + "\n]";
    }

    static {
        RenderState.NULL.cullMode = FaceCullMode.Off;
        RenderState.NULL.depthTest = false;
        RenderState.ADDITIONAL.applyPointSprite = false;
        RenderState.ADDITIONAL.applyWireFrame = false;
        RenderState.ADDITIONAL.applyCullMode = false;
        RenderState.ADDITIONAL.applyDepthWrite = false;
        RenderState.ADDITIONAL.applyDepthTest = false;
        RenderState.ADDITIONAL.applyColorWrite = false;
        RenderState.ADDITIONAL.applyBlendMode = false;
        RenderState.ADDITIONAL.applyAlphaTest = false;
        RenderState.ADDITIONAL.applyAlphaFallOff = false;
        RenderState.ADDITIONAL.applyPolyOffset = false;
    }

    public static enum BlendMode {
        Off,
        Additive,
        PremultAlpha,
        AlphaAdditive,
        Color,
        Alpha,
        Modulate,
        ModulateX2,
        Screen,
        Exclusion;

    }

    public static enum FaceCullMode {
        Off,
        Front,
        Back,
        FrontAndBack;

    }

    public static enum StencilOperation {
        Keep,
        Zero,
        Replace,
        Increment,
        IncrementWrap,
        Decrement,
        DecrementWrap,
        Invert;

    }

    public static enum TestFunction {
        Never,
        Equal,
        Less,
        LessOrEqual,
        Greater,
        GreaterOrEqual,
        NotEqual,
        Always;

    }
}

