/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.CurveAndSurfaceMath;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Spline
implements Savable {
    private List<Vector3f> controlPoints = new ArrayList<Vector3f>();
    private List<Float> knots;
    private float[] weights;
    private int basisFunctionDegree;
    private boolean cycle;
    private List<Float> segmentsLength;
    private float totalLength;
    private List<Vector3f> CRcontrolPoints;
    private float curveTension = 0.5f;
    private SplineType type = SplineType.CatmullRom;

    public Spline() {
    }

    public Spline(SplineType splineType, Vector3f[] controlPoints, float curveTension, boolean cycle) {
        if (splineType == SplineType.Nurb) {
            throw new IllegalArgumentException("To create NURBS spline use: 'public Spline(Vector3f[] controlPoints, float[] weights, float[] nurbKnots)' constructor!");
        }
        for (int i = 0; i < controlPoints.length; ++i) {
            Vector3f vector3f = controlPoints[i];
            this.controlPoints.add(vector3f);
        }
        this.type = splineType;
        this.curveTension = curveTension;
        this.cycle = cycle;
        this.computeTotalLentgh();
    }

    public Spline(SplineType splineType, List<Vector3f> controlPoints, float curveTension, boolean cycle) {
        if (splineType == SplineType.Nurb) {
            throw new IllegalArgumentException("To create NURBS spline use: 'public Spline(Vector3f[] controlPoints, float[] weights, float[] nurbKnots)' constructor!");
        }
        this.type = splineType;
        this.controlPoints.addAll(controlPoints);
        this.curveTension = curveTension;
        this.cycle = cycle;
        this.computeTotalLentgh();
    }

    public Spline(List<Vector4f> controlPoints, List<Float> nurbKnots) {
        int i;
        for (i = 0; i < nurbKnots.size() - 1; ++i) {
            if (!(nurbKnots.get(i).floatValue() > nurbKnots.get(i + 1).floatValue())) continue;
            throw new IllegalArgumentException("The knots values cannot decrease!");
        }
        this.type = SplineType.Nurb;
        this.weights = new float[controlPoints.size()];
        this.knots = nurbKnots;
        this.basisFunctionDegree = nurbKnots.size() - this.weights.length;
        for (i = 0; i < controlPoints.size(); ++i) {
            Vector4f controlPoint = controlPoints.get(i);
            this.controlPoints.add(new Vector3f(controlPoint.x, controlPoint.y, controlPoint.z));
            this.weights[i] = controlPoint.w;
        }
        CurveAndSurfaceMath.prepareNurbsKnots(this.knots, this.basisFunctionDegree);
        this.computeTotalLentgh();
    }

    private void initCatmullRomWayPoints(List<Vector3f> list) {
        if (this.CRcontrolPoints == null) {
            this.CRcontrolPoints = new ArrayList<Vector3f>();
        } else {
            this.CRcontrolPoints.clear();
        }
        int nb = list.size() - 1;
        if (this.cycle) {
            this.CRcontrolPoints.add(list.get(list.size() - 2));
        } else {
            this.CRcontrolPoints.add(list.get(0).subtract(list.get(1).subtract(list.get(0))));
        }
        for (Vector3f vector3f : list) {
            this.CRcontrolPoints.add(vector3f);
        }
        if (this.cycle) {
            this.CRcontrolPoints.add(list.get(1));
        } else {
            this.CRcontrolPoints.add(list.get(nb).add(list.get(nb).subtract(list.get(nb - 1))));
        }
    }

    public void addControlPoint(Vector3f controlPoint) {
        if (this.controlPoints.size() > 2 && this.cycle) {
            this.controlPoints.remove(this.controlPoints.size() - 1);
        }
        this.controlPoints.add(controlPoint.clone());
        if (this.controlPoints.size() >= 2 && this.cycle) {
            this.controlPoints.add(this.controlPoints.get(0).clone());
        }
        if (this.controlPoints.size() > 1) {
            this.computeTotalLentgh();
        }
    }

    public void removeControlPoint(Vector3f controlPoint) {
        this.controlPoints.remove(controlPoint);
        if (this.controlPoints.size() > 1) {
            this.computeTotalLentgh();
        }
    }

    public void clearControlPoints() {
        this.controlPoints.clear();
        this.totalLength = 0.0f;
    }

    private void computeTotalLentgh() {
        this.totalLength = 0.0f;
        float l = 0.0f;
        if (this.segmentsLength == null) {
            this.segmentsLength = new ArrayList<Float>();
        } else {
            this.segmentsLength.clear();
        }
        if (this.type == SplineType.Linear) {
            if (this.controlPoints.size() > 1) {
                for (int i = 0; i < this.controlPoints.size() - 1; ++i) {
                    l = this.controlPoints.get(i + 1).subtract(this.controlPoints.get(i)).length();
                    this.segmentsLength.add(Float.valueOf(l));
                    this.totalLength += l;
                }
            }
        } else if (this.type == SplineType.Bezier) {
            this.computeBezierLength();
        } else if (this.type == SplineType.Nurb) {
            this.computeNurbLength();
        } else {
            this.initCatmullRomWayPoints(this.controlPoints);
            this.computeCatmulLength();
        }
    }

    private void computeCatmulLength() {
        float l = 0.0f;
        if (this.controlPoints.size() > 1) {
            for (int i = 0; i < this.controlPoints.size() - 1; ++i) {
                l = FastMath.getCatmullRomP1toP2Length(this.CRcontrolPoints.get(i), this.CRcontrolPoints.get(i + 1), this.CRcontrolPoints.get(i + 2), this.CRcontrolPoints.get(i + 3), 0.0f, 1.0f, this.curveTension);
                this.segmentsLength.add(Float.valueOf(l));
                this.totalLength += l;
            }
        }
    }

    private void computeBezierLength() {
        float l = 0.0f;
        if (this.controlPoints.size() > 1) {
            for (int i = 0; i < this.controlPoints.size() - 1; i += 3) {
                l = FastMath.getBezierP1toP2Length(this.controlPoints.get(i), this.controlPoints.get(i + 1), this.controlPoints.get(i + 2), this.controlPoints.get(i + 3));
                this.segmentsLength.add(Float.valueOf(l));
                this.totalLength += l;
            }
        }
    }

    private void computeNurbLength() {
    }

    public Vector3f interpolate(float value, int currentControlPoint, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        switch (this.type) {
            case CatmullRom: {
                FastMath.interpolateCatmullRom(value, this.curveTension, this.CRcontrolPoints.get(currentControlPoint), this.CRcontrolPoints.get(currentControlPoint + 1), this.CRcontrolPoints.get(currentControlPoint + 2), this.CRcontrolPoints.get(currentControlPoint + 3), store);
                break;
            }
            case Linear: {
                FastMath.interpolateLinear(value, this.controlPoints.get(currentControlPoint), this.controlPoints.get(currentControlPoint + 1), store);
                break;
            }
            case Bezier: {
                FastMath.interpolateBezier(value, this.controlPoints.get(currentControlPoint), this.controlPoints.get(currentControlPoint + 1), this.controlPoints.get(currentControlPoint + 2), this.controlPoints.get(currentControlPoint + 3), store);
                break;
            }
            case Nurb: {
                CurveAndSurfaceMath.interpolateNurbs(value, this, store);
                break;
            }
        }
        return store;
    }

    public float getCurveTension() {
        return this.curveTension;
    }

    public void setCurveTension(float curveTension) {
        this.curveTension = curveTension;
        if (this.type == SplineType.CatmullRom && !this.getControlPoints().isEmpty()) {
            this.computeTotalLentgh();
        }
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        if (this.type != SplineType.Nurb) {
            if (this.controlPoints.size() >= 2) {
                if (this.cycle && !cycle) {
                    this.controlPoints.remove(this.controlPoints.size() - 1);
                }
                if (!this.cycle && cycle) {
                    this.controlPoints.add(this.controlPoints.get(0));
                }
                this.cycle = cycle;
                this.computeTotalLentgh();
            } else {
                this.cycle = cycle;
            }
        }
    }

    public float getTotalLength() {
        return this.totalLength;
    }

    public SplineType getType() {
        return this.type;
    }

    public void setType(SplineType type) {
        this.type = type;
        this.computeTotalLentgh();
    }

    public List<Vector3f> getControlPoints() {
        return this.controlPoints;
    }

    public List<Float> getSegmentsLength() {
        return this.segmentsLength;
    }

    public float getMinNurbKnot() {
        return this.knots.get(this.basisFunctionDegree - 1).floatValue();
    }

    public float getMaxNurbKnot() {
        return this.knots.get(this.weights.length).floatValue();
    }

    public List<Float> getKnots() {
        return this.knots;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public int getBasisFunctionDegree() {
        return this.basisFunctionDegree;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.writeSavableArrayList((ArrayList)this.controlPoints, "controlPoints", null);
        oc.write(this.type, "type", SplineType.CatmullRom);
        float[] list = new float[this.segmentsLength.size()];
        for (int i = 0; i < this.segmentsLength.size(); ++i) {
            list[i] = this.segmentsLength.get(i).floatValue();
        }
        oc.write(list, "segmentsLength", (float[])null);
        oc.write(this.totalLength, "totalLength", 0.0f);
        oc.writeSavableArrayList((ArrayList)this.CRcontrolPoints, "CRControlPoints", null);
        oc.write(this.curveTension, "curveTension", 0.5f);
        oc.write(this.cycle, "cycle", false);
        oc.writeSavableArrayList((ArrayList)this.knots, "knots", null);
        oc.write(this.weights, "weights", (float[])null);
        oc.write(this.basisFunctionDegree, "basisFunctionDegree", 0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.controlPoints = in.readSavableArrayList("wayPoints", null);
        float[] list = in.readFloatArray("segmentsLength", null);
        if (list != null) {
            this.segmentsLength = new ArrayList<Float>();
            for (int i = 0; i < list.length; ++i) {
                this.segmentsLength.add(new Float(list[i]));
            }
        }
        this.type = in.readEnum("pathSplineType", SplineType.class, SplineType.CatmullRom);
        this.totalLength = in.readFloat("totalLength", 0.0f);
        this.CRcontrolPoints = in.readSavableArrayList("CRControlPoints", null);
        this.curveTension = in.readFloat("curveTension", 0.5f);
        this.cycle = in.readBoolean("cycle", false);
        this.knots = in.readSavableArrayList("knots", null);
        this.weights = in.readFloatArray("weights", null);
        this.basisFunctionDegree = in.readInt("basisFunctionDegree", 0);
    }

    public static enum SplineType {
        Linear,
        CatmullRom,
        Bezier,
        Nurb;

    }
}

