/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Camera;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.system.Timer;
import java.util.List;

public class UniformBindingManager {
    private Timer timer;
    private float near;
    private float far;
    private Float time;
    private Float tpf;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private Vector3f camUp = new Vector3f();
    private Vector3f camLeft = new Vector3f();
    private Vector3f camDir = new Vector3f();
    private Vector3f camLoc = new Vector3f();
    private Matrix4f tempMatrix = new Matrix4f();
    private Matrix4f viewMatrix = new Matrix4f();
    private Matrix4f projMatrix = new Matrix4f();
    private Matrix4f viewProjMatrix = new Matrix4f();
    private Matrix4f worldMatrix = new Matrix4f();
    private Matrix4f worldViewMatrix = new Matrix4f();
    private Matrix4f worldViewProjMatrix = new Matrix4f();
    private Matrix3f normalMatrix = new Matrix3f();
    private Matrix4f worldMatrixInv = new Matrix4f();
    private Matrix3f worldMatrixInvTrsp = new Matrix3f();
    private Matrix4f viewMatrixInv = new Matrix4f();
    private Matrix4f projMatrixInv = new Matrix4f();
    private Matrix4f viewProjMatrixInv = new Matrix4f();
    private Matrix4f worldViewMatrixInv = new Matrix4f();
    private Matrix3f normalMatrixInv = new Matrix3f();
    private Matrix4f worldViewProjMatrixInv = new Matrix4f();
    private Vector4f viewPort = new Vector4f();
    private Vector2f resolution = new Vector2f();
    private Vector2f resolutionInv = new Vector2f();
    private Vector2f nearFar = new Vector2f();

    public void updateUniformBindings(List<Uniform> params) {
        block29: for (int i = 0; i < params.size(); ++i) {
            Uniform u = params.get(i);
            switch (u.getBinding()) {
                case WorldMatrix: {
                    u.setValue(VarType.Matrix4, this.worldMatrix);
                    continue block29;
                }
                case ViewMatrix: {
                    u.setValue(VarType.Matrix4, this.viewMatrix);
                    continue block29;
                }
                case ProjectionMatrix: {
                    u.setValue(VarType.Matrix4, this.projMatrix);
                    continue block29;
                }
                case ViewProjectionMatrix: {
                    u.setValue(VarType.Matrix4, this.viewProjMatrix);
                    continue block29;
                }
                case WorldViewMatrix: {
                    this.worldViewMatrix.set(this.viewMatrix);
                    this.worldViewMatrix.multLocal(this.worldMatrix);
                    u.setValue(VarType.Matrix4, this.worldViewMatrix);
                    continue block29;
                }
                case NormalMatrix: {
                    this.tempMatrix.set(this.viewMatrix);
                    this.tempMatrix.multLocal(this.worldMatrix);
                    this.tempMatrix.toRotationMatrix(this.normalMatrix);
                    this.normalMatrix.invertLocal();
                    this.normalMatrix.transposeLocal();
                    u.setValue(VarType.Matrix3, this.normalMatrix);
                    continue block29;
                }
                case WorldViewProjectionMatrix: {
                    this.worldViewProjMatrix.set(this.viewProjMatrix);
                    this.worldViewProjMatrix.multLocal(this.worldMatrix);
                    u.setValue(VarType.Matrix4, this.worldViewProjMatrix);
                    continue block29;
                }
                case WorldMatrixInverse: {
                    this.worldMatrixInv.set(this.worldMatrix);
                    this.worldMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix4, this.worldMatrixInv);
                    continue block29;
                }
                case WorldMatrixInverseTranspose: {
                    this.worldMatrix.toRotationMatrix(this.worldMatrixInvTrsp);
                    this.worldMatrixInvTrsp.invertLocal().transposeLocal();
                    u.setValue(VarType.Matrix3, this.worldMatrixInvTrsp);
                    continue block29;
                }
                case ViewMatrixInverse: {
                    this.viewMatrixInv.set(this.viewMatrix);
                    this.viewMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix4, this.viewMatrixInv);
                    continue block29;
                }
                case ProjectionMatrixInverse: {
                    this.projMatrixInv.set(this.projMatrix);
                    this.projMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix4, this.projMatrixInv);
                    continue block29;
                }
                case ViewProjectionMatrixInverse: {
                    this.viewProjMatrixInv.set(this.viewProjMatrix);
                    this.viewProjMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix4, this.viewProjMatrixInv);
                    continue block29;
                }
                case WorldViewMatrixInverse: {
                    this.worldViewMatrixInv.set(this.viewMatrix);
                    this.worldViewMatrixInv.multLocal(this.worldMatrix);
                    this.worldViewMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix4, this.worldViewMatrixInv);
                    continue block29;
                }
                case NormalMatrixInverse: {
                    this.tempMatrix.set(this.viewMatrix);
                    this.tempMatrix.multLocal(this.worldMatrix);
                    this.tempMatrix.toRotationMatrix(this.normalMatrixInv);
                    this.normalMatrixInv.invertLocal();
                    this.normalMatrixInv.transposeLocal();
                    this.normalMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix3, this.normalMatrixInv);
                    continue block29;
                }
                case WorldViewProjectionMatrixInverse: {
                    this.worldViewProjMatrixInv.set(this.viewProjMatrix);
                    this.worldViewProjMatrixInv.multLocal(this.worldMatrix);
                    this.worldViewProjMatrixInv.invertLocal();
                    u.setValue(VarType.Matrix4, this.worldViewProjMatrixInv);
                    continue block29;
                }
                case ViewPort: {
                    this.viewPort.set(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
                    u.setValue(VarType.Vector4, this.viewPort);
                    continue block29;
                }
                case Resolution: {
                    this.resolution.set(this.viewWidth, this.viewHeight);
                    u.setValue(VarType.Vector2, this.resolution);
                    continue block29;
                }
                case ResolutionInverse: {
                    this.resolutionInv.set(1.0f / (float)this.viewWidth, 1.0f / (float)this.viewHeight);
                    u.setValue(VarType.Vector2, this.resolutionInv);
                    continue block29;
                }
                case Aspect: {
                    float aspect = (float)this.viewWidth / (float)this.viewHeight;
                    u.setValue(VarType.Float, Float.valueOf(aspect));
                    continue block29;
                }
                case FrustumNearFar: {
                    this.nearFar.set(this.near, this.far);
                    u.setValue(VarType.Vector2, this.nearFar);
                    continue block29;
                }
                case CameraPosition: {
                    u.setValue(VarType.Vector3, this.camLoc);
                    continue block29;
                }
                case CameraDirection: {
                    u.setValue(VarType.Vector3, this.camDir);
                    continue block29;
                }
                case CameraLeft: {
                    u.setValue(VarType.Vector3, this.camLeft);
                    continue block29;
                }
                case CameraUp: {
                    u.setValue(VarType.Vector3, this.camUp);
                    continue block29;
                }
                case Time: {
                    u.setValue(VarType.Float, this.time);
                    continue block29;
                }
                case Tpf: {
                    u.setValue(VarType.Float, this.tpf);
                    continue block29;
                }
                case FrameRate: {
                    u.setValue(VarType.Float, Float.valueOf(this.timer.getFrameRate()));
                }
            }
        }
    }

    public void setWorldMatrix(Matrix4f mat) {
        this.worldMatrix.set(mat);
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setCamera(Camera cam, Matrix4f viewMatrix, Matrix4f projMatrix, Matrix4f viewProjMatrix) {
        this.viewMatrix.set(viewMatrix);
        this.projMatrix.set(projMatrix);
        this.viewProjMatrix.set(viewProjMatrix);
        this.camLoc.set(cam.getLocation());
        cam.getLeft(this.camLeft);
        cam.getUp(this.camUp);
        cam.getDirection(this.camDir);
        this.near = cam.getFrustumNear();
        this.far = cam.getFrustumFar();
    }

    public void setViewPort(int viewX, int viewY, int viewWidth, int viewHeight) {
        this.viewX = viewX;
        this.viewY = viewY;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
    }

    public void newFrame() {
        this.time = Float.valueOf(this.timer.getTimeInSeconds());
        this.tpf = Float.valueOf(this.timer.getTimePerFrame());
    }
}

