/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.openal;

import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioParam;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.AudioSource;
import com.jme3.audio.AudioStream;
import com.jme3.audio.Environment;
import com.jme3.audio.Filter;
import com.jme3.audio.Listener;
import com.jme3.audio.ListenerParam;
import com.jme3.audio.LowPassFilter;
import com.jme3.audio.openal.AL;
import com.jme3.audio.openal.ALC;
import com.jme3.audio.openal.EFX;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ALAudioRenderer
implements AudioRenderer,
Runnable {
    private static final Logger logger = Logger.getLogger(ALAudioRenderer.class.getName());
    private static final String THREAD_NAME = "jME3 Audio Decoder";
    private final NativeObjectManager objManager = new NativeObjectManager();
    private static final int BUFFER_SIZE = 35280;
    private static final int STREAMING_BUFFER_COUNT = 5;
    private static final int MAX_NUM_CHANNELS = 64;
    private IntBuffer ib = BufferUtils.createIntBuffer(1);
    private final FloatBuffer fb = BufferUtils.createVector3Buffer(2);
    private final ByteBuffer nativeBuf = BufferUtils.createByteBuffer(35280);
    private final byte[] arrayBuf = new byte[35280];
    private int[] channels;
    private AudioSource[] chanSrcs;
    private int nextChan = 0;
    private final ArrayList<Integer> freeChans = new ArrayList();
    private Listener listener;
    private boolean audioDisabled = false;
    private boolean supportEfx = false;
    private boolean supportPauseDevice = false;
    private int auxSends = 0;
    private int reverbFx = -1;
    private int reverbFxSlot = -1;
    private static final float UPDATE_RATE = 0.05f;
    private final Thread decoderThread = new Thread((Runnable)this, "jME3 Audio Decoder");
    private final Object threadLock = new Object();
    private final AL al;
    private final ALC alc;
    private final EFX efx;

    public ALAudioRenderer(AL al, ALC alc, EFX efx) {
        this.al = al;
        this.alc = alc;
        this.efx = efx;
    }

    private void initOpenAL() {
        int i;
        try {
            if (!this.alc.isCreated()) {
                this.alc.createALC();
            }
        }
        catch (UnsatisfiedLinkError ex) {
            logger.log(Level.SEVERE, "Failed to load audio library", ex);
            this.audioDisabled = true;
            return;
        }
        String deviceName = this.alc.alcGetString(4101);
        logger.log(Level.INFO, "Audio Device: {0}", deviceName);
        logger.log(Level.INFO, "Audio Vendor: {0}", this.al.alGetString(45057));
        logger.log(Level.INFO, "Audio Renderer: {0}", this.al.alGetString(45059));
        logger.log(Level.INFO, "Audio Version: {0}", this.al.alGetString(45058));
        logger.log(Level.INFO, "ALC extensions: {0}", this.alc.alcGetString(4102));
        logger.log(Level.INFO, "AL extensions: {0}", this.al.alGetString(45060));
        ArrayList<Integer> channelList = new ArrayList<Integer>();
        for (i = 0; i < 64; ++i) {
            int chan = this.al.alGenSources();
            if (this.al.alGetError() != 0) break;
            channelList.add(chan);
        }
        this.channels = new int[channelList.size()];
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i] = (Integer)channelList.get(i);
        }
        this.ib = BufferUtils.createIntBuffer(this.channels.length);
        this.chanSrcs = new AudioSource[this.channels.length];
        logger.log(Level.INFO, "AudioRenderer supports {0} channels", this.channels.length);
        this.supportPauseDevice = this.alc.alcIsExtensionPresent("ALC_SOFT_pause_device");
        if (!this.supportPauseDevice) {
            logger.log(Level.WARNING, "Pausing audio device not supported.");
        }
        this.supportEfx = this.alc.alcIsExtensionPresent("ALC_EXT_EFX");
        if (this.supportEfx) {
            this.ib.position(0).limit(1);
            this.alc.alcGetInteger(131073, this.ib, 1);
            int major = this.ib.get(0);
            this.ib.position(0).limit(1);
            this.alc.alcGetInteger(131074, this.ib, 1);
            int minor = this.ib.get(0);
            logger.log(Level.INFO, "Audio effect extension version: {0}.{1}", new Object[]{major, minor});
            this.alc.alcGetInteger(131075, this.ib, 1);
            this.auxSends = this.ib.get(0);
            logger.log(Level.INFO, "Audio max auxilary sends: {0}", this.auxSends);
            this.ib.position(0).limit(1);
            this.efx.alGenAuxiliaryEffectSlots(1, this.ib);
            this.reverbFxSlot = this.ib.get(0);
            this.ib.position(0).limit(1);
            this.efx.alGenEffects(1, this.ib);
            this.reverbFx = this.ib.get(0);
            this.efx.alEffecti(this.reverbFx, 32769, 1);
            this.efx.alAuxiliaryEffectSloti(this.reverbFxSlot, 1, this.reverbFx);
        } else {
            logger.log(Level.WARNING, "OpenAL EFX not available! Audio effects won't work.");
        }
    }

    private void destroyOpenAL() {
        if (this.audioDisabled) {
            this.alc.destroyALC();
            return;
        }
        for (int i = 0; i < this.chanSrcs.length; ++i) {
            if (this.chanSrcs[i] == null) continue;
            this.clearChannel(i);
        }
        this.ib.clear();
        this.ib.put(this.channels);
        this.ib.flip();
        this.al.alDeleteSources(this.channels.length, this.ib);
        this.objManager.deleteAllObjects(this);
        if (this.supportEfx) {
            this.ib.position(0).limit(1);
            this.ib.put(0, this.reverbFx);
            this.efx.alDeleteEffects(1, this.ib);
            this.ib.position(0).limit(1);
            this.ib.put(0, this.reverbFxSlot);
            this.efx.alDeleteAuxiliaryEffectSlots(1, this.ib);
        }
        this.alc.destroyALC();
    }

    @Override
    public void initialize() {
        if (this.decoderThread.isAlive()) {
            throw new IllegalStateException("Initialize already called");
        }
        this.initOpenAL();
        this.decoderThread.setDaemon(true);
        this.decoderThread.setPriority(6);
        this.decoderThread.start();
    }

    private void checkDead() {
        if (this.decoderThread.getState() == Thread.State.TERMINATED) {
            throw new IllegalStateException("Decoding thread is terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        updateRateNanos = 50000000L;
        block5: while (true) {
            startTime = System.nanoTime();
            if (Thread.interrupted()) break;
            var5_4 = this.threadLock;
            synchronized (var5_4) {
                this.updateInDecoderThread(0.05f);
            }
            endTime = System.nanoTime();
            diffTime = endTime - startTime;
            if (diffTime >= updateRateNanos) continue;
            desiredEndTime = startTime + updateRateNanos;
            while (true) {
                if (System.nanoTime() < desiredEndTime) ** break;
                continue block5;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    break block5;
                }
            }
            break;
        }
    }

    @Override
    public void cleanup() {
        if (!this.decoderThread.isAlive()) {
            return;
        }
        this.decoderThread.interrupt();
        try {
            this.decoderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.destroyOpenAL();
    }

    private void updateFilter(Filter f) {
        int id = f.getId();
        if (id == -1) {
            this.ib.position(0).limit(1);
            this.efx.alGenFilters(1, this.ib);
            id = this.ib.get(0);
            f.setId(id);
            this.objManager.registerObject(f);
        }
        if (!(f instanceof LowPassFilter)) {
            throw new UnsupportedOperationException("Filter type unsupported: " + f.getClass().getName());
        }
        LowPassFilter lpf = (LowPassFilter)f;
        this.efx.alFilteri(id, 32769, 1);
        this.efx.alFilterf(id, 1, lpf.getVolume());
        this.efx.alFilterf(id, 2, lpf.getHighFreqVolume());
        f.clearUpdateNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getSourcePlaybackTime(AudioSource src) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return 0.0f;
            }
            if (src.getChannel() < 0) {
                return 0.0f;
            }
            int id = this.channels[src.getChannel()];
            AudioData data = src.getAudioData();
            int playbackOffsetBytes = 0;
            if (data instanceof AudioStream) {
                AudioStream stream = (AudioStream)data;
                int unqueuedBytes = stream.getUnqueuedBufferBytes();
                int unqueuedBytesExtra = this.al.alGetSourcei(id, 4118) * 35280;
                playbackOffsetBytes = unqueuedBytes;
            }
            int bytesPerSecond = data.getSampleRate() * data.getChannels() * data.getBitsPerSample() / 8;
            return (float)(playbackOffsetBytes += this.al.alGetSourcei(id, 4134)) / (float)bytesPerSecond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSourceParam(AudioSource src, AudioParam param) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return;
            }
            if (src.getChannel() < 0) {
                return;
            }
            assert (src.getChannel() >= 0);
            int id = this.channels[src.getChannel()];
            switch (param) {
                case Position: {
                    if (!src.isPositional()) {
                        return;
                    }
                    Vector3f pos = src.getPosition();
                    this.al.alSource3f(id, 4100, pos.x, pos.y, pos.z);
                    break;
                }
                case Velocity: {
                    if (!src.isPositional()) {
                        return;
                    }
                    Vector3f vel = src.getVelocity();
                    this.al.alSource3f(id, 4102, vel.x, vel.y, vel.z);
                    break;
                }
                case MaxDistance: {
                    if (!src.isPositional()) {
                        return;
                    }
                    this.al.alSourcef(id, 4131, src.getMaxDistance());
                    break;
                }
                case RefDistance: {
                    if (!src.isPositional()) {
                        return;
                    }
                    this.al.alSourcef(id, 4128, src.getRefDistance());
                    break;
                }
                case ReverbFilter: {
                    if (!(this.supportEfx && src.isPositional() && src.isReverbEnabled())) {
                        return;
                    }
                    int filter = 0;
                    if (src.getReverbFilter() != null) {
                        Filter f = src.getReverbFilter();
                        if (f.isUpdateNeeded()) {
                            this.updateFilter(f);
                        }
                        filter = f.getId();
                    }
                    this.al.alSource3i(id, 131078, this.reverbFxSlot, 0, filter);
                    break;
                }
                case ReverbEnabled: {
                    if (!this.supportEfx || !src.isPositional()) {
                        return;
                    }
                    if (src.isReverbEnabled()) {
                        this.updateSourceParam(src, AudioParam.ReverbFilter);
                        break;
                    }
                    this.al.alSource3i(id, 131078, 0, 0, 0);
                    break;
                }
                case IsPositional: {
                    if (!src.isPositional()) {
                        this.al.alSourcei(id, 514, 1);
                        this.al.alSource3f(id, 4100, 0.0f, 0.0f, 0.0f);
                        this.al.alSource3f(id, 4102, 0.0f, 0.0f, 0.0f);
                        this.al.alSource3i(id, 131078, 0, 0, 0);
                        break;
                    }
                    this.al.alSourcei(id, 514, 0);
                    this.updateSourceParam(src, AudioParam.Position);
                    this.updateSourceParam(src, AudioParam.Velocity);
                    this.updateSourceParam(src, AudioParam.MaxDistance);
                    this.updateSourceParam(src, AudioParam.RefDistance);
                    this.updateSourceParam(src, AudioParam.ReverbEnabled);
                    break;
                }
                case Direction: {
                    if (!src.isDirectional()) {
                        return;
                    }
                    Vector3f dir = src.getDirection();
                    this.al.alSource3f(id, 4101, dir.x, dir.y, dir.z);
                    break;
                }
                case InnerAngle: {
                    if (!src.isDirectional()) {
                        return;
                    }
                    this.al.alSourcef(id, 4097, src.getInnerAngle());
                    break;
                }
                case OuterAngle: {
                    if (!src.isDirectional()) {
                        return;
                    }
                    this.al.alSourcef(id, 4098, src.getOuterAngle());
                    break;
                }
                case IsDirectional: {
                    if (src.isDirectional()) {
                        this.updateSourceParam(src, AudioParam.Direction);
                        this.updateSourceParam(src, AudioParam.InnerAngle);
                        this.updateSourceParam(src, AudioParam.OuterAngle);
                        this.al.alSourcef(id, 4130, 0.0f);
                        break;
                    }
                    this.al.alSourcef(id, 4097, 360.0f);
                    this.al.alSourcef(id, 4098, 360.0f);
                    this.al.alSourcef(id, 4130, 1.0f);
                    break;
                }
                case DryFilter: {
                    if (!this.supportEfx) {
                        return;
                    }
                    if (src.getDryFilter() != null) {
                        Filter f = src.getDryFilter();
                        if (!f.isUpdateNeeded()) break;
                        this.updateFilter(f);
                        this.al.alSourcei(id, 131077, f.getId());
                        break;
                    }
                    this.al.alSourcei(id, 131077, 0);
                    break;
                }
                case Looping: {
                    if (src.isLooping() && !(src.getAudioData() instanceof AudioStream)) {
                        this.al.alSourcei(id, 4103, 1);
                        break;
                    }
                    this.al.alSourcei(id, 4103, 0);
                    break;
                }
                case Volume: {
                    this.al.alSourcef(id, 4106, src.getVolume());
                    break;
                }
                case Pitch: {
                    this.al.alSourcef(id, 4099, src.getPitch());
                }
            }
        }
    }

    private void setSourceParams(int id, AudioSource src, boolean forceNonLoop) {
        Filter f;
        if (src.isPositional()) {
            Vector3f pos = src.getPosition();
            Vector3f vel = src.getVelocity();
            this.al.alSource3f(id, 4100, pos.x, pos.y, pos.z);
            this.al.alSource3f(id, 4102, vel.x, vel.y, vel.z);
            this.al.alSourcef(id, 4131, src.getMaxDistance());
            this.al.alSourcef(id, 4128, src.getRefDistance());
            this.al.alSourcei(id, 514, 0);
            if (src.isReverbEnabled() && this.supportEfx) {
                int filter = 0;
                if (src.getReverbFilter() != null) {
                    Filter f2 = src.getReverbFilter();
                    if (f2.isUpdateNeeded()) {
                        this.updateFilter(f2);
                    }
                    filter = f2.getId();
                }
                this.al.alSource3i(id, 131078, this.reverbFxSlot, 0, filter);
            }
        } else {
            this.al.alSourcei(id, 514, 1);
            this.al.alSource3f(id, 4100, 0.0f, 0.0f, 0.0f);
            this.al.alSource3f(id, 4102, 0.0f, 0.0f, 0.0f);
        }
        if (src.getDryFilter() != null && this.supportEfx && (f = src.getDryFilter()).isUpdateNeeded()) {
            this.updateFilter(f);
            this.al.alSourcei(id, 131077, f.getId());
        }
        if (forceNonLoop || src.getAudioData() instanceof AudioStream) {
            this.al.alSourcei(id, 4103, 0);
        } else {
            this.al.alSourcei(id, 4103, src.isLooping() ? 1 : 0);
        }
        this.al.alSourcef(id, 4106, src.getVolume());
        this.al.alSourcef(id, 4099, src.getPitch());
        this.al.alSourcef(id, 4132, src.getTimeOffset());
        if (src.isDirectional()) {
            Vector3f dir = src.getDirection();
            this.al.alSource3f(id, 4101, dir.x, dir.y, dir.z);
            this.al.alSourcef(id, 4097, src.getInnerAngle());
            this.al.alSourcef(id, 4098, src.getOuterAngle());
            this.al.alSourcef(id, 4130, 0.0f);
        } else {
            this.al.alSourcef(id, 4097, 360.0f);
            this.al.alSourcef(id, 4098, 360.0f);
            this.al.alSourcef(id, 4130, 1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateListenerParam(Listener listener, ListenerParam param) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return;
            }
            switch (param) {
                case Position: {
                    Vector3f pos = listener.getLocation();
                    this.al.alListener3f(4100, pos.x, pos.y, pos.z);
                    break;
                }
                case Rotation: {
                    Vector3f dir = listener.getDirection();
                    Vector3f up = listener.getUp();
                    this.fb.rewind();
                    this.fb.put(dir.x).put(dir.y).put(dir.z);
                    this.fb.put(up.x).put(up.y).put(up.z);
                    this.fb.flip();
                    this.al.alListener(4111, this.fb);
                    break;
                }
                case Velocity: {
                    Vector3f vel = listener.getVelocity();
                    this.al.alListener3f(4102, vel.x, vel.y, vel.z);
                    break;
                }
                case Volume: {
                    this.al.alListenerf(4106, listener.getVolume());
                }
            }
        }
    }

    private void setListenerParams(Listener listener) {
        Vector3f pos = listener.getLocation();
        Vector3f vel = listener.getVelocity();
        Vector3f dir = listener.getDirection();
        Vector3f up = listener.getUp();
        this.al.alListener3f(4100, pos.x, pos.y, pos.z);
        this.al.alListener3f(4102, vel.x, vel.y, vel.z);
        this.fb.rewind();
        this.fb.put(dir.x).put(dir.y).put(dir.z);
        this.fb.put(up.x).put(up.y).put(up.z);
        this.fb.flip();
        this.al.alListener(4111, this.fb);
        this.al.alListenerf(4106, listener.getVolume());
    }

    private int newChannel() {
        if (this.freeChans.size() > 0) {
            return this.freeChans.remove(0);
        }
        if (this.nextChan < this.channels.length) {
            return this.nextChan++;
        }
        return -1;
    }

    private void freeChannel(int index) {
        if (index == this.nextChan - 1) {
            --this.nextChan;
        } else {
            this.freeChans.add(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnvironment(Environment env) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled || !this.supportEfx) {
                return;
            }
            this.efx.alEffectf(this.reverbFx, 1, env.getDensity());
            this.efx.alEffectf(this.reverbFx, 2, env.getDiffusion());
            this.efx.alEffectf(this.reverbFx, 3, env.getGain());
            this.efx.alEffectf(this.reverbFx, 4, env.getGainHf());
            this.efx.alEffectf(this.reverbFx, 5, env.getDecayTime());
            this.efx.alEffectf(this.reverbFx, 6, env.getDecayHFRatio());
            this.efx.alEffectf(this.reverbFx, 7, env.getReflectGain());
            this.efx.alEffectf(this.reverbFx, 8, env.getReflectDelay());
            this.efx.alEffectf(this.reverbFx, 9, env.getLateReverbGain());
            this.efx.alEffectf(this.reverbFx, 10, env.getLateReverbDelay());
            this.efx.alEffectf(this.reverbFx, 11, env.getAirAbsorbGainHf());
            this.efx.alEffectf(this.reverbFx, 12, env.getRoomRolloffFactor());
            this.efx.alAuxiliaryEffectSloti(this.reverbFxSlot, 1, this.reverbFx);
        }
    }

    private boolean fillBuffer(AudioStream stream, int id) {
        int size;
        int result;
        for (size = 0; size < this.arrayBuf.length && (result = stream.readSamples(this.arrayBuf, size, this.arrayBuf.length - size)) > 0; size += result) {
        }
        if (size == 0) {
            return false;
        }
        this.nativeBuf.clear();
        this.nativeBuf.put(this.arrayBuf, 0, size);
        this.nativeBuf.flip();
        this.al.alBufferData(id, this.convertFormat(stream), this.nativeBuf, size, stream.getSampleRate());
        return true;
    }

    private boolean fillStreamingSource(int sourceId, AudioStream stream, boolean looping) {
        boolean success = false;
        int processed = this.al.alGetSourcei(sourceId, 4118);
        int unqueuedBufferBytes = 0;
        for (int i = 0; i < processed; ++i) {
            this.ib.position(0).limit(1);
            this.al.alSourceUnqueueBuffers(sourceId, 1, this.ib);
            int buffer = this.ib.get(0);
            unqueuedBufferBytes += 35280;
            boolean active = this.fillBuffer(stream, buffer);
            if (!active && !stream.isEOF()) {
                throw new AssertionError();
            }
            if (!active && looping) {
                stream.setTime(0.0f);
                active = this.fillBuffer(stream, buffer);
                if (!active) {
                    throw new IllegalStateException("Looping streaming source was rewinded but could not be filled");
                }
            }
            if (!active) break;
            this.ib.position(0).limit(1);
            this.ib.put(0, buffer);
            this.al.alSourceQueueBuffers(sourceId, 1, this.ib);
            success = true;
        }
        stream.setUnqueuedBufferBytes(stream.getUnqueuedBufferBytes() + unqueuedBufferBytes);
        return success;
    }

    private void attachStreamToSource(int sourceId, AudioStream stream, boolean looping) {
        boolean success = false;
        if (stream.isEOF()) {
            stream.setTime(0.0f);
        }
        for (int id : stream.getIds()) {
            boolean active = this.fillBuffer(stream, id);
            if (!active && !stream.isEOF()) {
                throw new AssertionError();
            }
            if (!active && looping) {
                stream.setTime(0.0f);
                active = this.fillBuffer(stream, id);
                if (!active) {
                    throw new IllegalStateException("Looping streaming source was rewinded but could not be filled");
                }
            }
            if (!active) continue;
            this.ib.position(0).limit(1);
            this.ib.put(id).flip();
            this.al.alSourceQueueBuffers(sourceId, 1, this.ib);
            success = true;
        }
        if (!success) {
            throw new IllegalStateException("No valid data could be read from stream");
        }
    }

    private boolean attachBufferToSource(int sourceId, AudioBuffer buffer) {
        this.al.alSourcei(sourceId, 4105, buffer.getId());
        return true;
    }

    private void attachAudioToSource(int sourceId, AudioData data, boolean looping) {
        if (data instanceof AudioBuffer) {
            this.attachBufferToSource(sourceId, (AudioBuffer)data);
        } else if (data instanceof AudioStream) {
            this.attachStreamToSource(sourceId, (AudioStream)data, looping);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void clearChannel(int index) {
        if (this.chanSrcs[index] != null) {
            AudioSource pas;
            AudioSource src = this.chanSrcs[index];
            int sourceId = this.channels[index];
            this.al.alSourceStop(sourceId);
            this.al.alSourcei(sourceId, 4105, 0);
            if (src.getDryFilter() != null && this.supportEfx) {
                this.al.alSourcei(sourceId, 131077, 0);
            }
            if (src.isPositional() && (pas = src).isReverbEnabled() && this.supportEfx) {
                this.al.alSource3i(sourceId, 131078, 0, 0, 0);
            }
            this.chanSrcs[index] = null;
        }
    }

    private AudioSource.Status convertStatus(int oalStatus) {
        switch (oalStatus) {
            case 4113: 
            case 4116: {
                return AudioSource.Status.Stopped;
            }
            case 4115: {
                return AudioSource.Status.Paused;
            }
            case 4114: {
                return AudioSource.Status.Playing;
            }
        }
        throw new UnsupportedOperationException("Unrecognized OAL state: " + oalStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(float tpf) {
        Object object = this.threadLock;
        synchronized (object) {
            this.updateInRenderThread(tpf);
        }
    }

    public void updateInRenderThread(float tpf) {
        if (this.audioDisabled) {
            return;
        }
        for (int i = 0; i < this.channels.length; ++i) {
            AudioSource src = this.chanSrcs[i];
            if (src == null) continue;
            int sourceId = this.channels[i];
            boolean boundSource = i == src.getChannel();
            boolean reclaimChannel = false;
            AudioSource.Status oalStatus = this.convertStatus(this.al.alGetSourcei(sourceId, 4112));
            if (!boundSource) {
                if (oalStatus == AudioSource.Status.Stopped) {
                    this.clearChannel(i);
                    this.freeChannel(i);
                    continue;
                }
                if (oalStatus == AudioSource.Status.Paused) {
                    throw new AssertionError((Object)"Instanced audio cannot be paused");
                }
                continue;
            }
            AudioSource.Status jmeStatus = src.getStatus();
            if (oalStatus != jmeStatus) {
                if (oalStatus == AudioSource.Status.Stopped && jmeStatus == AudioSource.Status.Playing) {
                    if (src.getAudioData() instanceof AudioStream) {
                        AudioStream stream = (AudioStream)src.getAudioData();
                        if (stream.isEOF() && !src.isLooping()) {
                            reclaimChannel = true;
                        }
                    } else {
                        if (src.isLooping()) {
                            throw new AssertionError((Object)"Unexpected state: A looping sound has stopped playing");
                        }
                        reclaimChannel = true;
                    }
                    if (!reclaimChannel) continue;
                    src.setStatus(AudioSource.Status.Stopped);
                    src.setChannel(-1);
                    this.clearChannel(i);
                    this.freeChannel(i);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected sound status. OAL: " + (Object)((Object)oalStatus) + ", JME: " + (Object)((Object)jmeStatus)));
            }
            if (oalStatus == AudioSource.Status.Stopped) {
                throw new AssertionError((Object)("Channel " + i + " was not reclaimed"));
            }
        }
    }

    public void updateInDecoderThread(float tpf) {
        if (this.audioDisabled) {
            return;
        }
        for (int i = 0; i < this.channels.length; ++i) {
            AudioSource src = this.chanSrcs[i];
            if (src == null || !(src.getAudioData() instanceof AudioStream)) continue;
            int sourceId = this.channels[i];
            AudioStream stream = (AudioStream)src.getAudioData();
            AudioSource.Status oalStatus = this.convertStatus(this.al.alGetSourcei(sourceId, 4112));
            AudioSource.Status jmeStatus = src.getStatus();
            boolean buffersWereFilled = this.fillStreamingSource(sourceId, stream, src.isLooping());
            if (!buffersWereFilled) continue;
            if (oalStatus == AudioSource.Status.Stopped && jmeStatus == AudioSource.Status.Playing) {
                logger.log(Level.WARNING, "Buffer starvation occurred while playing stream");
                this.al.alSourcePlay(sourceId);
                continue;
            }
            if (oalStatus != AudioSource.Status.Playing || jmeStatus != AudioSource.Status.Playing) {
                throw new AssertionError();
            }
        }
        this.objManager.deleteUnused(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(Listener listener) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return;
            }
            if (this.listener != null) {
                this.listener.setRenderer(null);
            }
            this.listener = listener;
            this.listener.setRenderer(this);
            this.setListenerParams(listener);
        }
    }

    @Override
    public void pauseAll() {
        if (!this.supportPauseDevice) {
            throw new UnsupportedOperationException("Pause device is NOT supported!");
        }
        this.alc.alcDevicePauseSOFT();
    }

    @Override
    public void resumeAll() {
        if (!this.supportPauseDevice) {
            throw new UnsupportedOperationException("Pause device is NOT supported!");
        }
        this.alc.alcDeviceResumeSOFT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playSourceInstance(AudioSource src) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            int index;
            if (this.audioDisabled) {
                return;
            }
            if (src.getAudioData() instanceof AudioStream) {
                throw new UnsupportedOperationException("Cannot play instances of audio streams. Use play() instead.");
            }
            if (src.getAudioData().isUpdateNeeded()) {
                this.updateAudioData(src.getAudioData());
            }
            if ((index = this.newChannel()) == -1) {
                return;
            }
            int sourceId = this.channels[index];
            this.clearChannel(index);
            this.setSourceParams(sourceId, src, true);
            this.attachAudioToSource(sourceId, src.getAudioData(), false);
            this.chanSrcs[index] = src;
            this.al.alSourcePlay(sourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playSource(AudioSource src) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return;
            }
            if (src.getStatus() == AudioSource.Status.Playing) {
                return;
            }
            if (src.getStatus() == AudioSource.Status.Stopped) {
                int index = this.newChannel();
                if (index == -1) {
                    logger.log(Level.WARNING, "No channel available to play {0}", src);
                    return;
                }
                this.clearChannel(index);
                src.setChannel(index);
                AudioData data = src.getAudioData();
                if (data.isUpdateNeeded()) {
                    this.updateAudioData(data);
                }
                this.chanSrcs[index] = src;
                this.setSourceParams(this.channels[index], src, false);
                this.attachAudioToSource(this.channels[index], data, src.isLooping());
            }
            this.al.alSourcePlay(this.channels[src.getChannel()]);
            src.setStatus(AudioSource.Status.Playing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseSource(AudioSource src) {
        this.checkDead();
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return;
            }
            if (src.getStatus() == AudioSource.Status.Playing) {
                assert (src.getChannel() != -1);
                this.al.alSourcePause(this.channels[src.getChannel()]);
                src.setStatus(AudioSource.Status.Paused);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSource(AudioSource src) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.audioDisabled) {
                return;
            }
            if (src.getStatus() != AudioSource.Status.Stopped) {
                int chan = src.getChannel();
                assert (chan != -1);
                src.setStatus(AudioSource.Status.Stopped);
                src.setChannel(-1);
                this.clearChannel(chan);
                this.freeChannel(chan);
                if (src.getAudioData() instanceof AudioStream) {
                    AudioStream stream = (AudioStream)src.getAudioData();
                    if (stream.isSeekable()) {
                        stream.setTime(0.0f);
                    } else {
                        stream.close();
                    }
                }
            }
        }
    }

    private int convertFormat(AudioData ad) {
        switch (ad.getBitsPerSample()) {
            case 8: {
                if (ad.getChannels() == 1) {
                    return 4352;
                }
                if (ad.getChannels() != 2) break;
                return 4354;
            }
            case 16: {
                if (ad.getChannels() == 1) {
                    return 4353;
                }
                return 4355;
            }
        }
        throw new UnsupportedOperationException("Unsupported channels/bits combination: bits=" + ad.getBitsPerSample() + ", channels=" + ad.getChannels());
    }

    private void updateAudioBuffer(AudioBuffer ab) {
        int id = ab.getId();
        if (ab.getId() == -1) {
            this.ib.position(0).limit(1);
            this.al.alGenBuffers(1, this.ib);
            id = this.ib.get(0);
            ab.setId(id);
            this.objManager.registerObject(ab);
        }
        ab.getData().clear();
        this.al.alBufferData(id, this.convertFormat(ab), ab.getData(), ab.getData().capacity(), ab.getSampleRate());
        ab.clearUpdateNeeded();
    }

    private void updateAudioStream(AudioStream as) {
        if (as.getIds() != null) {
            this.deleteAudioData(as);
        }
        int[] ids = new int[5];
        this.ib.position(0).limit(5);
        this.al.alGenBuffers(5, this.ib);
        this.ib.position(0).limit(5);
        this.ib.get(ids);
        as.setIds(ids);
        as.clearUpdateNeeded();
    }

    private void updateAudioData(AudioData ad) {
        if (ad instanceof AudioBuffer) {
            this.updateAudioBuffer((AudioBuffer)ad);
        } else if (ad instanceof AudioStream) {
            this.updateAudioStream((AudioStream)ad);
        }
    }

    @Override
    public void deleteFilter(Filter filter) {
        int id = filter.getId();
        if (id != -1) {
            this.ib.position(0).limit(1);
            this.ib.put(id).flip();
            this.efx.alDeleteFilters(1, this.ib);
            filter.resetObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAudioData(AudioData ad) {
        Object object = this.threadLock;
        synchronized (object) {
            AudioStream as;
            int[] ids;
            if (this.audioDisabled) {
                return;
            }
            if (ad instanceof AudioBuffer) {
                AudioBuffer ab = (AudioBuffer)ad;
                int id = ab.getId();
                if (id != -1) {
                    this.ib.put(0, id);
                    this.ib.position(0).limit(1);
                    this.al.alDeleteBuffers(1, this.ib);
                    ab.resetObject();
                }
            } else if (ad instanceof AudioStream && (ids = (as = (AudioStream)ad).getIds()) != null) {
                this.ib.clear();
                this.ib.put(ids).flip();
                this.al.alDeleteBuffers(ids.length, this.ib);
                as.resetObject();
            }
        }
    }
}

