/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.TechniqueDef;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderKey;
import com.jme3.shader.Uniform;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;

public class Technique {
    private static final Logger logger = Logger.getLogger(Technique.class.getName());
    private TechniqueDef def;
    private Material owner;
    private ArrayList<Uniform> worldBindUniforms;
    private DefineList defines;
    private Shader shader;
    private boolean needReload = true;

    public Technique(Material owner, TechniqueDef def) {
        this.owner = owner;
        this.def = def;
        this.worldBindUniforms = new ArrayList();
        this.defines = new DefineList();
    }

    public Technique() {
    }

    public TechniqueDef getDef() {
        return this.def;
    }

    public Shader getShader() {
        return this.shader;
    }

    public List<Uniform> getWorldBindUniforms() {
        return this.worldBindUniforms;
    }

    void notifyParamChanged(String paramName, VarType type, Object value) {
        String defineName = this.def.getShaderParamDefine(paramName);
        if (defineName != null) {
            this.needReload = value == null ? this.defines.remove(defineName) || this.needReload : this.defines.set(defineName, type, value) || this.needReload;
        }
    }

    void updateUniformParam(String paramName, VarType type, Object value) {
        if (paramName == null) {
            throw new IllegalArgumentException();
        }
        Uniform u = this.shader.getUniform(paramName);
        switch (type) {
            case TextureBuffer: 
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureCubeMap: 
            case Int: {
                u.setValue(VarType.Int, value);
                break;
            }
            default: {
                u.setValue(type, value);
            }
        }
    }

    public boolean isNeedReload() {
        return this.needReload;
    }

    public void makeCurrent(AssetManager assetManager, boolean techniqueSwitched, EnumSet<Caps> rendererCaps, RenderManager rm) {
        if (techniqueSwitched) {
            if (this.defines.update(this.owner.getParamsMap(), this.def)) {
                this.needReload = true;
            }
            if (this.getDef().getLightMode() == TechniqueDef.LightMode.SinglePass) {
                this.defines.set("SINGLE_PASS_LIGHTING", VarType.Boolean, true);
                this.defines.set("NB_LIGHTS", VarType.Int, rm.getSinglePassLightBatchSize() * 3);
            } else {
                this.defines.set("SINGLE_PASS_LIGHTING", VarType.Boolean, null);
            }
        }
        if (this.needReload) {
            this.loadShader(assetManager, rendererCaps);
        }
    }

    private void loadShader(AssetManager manager, EnumSet<Caps> rendererCaps) {
        ShaderKey key = new ShaderKey(this.getAllDefines(), this.def.getShaderProgramLanguages(), this.def.getShaderProgramNames());
        if (this.getDef().isUsingShaderNodes()) {
            manager.getShaderGenerator(rendererCaps).initialize(this);
            key.setUsesShaderNodes(true);
        }
        this.shader = manager.loadShader(key);
        this.worldBindUniforms.clear();
        if (this.def.getWorldBindings() != null) {
            for (UniformBinding binding : this.def.getWorldBindings()) {
                Uniform uniform = this.shader.getUniform("g_" + binding.name());
                uniform.setBinding(binding);
                this.worldBindUniforms.add(uniform);
            }
        }
        this.needReload = false;
    }

    public DefineList getAllDefines() {
        DefineList allDefines = new DefineList();
        allDefines.addFrom(this.def.getShaderPresetDefines());
        allDefines.addFrom(this.defines);
        return allDefines;
    }
}

