/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Skeleton;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.debug.SkeletonInterBoneWire;
import com.jme3.scene.debug.SkeletonPoints;
import com.jme3.scene.debug.SkeletonWire;
import java.util.Map;

public class SkeletonDebugger
extends Node {
    private SkeletonWire wires;
    private SkeletonPoints points;
    private SkeletonInterBoneWire interBoneWires;

    public SkeletonDebugger() {
    }

    public SkeletonDebugger(String name, Skeleton skeleton) {
        this(name, skeleton, null);
    }

    public SkeletonDebugger(String name, Skeleton skeleton, Map<Integer, Float> boneLengths) {
        super(name);
        this.wires = new SkeletonWire(skeleton, boneLengths);
        this.points = new SkeletonPoints(skeleton, boneLengths);
        this.attachChild(new Geometry(name + "_wires", this.wires));
        this.attachChild(new Geometry(name + "_points", this.points));
        if (boneLengths != null) {
            this.interBoneWires = new SkeletonInterBoneWire(skeleton, boneLengths);
            this.attachChild(new Geometry(name + "_interwires", this.interBoneWires));
        }
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.wires.updateGeometry();
        this.points.updateGeometry();
        if (this.interBoneWires != null) {
            this.interBoneWires.updateGeometry();
        }
    }

    public SkeletonPoints getPoints() {
        return this.points;
    }

    public SkeletonWire getWires() {
        return this.wires;
    }

    public SkeletonInterBoneWire getInterBoneWires() {
        return this.interBoneWires;
    }
}

